/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.client.renderer.texture.atlas.BlueprintPalettedPermutations;
import com.teamabnormals.blueprint.core.other.tags.BlueprintTrimMaterialTags;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="blueprint", value={Dist.CLIENT})
public class BlueprintTrims {
    public static final ResourceLocation ARMOR_TRIMS_ATLAS = new ResourceLocation("armor_trims");
    private static final ResourceLocation PALETTE_KEY = new ResourceLocation("trims/color_palettes/trim_palette");
    private static final HashMap<String, ResourceLocation> PERMUTATIONS = (HashMap)Util.m_137469_(new HashMap(), map -> {
        map.put("quartz", new ResourceLocation("trims/color_palettes/quartz"));
        map.put("iron", new ResourceLocation("trims/color_palettes/iron"));
        map.put("gold", new ResourceLocation("trims/color_palettes/gold"));
        map.put("diamond", new ResourceLocation("trims/color_palettes/diamond"));
        map.put("netherite", new ResourceLocation("trims/color_palettes/netherite"));
        map.put("redstone", new ResourceLocation("trims/color_palettes/redstone"));
        map.put("copper", new ResourceLocation("trims/color_palettes/copper"));
        map.put("emerald", new ResourceLocation("trims/color_palettes/emerald"));
        map.put("lapis", new ResourceLocation("trims/color_palettes/lapis"));
        map.put("amethyst", new ResourceLocation("trims/color_palettes/amethyst"));
        map.put("iron_darker", new ResourceLocation("trims/color_palettes/iron_darker"));
        map.put("gold_darker", new ResourceLocation("trims/color_palettes/gold_darker"));
        map.put("diamond_darker", new ResourceLocation("trims/color_palettes/diamond_darker"));
        map.put("netherite_darker", new ResourceLocation("trims/color_palettes/netherite_darker"));
    });
    private static final List<ResourceLocation> ITEM_TRIMS = List.of(new ResourceLocation("trims/items/helmet_trim"), new ResourceLocation("trims/items/chestplate_trim"), new ResourceLocation("trims/items/leggings_trim"), new ResourceLocation("trims/items/boots_trim"));
    public static final ResourceLocation TRIM_TYPE_PREDICATE_ID = new ResourceLocation("blueprint", "trim_type");
    private static final IdentityHashMap<ResourceKey<TrimMaterial>, Map<ArmorMaterial, String>> TRIM_MATERIAL_ARMOR_MATERIAL_OVERRIDES = new IdentityHashMap();
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Pair<TrimMaterial, Float>> GENERATED_OVERRIDE_INDICES = new LinkedHashMap();
    private static final ArrayList<RevertibleOverrides> REVERTIBLE_OVERRIDES = new ArrayList();

    public static void init() {
        ItemProperties.registerGeneric((ResourceLocation)TRIM_TYPE_PREDICATE_ID, (stack, level, entity, num) -> {
            Pair<TrimMaterial, Float> pair;
            Optional key;
            Optional<Holder> trimMaterialHolder;
            if (stack.m_204117_(ItemTags.f_265942_) && level != null && (trimMaterialHolder = ArmorTrim.m_266285_((RegistryAccess)level.m_9598_(), (ItemStack)stack).map(ArmorTrim::m_266210_)).isPresent() && (key = trimMaterialHolder.get().m_203543_()).isPresent() && (pair = GENERATED_OVERRIDE_INDICES.get(key.get())) != null) {
                return ((Float)pair.getSecond()).floatValue();
            }
            return Float.NEGATIVE_INFINITY;
        });
    }

    @SafeVarargs
    public static BlueprintPalettedPermutations patternPermutationsOfVanillaMaterials(ResourceKey<TrimPattern> ... keys) {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>(keys.length << 1);
        for (ResourceKey<TrimPattern> key : keys) {
            ResourceLocation location = key.m_135782_();
            textures.add(location.m_247266_(string -> "trims/models/armor/" + string));
            textures.add(location.m_247266_(string -> "trims/models/armor/" + string + "_leggings"));
        }
        return new BlueprintPalettedPermutations((Either<List<SpriteSource>, List<ResourceLocation>>)Either.right(textures), PALETTE_KEY, PERMUTATIONS);
    }

    @SafeVarargs
    private static HashMap<String, ResourceLocation> getPermutations(ResourceKey<TrimMaterial> ... keys) {
        HashMap<String, ResourceLocation> permutations = new HashMap<String, ResourceLocation>();
        for (ResourceKey<TrimMaterial> key : keys) {
            ResourceLocation location = key.m_135782_();
            permutations.put(location.m_135827_() + "_" + location.m_135815_(), location.m_247266_(string -> "trims/color_palettes/" + string));
        }
        return permutations;
    }

    @SafeVarargs
    public static BlueprintPalettedPermutations materialPatternPermutations(ResourceKey<TrimMaterial> ... keys) {
        return new BlueprintPalettedPermutations((Either<List<SpriteSource>, List<ResourceLocation>>)Either.left(List.of(new DirectoryLister("trims/models/armor", "trims/models/armor/"))), PALETTE_KEY, BlueprintTrims.getPermutations(keys));
    }

    @SafeVarargs
    public static BlueprintPalettedPermutations materialPermutationsForItemLayers(ResourceKey<TrimMaterial> ... keys) {
        return new BlueprintPalettedPermutations((Either<List<SpriteSource>, List<ResourceLocation>>)Either.right(ITEM_TRIMS), PALETTE_KEY, BlueprintTrims.getPermutations(keys));
    }

    public static synchronized void registerArmorMaterialOverrides(ResourceKey<TrimMaterial> key, Map<ArmorMaterial, String> overrideArmorMaterials) {
        TRIM_MATERIAL_ARMOR_MATERIAL_OVERRIDES.put(key, overrideArmorMaterials);
    }

    public static Map<ArmorMaterial, String> getOverrideArmorMaterials(ResourceKey<TrimMaterial> key) {
        return TRIM_MATERIAL_ARMOR_MATERIAL_OVERRIDES.get(key);
    }

    private static ModelResourceLocation generateModelLocation(String namespace, ResourceLocation itemName, String assetName, ArrayList<ItemOverride.Predicate> predicates) {
        StringBuilder builder = new StringBuilder();
        builder.append("item/").append(itemName.m_135827_()).append('/').append(itemName.m_135815_()).append('_').append(assetName).append("_trim");
        for (ItemOverride.Predicate predicate : predicates) {
            builder.append('_').append(predicate.m_173459_().m_135827_()).append('_');
            String path = predicate.m_173459_().m_135815_();
            int length = path.length();
            for (int i = 0; i < length; ++i) {
                char c = path.charAt(i);
                builder.append(c == '/' ? (char)'_' : (char)c);
            }
            builder.append('_').append(predicate.m_173460_());
        }
        return new ModelResourceLocation("blueprint", builder.toString(), "inventory");
    }

    private static ItemOverrides.BakedOverride createBakedOverride(ItemOverrides.PropertyMatcher[] matchers, ModelBakery bakery, BiFunction<ResourceLocation, Material, TextureAtlasSprite> textureGetter, ModelResourceLocation location) {
        ModelBakery modelBakery = bakery;
        Objects.requireNonNull(modelBakery);
        return new ItemOverrides.BakedOverride(matchers, new ModelBakery.ModelBakerImpl(modelBakery, textureGetter, (ResourceLocation)location).m_245240_((ResourceLocation)location, (ModelState)BlockModelRotation.X0_Y0));
    }

    private static void modifyTrimmableItemModels(RegistryAccess registryAccess) {
        if (GENERATED_OVERRIDE_INDICES.isEmpty()) {
            return;
        }
        Registry itemRegistry = registryAccess.m_175515_(Registries.f_256913_);
        Optional trimmableArmorTag = itemRegistry.m_203431_(ItemTags.f_265942_);
        if (trimmableArmorTag.isEmpty()) {
            return;
        }
        Registry trimMaterials = registryAccess.m_175515_(Registries.f_266076_);
        int armorItemTypeCount = ITEM_TRIMS.size();
        HashMap[] trimTextureForArmorItemType = new HashMap[armorItemTypeCount];
        for (int i = 0; i < armorItemTypeCount; ++i) {
            HashMap<Float, ResourceLocation> map = new HashMap<Float, ResourceLocation>();
            ResourceLocation trimTextureBase = ITEM_TRIMS.get(i);
            for (Map.Entry entry : trimMaterials.m_6579_()) {
                if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("minecraft")) continue;
                TrimMaterial material2 = (TrimMaterial)entry.getValue();
                map.put(Float.valueOf(material2.f_265933_()), trimTextureBase.m_266382_("_" + material2.f_265854_()));
            }
            trimTextureForArmorItemType[i] = map;
        }
        ModelManager modelManager = Minecraft.m_91087_().m_91304_();
        ModelBakery modelBakery = modelManager.getModelBakery();
        Map unbakedModels = modelBakery.f_119212_;
        BiFunction<ResourceLocation, Material, TextureAtlasSprite> textureGetter = (location, material) -> modelManager.m_119428_(material.m_119193_()).m_118316_(material.m_119203_());
        ((HolderSet.Named)trimmableArmorTag.get()).forEach(itemHolder -> {
            Object patt11528$temp = itemHolder.get();
            if (!(patt11528$temp instanceof ArmorItem)) {
                return;
            }
            ArmorItem armorItem = (ArmorItem)patt11528$temp;
            Optional itemKeyOptional = itemHolder.m_203543_();
            if (itemKeyOptional.isEmpty()) {
                return;
            }
            ResourceLocation itemName = ((ResourceKey)itemKeyOptional.get()).m_135782_();
            ModelResourceLocation inventoryModelLocation = new ModelResourceLocation(itemName, "inventory");
            BakedModel inventoryModel = modelManager.m_119422_(inventoryModelLocation);
            ItemOverrides bakedModelOverrides = inventoryModel.m_7343_();
            ItemOverrides.BakedOverride[] overrides = bakedModelOverrides.f_111735_;
            int overridesLength = overrides.length;
            if (overridesLength == 0) {
                return;
            }
            UnbakedModel unbakedInventoryModel = (UnbakedModel)unbakedModels.get(inventoryModelLocation);
            if (!(unbakedInventoryModel instanceof BlockModel)) {
                return;
            }
            BlockModel unbakedBlockModel = (BlockModel)unbakedInventoryModel;
            List unbakedOverrides = unbakedBlockModel.m_111484_();
            if (unbakedOverrides.size() > overridesLength) {
                return;
            }
            int armorItemTypeIndex = armorItem.m_266204_().ordinal();
            ResourceLocation armorTrimTypeLocation = ITEM_TRIMS.get(armorItemTypeIndex);
            HashMap indexToItemTrimTexture = trimTextureForArmorItemType[armorItemTypeIndex];
            HashMap significantOverrides = new HashMap();
            for (int i = unbakedOverrides.size() - 1; i > -1; --i) {
                ItemOverride override = (ItemOverride)unbakedOverrides.get(i);
                UnbakedModel unbakedOverrideModel = (UnbakedModel)unbakedModels.get(override.m_111718_());
                if (!(unbakedOverrideModel instanceof BlockModel)) continue;
                BlockModel overrideBlockModel = (BlockModel)unbakedOverrideModel;
                Iterator predicatesIterator = override.m_173449_().iterator();
                boolean foundReplicableTrimOverride = false;
                ArrayList<ItemOverride.Predicate> predicates = new ArrayList<ItemOverride.Predicate>();
                ArrayList trimKeysInTextureMap = new ArrayList();
                while (predicatesIterator.hasNext()) {
                    ItemOverride.Predicate predicate = (ItemOverride.Predicate)predicatesIterator.next();
                    if (!foundReplicableTrimOverride && predicate.m_173459_().equals((Object)ItemModelGenerators.f_265922_)) {
                        ResourceLocation validTexture = (ResourceLocation)indexToItemTrimTexture.get(Float.valueOf(predicate.m_173460_()));
                        if (validTexture == null) break;
                        for (Map.Entry entry : overrideBlockModel.f_111417_.entrySet()) {
                            Material material;
                            Optional materialOptional = ((Either)entry.getValue()).left();
                            if (materialOptional.isEmpty() || !(material = (Material)materialOptional.get()).m_119193_().equals((Object)TextureAtlas.f_118259_) || !material.m_119203_().equals((Object)validTexture)) continue;
                            trimKeysInTextureMap.add((String)entry.getKey());
                            foundReplicableTrimOverride = true;
                        }
                        if (foundReplicableTrimOverride) continue;
                        break;
                    }
                    predicates.add(predicate);
                }
                if (!foundReplicableTrimOverride) continue;
                significantOverrides.putIfAbsent(predicates, Pair.of((Object)overrideBlockModel, trimKeysInTextureMap));
            }
            if (significantOverrides.isEmpty()) {
                return;
            }
            Object2IntOpenHashMap propertyToIndex = new Object2IntOpenHashMap();
            propertyToIndex.defaultReturnValue(-1);
            ResourceLocation[] properties = bakedModelOverrides.f_173461_;
            int oldLength = properties.length;
            ResourceLocation[] newProperties = new ResourceLocation[oldLength + 1];
            for (int i = 0; i < oldLength; ++i) {
                newProperties[i] = properties[i];
                propertyToIndex.put((Object)newProperties[i], i);
            }
            newProperties[oldLength] = TRIM_TYPE_PREDICATE_ID;
            bakedModelOverrides.f_173461_ = newProperties;
            ArmorMaterial armorMaterial = armorItem.m_40401_();
            ItemOverrides.BakedOverride[] bakedOverridesToAdd = new ItemOverrides.BakedOverride[GENERATED_OVERRIDE_INDICES.size() * significantOverrides.size()];
            int i = bakedOverridesToAdd.length;
            for (Map.Entry entry : GENERATED_OVERRIDE_INDICES.entrySet()) {
                Pair value = (Pair)entry.getValue();
                TrimMaterial trimMaterial = (TrimMaterial)value.getFirst();
                ResourceKey trimMaterialKey = (ResourceKey)entry.getKey();
                String trimMaterialNamespace = trimMaterialKey.m_135782_().m_135827_();
                Map<ArmorMaterial, String> armorMaterialOverrides = BlueprintTrims.getOverrideArmorMaterials((ResourceKey<TrimMaterial>)trimMaterialKey);
                String assetName = armorMaterialOverrides != null ? armorMaterialOverrides.getOrDefault(armorMaterial, trimMaterial.f_265854_()) : trimMaterial.f_265854_();
                float overrideIndex = ((Float)value.getSecond()).floatValue();
                ResourceLocation textureLocation = armorTrimTypeLocation.m_266382_("_" + assetName);
                Either texture = Either.left((Object)new Material(TextureAtlas.f_118259_, textureLocation));
                block5: for (Map.Entry significantOverride : significantOverrides.entrySet()) {
                    ArrayList predicates = (ArrayList)significantOverride.getKey();
                    int predicateCount = predicates.size();
                    ItemOverrides.PropertyMatcher[] matchers = new ItemOverrides.PropertyMatcher[predicateCount + 1];
                    matchers[0] = new ItemOverrides.PropertyMatcher(oldLength, overrideIndex);
                    for (int j = 0; j < predicateCount; ++j) {
                        ItemOverride.Predicate predicate = (ItemOverride.Predicate)predicates.get(j);
                        int index = propertyToIndex.getInt((Object)predicate.m_173459_());
                        if (index <= 0) continue block5;
                        matchers[j + 1] = new ItemOverrides.PropertyMatcher(index, predicate.m_173460_());
                    }
                    Pair modelAndReplaceableTextures = (Pair)significantOverride.getValue();
                    BlockModel model = (BlockModel)modelAndReplaceableTextures.getFirst();
                    ModelResourceLocation modelResourceLocation = BlueprintTrims.generateModelLocation(trimMaterialNamespace, itemName, assetName, predicates);
                    if (unbakedModels.containsKey(modelResourceLocation)) {
                        bakedOverridesToAdd[--i] = BlueprintTrims.createBakedOverride(matchers, modelBakery, textureGetter, modelResourceLocation);
                        continue;
                    }
                    ArrayList replaceableTextures = (ArrayList)modelAndReplaceableTextures.getSecond();
                    Map textureMap = model.f_111417_;
                    Either[] oldValues = new Either[replaceableTextures.size()];
                    int j = 0;
                    while (j < replaceableTextures.size()) {
                        String replaceableTexture = (String)replaceableTextures.get(j);
                        Either oldValue = (Either)textureMap.get(replaceableTexture);
                        oldValues[j++] = oldValue;
                        textureMap.put(replaceableTexture, texture);
                    }
                    unbakedModels.put(modelResourceLocation, model);
                    bakedOverridesToAdd[--i] = BlueprintTrims.createBakedOverride(matchers, modelBakery, textureGetter, modelResourceLocation);
                    j = 0;
                    while (j < replaceableTextures.size()) {
                        textureMap.put((String)replaceableTextures.get(j), oldValues[j++]);
                    }
                    unbakedModels.remove(modelResourceLocation);
                }
            }
            int bakedOverridesToAddLength = bakedOverridesToAdd.length;
            int n = bakedOverridesToAddLength - i;
            ItemOverrides.BakedOverride[] newOverrides = new ItemOverrides.BakedOverride[overridesLength + n];
            System.arraycopy(bakedOverridesToAdd, i, newOverrides, 0, n);
            System.arraycopy(overrides, 0, newOverrides, n, overridesLength);
            bakedModelOverrides.f_111735_ = newOverrides;
            REVERTIBLE_OVERRIDES.add(new RevertibleOverrides(bakedModelOverrides, overrides, properties));
        });
    }

    @SubscribeEvent
    public static void onClientLoggingIntoServer(ClientPlayerNetworkEvent.LoggingIn event) {
        RegistryAccess registryAccess = event.getPlayer().f_108545_.m_9598_();
        Registry trimMaterials = registryAccess.m_175515_(Registries.f_266076_);
        Optional neededTrimMaterialsOptional = trimMaterials.m_203431_(BlueprintTrimMaterialTags.GENERATES_OVERRIDES);
        if (neededTrimMaterialsOptional.isEmpty()) {
            return;
        }
        HolderSet.Named neededTrimMaterials = (HolderSet.Named)neededTrimMaterialsOptional.get();
        if (neededTrimMaterials.m_203632_() == 0) {
            return;
        }
        neededTrimMaterials.forEach(trimMaterialHolder -> {
            Optional key = trimMaterialHolder.m_203543_();
            if (key.isEmpty()) {
                return;
            }
            GENERATED_OVERRIDE_INDICES.put((ResourceKey<TrimMaterial>)((ResourceKey)key.get()), (Pair<TrimMaterial, Float>)Pair.of((Object)((TrimMaterial)trimMaterialHolder.m_203334_()), (Object)Float.valueOf(GENERATED_OVERRIDE_INDICES.size())));
        });
        BlueprintTrims.modifyTrimmableItemModels(registryAccess);
    }

    @SubscribeEvent
    public static void onClientLoggingOutOfServer(ClientPlayerNetworkEvent.LoggingOut event) {
        for (int i = REVERTIBLE_OVERRIDES.size() - 1; i > -1; --i) {
            REVERTIBLE_OVERRIDES.remove(i).revert();
        }
        GENERATED_OVERRIDE_INDICES.clear();
    }

    public static void onModelsBaked(ModelEvent.BakingCompleted event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        REVERTIBLE_OVERRIDES.clear();
        BlueprintTrims.modifyTrimmableItemModels(level.m_9598_());
    }

    private record RevertibleOverrides(ItemOverrides itemOverrides, ItemOverrides.BakedOverride[] overrides, ResourceLocation[] properties) {
        private void revert() {
            this.itemOverrides.f_111735_ = this.overrides;
            this.itemOverrides.f_173461_ = this.properties;
        }
    }
}

