/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.client.BlueprintShaders;
import com.teamabnormals.blueprint.client.RewardHandler;
import com.teamabnormals.blueprint.client.renderer.BlueprintBoatRenderer;
import com.teamabnormals.blueprint.client.renderer.block.BlueprintChestBlockEntityRenderer;
import com.teamabnormals.blueprint.client.renderer.texture.atlas.BlueprintSpriteSources;
import com.teamabnormals.blueprint.client.screen.splash.BlueprintSplashManager;
import com.teamabnormals.blueprint.common.block.BlueprintChiseledBookShelfBlock;
import com.teamabnormals.blueprint.common.capability.chunkloading.ChunkLoaderCapability;
import com.teamabnormals.blueprint.common.capability.chunkloading.ChunkLoaderEvents;
import com.teamabnormals.blueprint.common.network.MessageC2SUpdateSlabfishHat;
import com.teamabnormals.blueprint.common.network.entity.MessageS2CEndimation;
import com.teamabnormals.blueprint.common.network.entity.MessageS2CTeleportEntity;
import com.teamabnormals.blueprint.common.network.entity.MessageS2CUpdateEntityData;
import com.teamabnormals.blueprint.common.network.particle.MessageS2CSpawnParticle;
import com.teamabnormals.blueprint.common.world.modification.ModdedBiomeSource;
import com.teamabnormals.blueprint.common.world.storage.tracking.DataProcessors;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import com.teamabnormals.blueprint.core.BlueprintConfig;
import com.teamabnormals.blueprint.core.api.BlockSetTypeRegistryHelper;
import com.teamabnormals.blueprint.core.api.BlueprintTrims;
import com.teamabnormals.blueprint.core.api.WoodTypeRegistryHelper;
import com.teamabnormals.blueprint.core.api.conditions.BlueprintAndCondition;
import com.teamabnormals.blueprint.core.api.conditions.config.ContainsPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.EqualsPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.GreaterThanOrEqualPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.GreaterThanPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.LessThanOrEqualPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.LessThanPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.MatchesPredicate;
import com.teamabnormals.blueprint.core.api.model.FullbrightModel;
import com.teamabnormals.blueprint.core.data.server.BlueprintDatapackBuiltinEntriesProvider;
import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.blueprint.core.data.server.tags.BlueprintBiomeTagsProvider;
import com.teamabnormals.blueprint.core.data.server.tags.BlueprintBlockTagsProvider;
import com.teamabnormals.blueprint.core.data.server.tags.BlueprintDamageTypeTagsProvider;
import com.teamabnormals.blueprint.core.data.server.tags.BlueprintEntityTypeTagsProvider;
import com.teamabnormals.blueprint.core.data.server.tags.BlueprintItemTagsProvider;
import com.teamabnormals.blueprint.core.data.server.tags.BlueprintPoiTypeTagsProvider;
import com.teamabnormals.blueprint.core.endimator.EndimationLoader;
import com.teamabnormals.blueprint.core.other.BlueprintEvents;
import com.teamabnormals.blueprint.core.other.tags.BlueprintItemTags;
import com.teamabnormals.blueprint.core.registry.BlueprintBlockEntityTypes;
import com.teamabnormals.blueprint.core.registry.BlueprintBoatTypes;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.registry.BlueprintEntityTypes;
import com.teamabnormals.blueprint.core.registry.BlueprintHolderSets;
import com.teamabnormals.blueprint.core.registry.BlueprintLootConditions;
import com.teamabnormals.blueprint.core.registry.BlueprintPoiTypes;
import com.teamabnormals.blueprint.core.registry.BlueprintSurfaceRules;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.blueprint.core.util.item.CreativeModeTabContentsPopulator;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.BlockEntitySubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="blueprint")
@Mod.EventBusSubscriber(modid="blueprint", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Blueprint {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "blueprint";
    public static final String NETWORK_PROTOCOL = "BP1";
    public static final EndimationLoader ENDIMATION_LOADER = new EndimationLoader();
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("blueprint");
    public static final TrackedData<Byte> SLABFISH_SETTINGS = TrackedData.Builder.create(DataProcessors.BYTE, () -> (byte)8).enablePersistence().build();
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("blueprint", "net")).networkProtocolVersion(() -> "BP1").clientAcceptedVersions("BP1"::equals).serverAcceptedVersions("BP1"::equals).simpleChannel();

    public Blueprint() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ChunkLoaderEvents());
        this.registerMessages();
        CraftingHelper.register((IConditionSerializer)new BlueprintAndCondition.Serializer());
        DataUtil.registerConfigPredicate(new EqualsPredicate.Serializer());
        DataUtil.registerConfigPredicate(new GreaterThanOrEqualPredicate.Serializer());
        DataUtil.registerConfigPredicate(new GreaterThanPredicate.Serializer());
        DataUtil.registerConfigPredicate(new LessThanOrEqualPredicate.Serializer());
        DataUtil.registerConfigPredicate(new LessThanPredicate.Serializer());
        DataUtil.registerConfigPredicate(new ContainsPredicate.Serializer());
        DataUtil.registerConfigPredicate(new MatchesPredicate.Serializer());
        ((AbstractSubRegistryHelper)REGISTRY_HELPER.getEntitySubHelper()).register(bus);
        ((AbstractSubRegistryHelper)REGISTRY_HELPER.getBlockEntitySubHelper()).register(bus);
        BlueprintHolderSets.HOLDER_SET_TYPES.register(bus);
        BlueprintPoiTypes.POI_TYPES.register(bus);
        BlueprintSurfaceRules.RULE_SOURCES.register(bus);
        BlueprintLootConditions.LOOT_CONDITION_TYPES.register(bus);
        bus.addListener(event -> {
            ModConfig config = event.getConfig();
            if (config.getSpec() == BlueprintConfig.CLIENT_SPEC) {
                BlueprintConfig.CLIENT.load();
            }
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(EventPriority.NORMAL, false, RegisterColorHandlersEvent.Block.class, event -> {
                ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
                if (resourceManager instanceof ReloadableResourceManager) {
                    ((ReloadableResourceManager)resourceManager).m_7217_((PreparableReloadListener)ENDIMATION_LOADER);
                }
            });
            bus.addListener(EventPriority.NORMAL, false, ModConfigEvent.Reloading.class, event -> {
                if (event.getConfig().getModId().equals(MOD_ID)) {
                    NetworkUtil.updateSlabfish(RewardHandler.SlabfishSetting.getConfig());
                }
            });
            bus.addListener(this::clientSetup);
            bus.addListener(this::modelSetup);
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::rendererSetup);
            bus.addListener(BlueprintTrims::onModelsBaked);
            bus.addListener(CreativeModeTabContentsPopulator::onBuildCreativeModeTabContents);
            bus.addListener(BlueprintSplashManager::onRegisterClientReloadListeners);
            bus.addListener(RewardHandler::clientSetup);
            bus.addListener(RewardHandler::addLayers);
            bus.addListener(BlueprintShaders::registerShaders);
            BlueprintSpriteSources.register();
        });
        bus.addListener(BlueprintDataPackRegistries::registerRegistries);
        bus.addListener(this::registerOnEvent);
        bus.addListener(EventPriority.LOWEST, this::commonSetup);
        bus.addListener(EventPriority.LOWEST, this::postLoadingSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::registerCapabilities);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BlueprintConfig.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BlueprintConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation(MOD_ID, "slabfish_head"), SLABFISH_SETTINGS);
        HashSet validBlocks = Sets.newHashSet((Iterable)BlockEntityType.f_244310_.f_58915_);
        validBlocks.addAll(Sets.newHashSet((Object[])BlockEntitySubRegistryHelper.collectBlocks(BlueprintChiseledBookShelfBlock.class)));
        BlockEntityType.f_244310_.f_58915_ = ImmutableSet.copyOf((Collection)validBlocks);
        event.enqueueWork(() -> {
            WoodTypeRegistryHelper.registerWoodTypes();
            BlockSetTypeRegistryHelper.registerBlockSetTypes();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            WoodTypeRegistryHelper.setupAtlas();
            BlueprintTrims.init();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        BlueprintBlockTagsProvider blockTags = new BlueprintBlockTagsProvider(MOD_ID, output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new BlueprintItemTagsProvider(MOD_ID, output, provider, blockTags.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new BlueprintEntityTypeTagsProvider(MOD_ID, output, provider, helper));
        generator.addProvider(server, (DataProvider)new BlueprintBiomeTagsProvider(MOD_ID, output, provider, helper));
        generator.addProvider(server, (DataProvider)new BlueprintDamageTypeTagsProvider(MOD_ID, output, provider, helper));
        generator.addProvider(server, (DataProvider)new BlueprintPoiTypeTagsProvider(MOD_ID, output, provider, helper));
        generator.addProvider(server, (DataProvider)new BlueprintRecipeProvider(MOD_ID, output));
        generator.addProvider(server, (DataProvider)new BlueprintDatapackBuiltinEntriesProvider(output, provider));
    }

    private void registerOnEvent(RegisterEvent event) {
        event.register(Registries.f_256826_, helper -> helper.register("modded", ModdedBiomeSource.CODEC));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        BlueprintBoatTypes.registerLayerDefinitions(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void rendererSetup(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)BlueprintEntityTypes.BOAT.get(), context -> new BlueprintBoatRenderer(context, false));
        event.registerEntityRenderer((EntityType)BlueprintEntityTypes.CHEST_BOAT.get(), context -> new BlueprintBoatRenderer(context, true));
        event.registerEntityRenderer((EntityType)BlueprintEntityTypes.FALLING_BLOCK.get(), FallingBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlueprintBlockEntityTypes.CHEST.get(), BlueprintChestBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlueprintBlockEntityTypes.TRAPPED_CHEST.get(), BlueprintChestBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlueprintBlockEntityTypes.SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlueprintBlockEntityTypes.HANGING_SIGN.get(), HangingSignRenderer::new);
    }

    private void postLoadingSetup(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            Chicken.f_28233_ = CompoundIngredient.of((Ingredient[])new Ingredient[]{Chicken.f_28233_, Ingredient.m_204132_(BlueprintItemTags.CHICKEN_FOOD)});
            Pig.f_29458_ = CompoundIngredient.of((Ingredient[])new Ingredient[]{Pig.f_29458_, Ingredient.m_204132_(BlueprintItemTags.PIG_FOOD)});
            Strider.f_33852_ = CompoundIngredient.of((Ingredient[])new Ingredient[]{Strider.f_33852_, Ingredient.m_204132_(BlueprintItemTags.STRIDER_FOOD)});
            Strider.f_33853_ = CompoundIngredient.of((Ingredient[])new Ingredient[]{Strider.f_33853_, Ingredient.m_204132_(BlueprintItemTags.STRIDER_TEMPT_ITEMS)});
            Ocelot.f_28981_ = CompoundIngredient.of((Ingredient[])new Ingredient[]{Ocelot.f_28981_, Ingredient.m_204132_(BlueprintItemTags.OCELOT_FOOD)});
            Cat.f_28103_ = CompoundIngredient.of((Ingredient[])new Ingredient[]{Cat.f_28103_, Ingredient.m_204132_(BlueprintItemTags.CAT_FOOD)});
            DataUtil.getSortedAlternativeDispenseBehaviors().forEach(DataUtil.AlternativeDispenseBehavior::register);
            BlueprintEvents.SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS = DataUtil.getSortedCustomNoteBlockInstruments();
        });
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        ChunkLoaderCapability.register(event);
    }

    private void modelSetup(ModelEvent.RegisterGeometryLoaders event) {
        event.register("fullbright", (IGeometryLoader)FullbrightModel.Loader.INSTANCE);
    }

    private void registerMessages() {
        int id = -1;
        CHANNEL.registerMessage(++id, MessageS2CEndimation.class, MessageS2CEndimation::serialize, MessageS2CEndimation::deserialize, MessageS2CEndimation::handle);
        CHANNEL.registerMessage(++id, MessageS2CTeleportEntity.class, MessageS2CTeleportEntity::serialize, MessageS2CTeleportEntity::deserialize, MessageS2CTeleportEntity::handle);
        CHANNEL.registerMessage(++id, MessageS2CSpawnParticle.class, MessageS2CSpawnParticle::serialize, MessageS2CSpawnParticle::deserialize, MessageS2CSpawnParticle::handle);
        CHANNEL.registerMessage(++id, MessageS2CUpdateEntityData.class, MessageS2CUpdateEntityData::serialize, MessageS2CUpdateEntityData::deserialize, MessageS2CUpdateEntityData::handle);
        CHANNEL.registerMessage(++id, MessageC2SUpdateSlabfishHat.class, MessageC2SUpdateSlabfishHat::serialize, MessageC2SUpdateSlabfishHat::deserialize, MessageC2SUpdateSlabfishHat::handle);
    }
}

