/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.utils;

import java.util.List;
import java.util.Random;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.bettercombat.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.bettercombat.network.Packets;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class SoundHelper {
    private static Random rng = new Random();
    public static List<String> soundKeys = List.of("anchor_slam", "axe_slash", "claymore_swing", "claymore_stab", "claymore_slam", "dagger_slash", "double_axe_swing", "fist_punch", "glaive_slash_quick", "glaive_slash_slow", "hammer_slam", "katana_slash", "mace_slam", "mace_slash", "pickaxe_swing", "rapier_slash", "rapier_stab", "scythe_slash", "spear_stab", "staff_slam", "staff_slash", "staff_spin", "staff_stab", "sickle_slash", "sword_slash", "wand_swing");

    public static void playSound(ServerLevel world, Entity entity, WeaponAttributes.Sound sound) {
        if (sound == null) {
            return;
        }
        try {
            float pitch = sound.randomness() > 0.0f ? rng.nextFloat(sound.pitch() - sound.randomness(), sound.pitch() + sound.randomness()) : sound.pitch();
            FriendlyByteBuf packet = new Packets.AttackSound(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), sound.id(), sound.volume(), pitch, rng.nextLong()).write();
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(sound.id()));
            float distance = soundEvent.m_215668_(sound.volume());
            Vec3 origin = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            PlayerLookup.around(world, origin, distance).forEach(serverPlayer -> {
                ResourceLocation channel = Packets.AttackSound.ID;
                try {
                    if (ServerPlayNetworking.canSend(serverPlayer, channel)) {
                        ServerPlayNetworking.send(serverPlayer, channel, packet);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            System.out.println("Failed to play sound: " + sound.id());
            e.printStackTrace();
        }
    }

    public static void registerSounds() {
        for (String soundKey : soundKeys) {
            ResourceLocation soundId = new ResourceLocation("bettercombat", soundKey);
            SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)soundId);
            Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)soundId, (Object)soundEvent);
        }
    }
}

