/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.renderdoc;

import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.renderdoc.RenderDocLibrary;
import com.sun.jna.Native;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import net.minecraft.class_156;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.lwjgl.system.linux.DynamicLinkLoader;

public class RenderDocLoader {
    public static final Path LIB_LINUX_PATH = Path.of("./better-clouds/librenderdoc.so", new String[0]);
    public static final Path LIB_WINDOWS_PATH = Path.of("./better-clouds/renderdoc.dll", new String[0]);

    public static void install() {
        block4: {
            class_156.class_158 os = class_156.method_668();
            try {
                if (os == class_156.class_158.field_1133) {
                    RenderDocLoader.downloadWindows();
                    break block4;
                }
                if (os == class_156.class_158.field_1135) {
                    RenderDocLoader.downloadLinux();
                    break block4;
                }
                throw new RuntimeException("Unsupported OS: " + os.method_38649());
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void uninstall() {
        if (!Files.exists(RenderDocLoader.libPath(), new LinkOption[0])) {
            return;
        }
        if (RenderDoc.isAvailable()) {
            throw new RuntimeException("Cannot uninstall RenderDoc as it is currently in use");
        }
        try {
            Files.delete(RenderDocLoader.libPath());
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean isAvailable() {
        class_156.class_158 os = class_156.method_668();
        if (os == class_156.class_158.field_1133) {
            return RenderDocLoader.isAvailable("renderdoc.dll", "913a2f5b87981169f40207ab81be3e88");
        }
        if (os == class_156.class_158.field_1135) {
            return RenderDocLoader.isAvailable("librenderdoc.so", "3d134559f0128b2e079eab0bd5395588");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAvailable(String name, String md5sum) {
        File dllFile = Path.of("./better-clouds/", name).toFile();
        if (!dllFile.exists()) return false;
        if (dllFile.isDirectory()) {
            return false;
        }
        try (FileInputStream is = new FileInputStream(dllFile);){
            String sum = DigestUtils.md5Hex((InputStream)is);
            if (sum.equalsIgnoreCase(md5sum)) {
                boolean bl = true;
                return bl;
            }
            Main.LOGGER.warn("renderdoc library present but md5 checksum wrong: {}, expected {}", sum, md5sum);
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadWindows() throws IOException {
        File archive = Path.of("./better-clouds/RenderDoc_1.30_64.zip", new String[0]).toFile();
        FileUtils.copyURLToFile((URL)new URL("https://renderdoc.org/stable/1.30/RenderDoc_1.30_64.zip"), (File)archive);
        try (ZipFile zipFile = new ZipFile(archive);){
            InputStream dllEntry = zipFile.getInputStream(zipFile.getEntry("RenderDoc_1.30_64/renderdoc.dll"));
            File dllFile = LIB_WINDOWS_PATH.toFile();
            FileUtils.copyInputStreamToFile((InputStream)dllEntry, (File)dllFile);
        }
        finally {
            archive.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadLinux() throws IOException {
        File archive = Path.of("./better-clouds/renderdoc_1.30.tar.gz", new String[0]).toFile();
        FileUtils.copyURLToFile((URL)new URL("https://renderdoc.org/stable/1.30/renderdoc_1.30.tar.gz"), (File)archive);
        try (FileInputStream source = new FileInputStream(archive);
             GZIPInputStream gzip = new GZIPInputStream(source);
             TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)gzip);){
            TarArchiveEntry entry;
            File dllFile = LIB_LINUX_PATH.toFile();
            boolean found = false;
            while ((entry = tar.getNextTarEntry()) != null) {
                String name = entry.getName();
                if (!name.equalsIgnoreCase("renderdoc_1.30/lib/librenderdoc.so")) continue;
                FileUtils.copyInputStreamToFile((InputStream)tar, (File)dllFile);
                found = true;
                break;
            }
            if (!found) {
                throw new FileNotFoundException("renderdoc_1.30/lib/librenderdoc.so");
            }
        }
        finally {
            archive.delete();
        }
    }

    public static void load() {
        if (RenderDoc.isAvailable()) {
            return;
        }
        class_156.class_158 os = class_156.method_668();
        if (os == class_156.class_158.field_1133 || os == class_156.class_158.field_1135) {
            try {
                RenderDocLibrary renderdocLibrary;
                String libPath = RenderDocLoader.libPath().toAbsolutePath().toString();
                if (os == class_156.class_158.field_1133) {
                    renderdocLibrary = (RenderDocLibrary)Native.load((String)libPath, RenderDocLibrary.class);
                } else {
                    int flags = 6;
                    if (DynamicLinkLoader.dlopen((CharSequence)libPath, (int)flags) == 0L) {
                        throw new UnsatisfiedLinkError();
                    }
                    renderdocLibrary = (RenderDocLibrary)Native.load((String)libPath, RenderDocLibrary.class, Map.of("open-flags", flags));
                }
                RenderDoc.init(renderdocLibrary);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }

    public static Path libPath() {
        class_156.class_158 os = class_156.method_668();
        if (os == class_156.class_158.field_1133) {
            return LIB_WINDOWS_PATH;
        }
        if (os == class_156.class_158.field_1135) {
            return LIB_LINUX_PATH;
        }
        throw new RuntimeException("Unsupported OS: " + os.method_38649());
    }
}

