/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.qendolin.betterclouds.Config;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.clouds.Buffer;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Sampler;
import com.qendolin.betterclouds.compat.Telemetry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_156;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class ChunkedGenerator
implements AutoCloseable {
    private double originX;
    private double originZ;
    private float prevTime = Float.POSITIVE_INFINITY;
    private Buffer buffer;
    private final Sampler sampler = new Sampler();
    @Nullable
    private Task queuedTask;
    @Nullable
    private Task runningTask;
    @Nullable
    private Task completedTask;
    @Nullable
    private Task swappedTask;

    public synchronized boolean canGenerate() {
        return this.queuedTask != null;
    }

    public synchronized boolean canSwap() {
        return this.completedTask != null && this.completedTask != this.swappedTask;
    }

    public synchronized boolean canRender() {
        return this.completedTask != null;
    }

    public synchronized List<ChunkIndex> chunks() {
        if (this.swappedTask == null) {
            return List.of();
        }
        return this.swappedTask.chunks();
    }

    public Buffer buffer() {
        return this.buffer;
    }

    public synchronized int instanceVertexCount() {
        if (this.swappedTask == null) {
            return 0;
        }
        return this.swappedTask.instanceVertexCount();
    }

    public double originX() {
        return this.originX;
    }

    public double originZ() {
        return this.originZ;
    }

    public synchronized double renderOriginX(double cameraX) {
        if (this.swappedTask == null) {
            return 0.0;
        }
        return (double)(this.swappedTask.chunkX() * this.swappedTask.options().chunkSize) - cameraX + this.originX;
    }

    public synchronized double renderOriginZ(double cameraZ) {
        if (this.swappedTask == null) {
            return 0.0;
        }
        return (double)(this.swappedTask.chunkZ() * this.swappedTask.options().chunkSize) - cameraZ + this.originZ;
    }

    public synchronized int cloudCount() {
        if (this.swappedTask == null) {
            return 0;
        }
        return this.swappedTask.cloudCount();
    }

    public synchronized Config config() {
        if (this.swappedTask == null) {
            return null;
        }
        return this.swappedTask.options;
    }

    public synchronized boolean generating() {
        return this.runningTask != null;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    public void bind() {
        this.buffer.bind();
    }

    public void unbind() {
        this.buffer.unbind();
    }

    public synchronized boolean reallocateIfStale(Config options, boolean fancy) {
        int bufferSize = ChunkedGenerator.calcBufferSize(options);
        if (this.buffer.hasChanged(bufferSize, fancy, options.usePersistentBuffers)) {
            this.buffer.close();
            this.buffer = new Buffer(bufferSize, fancy, options.usePersistentBuffers);
            this.clear();
            return true;
        }
        return false;
    }

    private static int calcBufferSize(Config options) {
        int distance = options.blockDistance();
        int size = class_3532.method_15375((float)((float)distance / options.spacing)) + class_3532.method_15386((float)((float)distance / options.spacing));
        if (size <= 0) {
            Telemetry.INSTANCE.sendEvent("invalid_buffer_size", String.format("Invalid buffer size result %d from block_distance=%d (distance=%f) and spacing %f".formatted(size, distance, Float.valueOf(options.distance), Float.valueOf(options.spacing)), new Object[0]));
            return 128;
        }
        return size;
    }

    public synchronized void clear() {
        this.queuedTask = null;
        if (this.runningTask != null) {
            this.runningTask.cancel();
        }
        this.runningTask = null;
        this.completedTask = null;
        this.swappedTask = null;
    }

    public synchronized void allocate(Config options, boolean fancy) {
        int bufferSize = ChunkedGenerator.calcBufferSize(options);
        if (this.buffer != null) {
            this.buffer.close();
        }
        this.buffer = new Buffer(bufferSize, fancy, options.usePersistentBuffers);
        this.clear();
    }

    public synchronized void update(Vector3d camera, float time, Config options, float cloudiness) {
        boolean updateGeometry;
        float timeDelta = class_3532.method_15363((float)(time - this.prevTime), (float)0.0f, (float)200.0f);
        this.prevTime = time;
        this.originX -= (double)(timeDelta * options.travelSpeed);
        this.originZ = 0.0;
        double worldOriginX = camera.x - this.originX;
        double worldOriginZ = camera.z - this.originZ;
        int chunkX = ChunkedGenerator.floorCloudChunk(worldOriginX, options.chunkSize);
        int chunkZ = ChunkedGenerator.floorCloudChunk(worldOriginZ, options.chunkSize);
        if (this.queuedTask != null || this.runningTask != null || this.completedTask != null) {
            Task prevTask = this.queuedTask == null ? (this.runningTask == null ? this.completedTask : this.runningTask) : this.queuedTask;
            int prevChunkX = prevTask.chunkX();
            int prevChunkZ = prevTask.chunkZ();
            boolean chunkChanged = prevChunkX != chunkX || prevChunkZ != chunkZ;
            Config prevOptions = prevTask.options();
            boolean optionsChanged = options.fuzziness != prevOptions.fuzziness || options.chunkSize != prevOptions.chunkSize || options.yRange != prevOptions.yRange || options.sparsity != prevOptions.sparsity || options.spacing != prevOptions.spacing || options.randomPlacement != prevOptions.randomPlacement || options.distance != prevOptions.distance || options.samplingScale != prevOptions.samplingScale || options.shuffle != prevOptions.shuffle;
            float prevCloudiness = prevTask.cloudiness();
            boolean cloudinessChanged = Math.ceil(cloudiness * 100.0f) != Math.ceil(prevCloudiness * 100.0f);
            boolean bufferCleared = this.buffer.swapCount() == 0 && this.queuedTask == null && this.runningTask == null && (this.completedTask == null || this.completedTask == this.swappedTask);
            updateGeometry = chunkChanged || optionsChanged || cloudinessChanged || bufferCleared;
        } else {
            updateGeometry = true;
        }
        if (Debug.generatorForceUpdate) {
            Debug.generatorForceUpdate = false;
            updateGeometry = true;
        }
        if (updateGeometry) {
            this.queuedTask = new Task(chunkX, chunkZ, new Config(options), cloudiness, this.buffer, this.sampler);
        }
    }

    private static int floorCloudChunk(double coord, int chunkSize) {
        return (int)Math.floor(coord / (double)chunkSize);
    }

    public synchronized void generate() {
        if (this.queuedTask == null) {
            Main.LOGGER.warn("generate called with no queued task");
            return;
        }
        if (this.runningTask != null) {
            this.runningTask.cancel();
        }
        this.runningTask = this.queuedTask;
        this.queuedTask = null;
        if (this.runningTask.ran()) {
            Main.LOGGER.warn("Queued generator task #{} already ran", this.runningTask.id());
        }
        Task boundTask = this.runningTask;
        CompletableFuture.runAsync(this.runningTask::run).whenComplete((unused, throwable) -> {
            ChunkedGenerator chunkedGenerator = this;
            synchronized (chunkedGenerator) {
                if (throwable != null) {
                    Main.LOGGER.error("Generator task #{} ran with error", this.runningTask.id(), throwable);
                }
                if (boundTask != this.runningTask) {
                    if (boundTask.completed()) {
                        Main.LOGGER.warn("Generator task #{} completed but task #{} was expected", boundTask.id(), this.runningTask.id());
                    } else if (!boundTask.cancelled() && throwable == null) {
                        Main.LOGGER.warn("Generator task #{} ran without error, completion or cancellation", boundTask.id());
                    }
                } else {
                    if (boundTask.completed()) {
                        this.completedTask = this.runningTask;
                    } else if (!boundTask.cancelled() && throwable == null) {
                        Main.LOGGER.warn("Generator task #{} ran without error, completion or cancellation", boundTask.id());
                    }
                    this.runningTask = null;
                }
            }
        });
    }

    public synchronized void swap() {
        if (this.completedTask == null) {
            Main.LOGGER.warn("swap called with no completed task");
            return;
        }
        if (this.swappedTask == this.completedTask) {
            Main.LOGGER.warn("swap called with swapped task");
            return;
        }
        this.completedTask.buffer.swap();
        this.swappedTask = this.completedTask;
        if (Main.isProfilingEnabled()) {
            long elapsed = this.swappedTask.elapsedMs(class_156.method_658());
            Main.debugChatMessage("profiling.genTimes", elapsed, Float.valueOf(1000.0f / (float)elapsed));
        }
    }

    private static class Task {
        private static final AtomicInteger nextId = new AtomicInteger(1);
        private final int id;
        private final int chunkX;
        private final int chunkZ;
        private final Config options;
        private final float cloudiness;
        private final Buffer buffer;
        private final Sampler sampler;
        private final AtomicBoolean ran = new AtomicBoolean();
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicBoolean completed = new AtomicBoolean();
        private final List<ChunkIndex> chunks = new ArrayList<ChunkIndex>();
        private int cloudCount;
        private long startTime;

        public Task(int chunkX, int chunkZ, Config options, float cloudiness, Buffer buffer, Sampler sampler) {
            this.id = nextId.getAndIncrement();
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.options = options;
            this.cloudiness = cloudiness;
            this.buffer = buffer;
            this.sampler = sampler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Task task = this;
            synchronized (task) {
                if (this.completed.get()) {
                    return;
                }
                if (this.cancelled.getAndSet(true)) {
                    return;
                }
                Main.LOGGER.debug("Generator task #{} cancelled", this.id);
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Main.LOGGER.error("Generator task #{} interrupted after cancelled", this.id, e);
                }
            }
        }

        public int id() {
            return this.id;
        }

        public boolean completed() {
            return this.completed.get();
        }

        public int cloudCount() {
            return this.cloudCount;
        }

        public int chunkX() {
            return this.chunkX;
        }

        public int chunkZ() {
            return this.chunkZ;
        }

        public int instanceVertexCount() {
            return this.buffer.instanceVertexCount();
        }

        public Config options() {
            return this.options;
        }

        public float cloudiness() {
            return this.cloudiness;
        }

        public List<ChunkIndex> chunks() {
            return this.chunks;
        }

        public boolean ran() {
            return this.ran.get();
        }

        public boolean cancelled() {
            return this.cancelled.get();
        }

        public long elapsedMs(long now) {
            if (this.startTime == 0L) {
                return 0L;
            }
            return now - this.startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Task task = this;
            synchronized (task) {
                if (this.ran.getAndSet(true) || this.cancelled.get()) {
                    return;
                }
            }
            this.startTime = class_156.method_658();
            int distance = this.options.blockDistance();
            double spacing = this.options.spacing;
            int gridMin = -class_3532.method_15357((double)((double)distance / spacing));
            int gridMax = class_3532.method_15384((double)((double)distance / spacing));
            int gridVisibilityRadiusSquared = class_3532.method_15384((double)((double)((float)distance + this.options.sizeXZ) / spacing));
            gridVisibilityRadiusSquared *= gridVisibilityRadiusSquared;
            int chunkMin = this.roundToMultiple(gridMin, this.options.chunkSize);
            int chunkMax = this.roundToMultiple(gridMax, this.options.chunkSize);
            int chunkLength = chunkMax - chunkMin;
            int chunkCount = chunkLength / this.options.chunkSize;
            int gridOriginX = class_3532.method_15357((double)((double)(this.chunkX * this.options.chunkSize) / spacing));
            int gridOriginZ = class_3532.method_15357((double)((double)(this.chunkZ * this.options.chunkSize) / spacing));
            int[][][] chunkGridPoints = new int[chunkCount * chunkCount][][];
            for (int chunkX = chunkMin; chunkX < chunkMax; chunkX += this.options.chunkSize) {
                for (int chunkZ = chunkMin; chunkZ < chunkMax; chunkZ += this.options.chunkSize) {
                    int chunkGridMinX = Math.max(chunkX, gridMin);
                    int chunkGridMinZ = Math.max(chunkZ, gridMin);
                    int chunkGridMaxX = Math.min(chunkX + this.options.chunkSize, gridMax);
                    int chunkGridMaxZ = Math.min(chunkZ + this.options.chunkSize, gridMax);
                    int chunkGridLengthX = chunkGridMaxX - chunkGridMinX;
                    int chunkGridLengthZ = chunkGridMaxZ - chunkGridMinZ;
                    int chunkIndex = (chunkX - chunkMin) / this.options.chunkSize + chunkCount * ((chunkZ - chunkMin) / this.options.chunkSize);
                    chunkGridPoints[chunkIndex] = new int[chunkGridLengthX * chunkGridLengthZ][];
                    for (int gridX = chunkGridMinX; gridX < chunkGridMaxX; ++gridX) {
                        for (int gridZ = chunkGridMinZ; gridZ < chunkGridMaxZ; ++gridZ) {
                            if (this.options.sparsity > 0.0f && this.hashToFloat(11, gridX + gridOriginX, gridZ + gridOriginZ) < this.options.sparsity || gridX * gridX + gridZ * gridZ >= gridVisibilityRadiusSquared) continue;
                            int pointIndex = gridX - chunkGridMinX + chunkGridLengthX * (gridZ - chunkGridMinZ);
                            chunkGridPoints[chunkIndex][pointIndex] = new int[]{gridX, gridZ};
                        }
                    }
                }
            }
            if (this.options.shuffle) {
                for (int[][] gridPoints : chunkGridPoints) {
                    for (int s = 0; s < gridPoints.length; ++s) {
                        int[] tmp = gridPoints[s];
                        if (tmp == null) continue;
                        int d = this.hash(13, tmp[0] + gridOriginX, tmp[1] + gridOriginZ) % gridPoints.length;
                        if (d < 0) {
                            d = -d;
                        }
                        gridPoints[s] = gridPoints[d];
                        gridPoints[d] = tmp;
                    }
                }
            }
            this.buffer.clear();
            for (int[][] gridPoints : chunkGridPoints) {
                int chunkCloudIndex = this.cloudCount;
                float[] bounds = null;
                for (int[] point : gridPoints) {
                    int sampleZ;
                    if (point == null) continue;
                    int gridX = point[0];
                    int gridZ = point[1];
                    int sampleX = class_3532.method_15357((double)((double)(gridX + gridOriginX) * spacing));
                    float value = this.sampler.sample(sampleX, sampleZ = class_3532.method_15357((double)((double)(gridZ + gridOriginZ) * spacing)), this.cloudiness, this.options.fuzziness, this.options.samplingScale);
                    if (value <= 0.0f) continue;
                    float x = (float)((double)(sampleX - this.chunkX * this.options.chunkSize) + (double)(this.sampler.randomOffsetX(sampleX, sampleZ) * this.options.randomPlacement) * spacing);
                    float y = this.options.yRange * value * value;
                    float z = (float)((double)(sampleZ - this.chunkZ * this.options.chunkSize) + (double)(this.sampler.randomOffsetZ(sampleX, sampleZ) * this.options.randomPlacement) * spacing);
                    if (bounds == null) {
                        bounds = new float[]{x, y, z, x, y, z};
                    } else {
                        if (x < bounds[0]) {
                            bounds[0] = x;
                        }
                        if (y < bounds[1]) {
                            bounds[1] = y;
                        }
                        if (z < bounds[2]) {
                            bounds[2] = z;
                        }
                        if (x > bounds[3]) {
                            bounds[3] = x;
                        }
                        if (y > bounds[4]) {
                            bounds[4] = y;
                        }
                        if (z > bounds[5]) {
                            bounds[5] = z;
                        }
                    }
                    this.buffer.put(x, y, z);
                    ++this.cloudCount;
                }
                if (chunkCloudIndex != this.cloudCount && bounds != null) {
                    class_238 boundingBox = new class_238((double)bounds[0], (double)bounds[1], (double)bounds[2], (double)bounds[3], (double)bounds[4], (double)bounds[5]).method_989((double)(this.chunkX * this.options.chunkSize), 0.0, (double)(this.chunkZ * this.options.chunkSize));
                    this.chunks.add(new ChunkIndex(chunkCloudIndex, this.cloudCount - chunkCloudIndex, boundingBox));
                }
                if (!this.cancelled.get()) continue;
                Task task2 = this;
                synchronized (task2) {
                    this.notify();
                    return;
                }
            }
            this.completed.set(true);
        }

        private int roundToMultiple(int n, int base) {
            if (n >= 0) {
                return (n + base - 1) / base * base;
            }
            return (n - base + 1) / base * base;
        }

        private float hashToFloat(int prime, int ... values) {
            int hash = this.hash(prime, values);
            int ieeeMantissa = 0x7FFFFF;
            int ieeeOne = 1065353216;
            hash &= ieeeMantissa;
            float f = Float.intBitsToFloat(hash |= ieeeOne);
            return f - 1.0f;
        }

        private int hash(int prime, int ... values) {
            int hash = prime;
            for (int value : values) {
                hash += value;
                hash += hash << 10;
                hash ^= hash >> 6;
            }
            hash += hash << 3;
            hash ^= hash >> 11;
            hash += hash << 15;
            return hash;
        }
    }

    public static final class ChunkIndex {
        private final int start;
        private final int count;
        private final class_238 bounds;
        private class_238 cachedBounds;
        private float lastCloudsHeight;
        private float lastSizeXZ;
        private float lastSizeY;

        public ChunkIndex(int start, int count, class_238 bounds) {
            this.start = start;
            this.count = count;
            this.bounds = bounds;
        }

        public class_238 bounds(float cloudsHeight, float sizeXZ, float sizeY) {
            if (cloudsHeight == this.lastCloudsHeight && sizeXZ == this.lastSizeXZ && sizeY == this.lastSizeY) {
                return this.cachedBounds;
            }
            this.cachedBounds = this.bounds.method_989(0.0, (double)cloudsHeight, 0.0).method_1009((double)sizeXZ, (double)sizeY, (double)sizeXZ);
            this.lastCloudsHeight = cloudsHeight;
            this.lastSizeXZ = sizeXZ;
            this.lastSizeY = sizeY;
            return this.cachedBounds;
        }

        public int start() {
            return this.start;
        }

        public int count() {
            return this.count;
        }
    }
}

