/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.network.packet;

import mod.azure.azurelibarmor.core.animatable.GeoAnimatable;
import mod.azure.azurelibarmor.core.animation.AnimatableManager;
import mod.azure.azurelibarmor.network.AbstractPacket;
import mod.azure.azurelibarmor.platform.services.AzureLibNetwork;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AnimTriggerPacket
extends AbstractPacket {
    private final String syncableId;
    private final long instanceId;
    private final String controllerName;
    private final String animName;

    public AnimTriggerPacket(String syncableId, long instanceId, @Nullable String controllerName, String animName) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.syncableId);
        buf.m_130103_(this.instanceId);
        buf.m_130070_(this.controllerName);
        buf.m_130070_(this.animName);
    }

    @Override
    public ResourceLocation getPacketID() {
        return AzureLibNetwork.ANIM_TRIGGER_SYNC_PACKET_ID;
    }

    public static AnimTriggerPacket receive(FriendlyByteBuf buf) {
        return new AnimTriggerPacket(buf.m_130277_(), buf.m_130258_(), buf.m_130277_(), buf.m_130277_());
    }

    @Override
    public void handle() {
        GeoAnimatable animatable = AzureLibNetwork.getSyncedAnimatable(this.syncableId);
        if (animatable != null) {
            AnimatableManager manager = animatable.getAnimatableInstanceCache().getManagerForId(this.instanceId);
            manager.tryTriggerAnimation(this.controllerName, this.animName);
        }
    }
}

