/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.event;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelibarmor.cache.object.BakedGeoModel;
import mod.azure.azurelibarmor.renderer.GeoArmorRenderer;
import mod.azure.azurelibarmor.renderer.GeoItemRenderer;
import mod.azure.azurelibarmor.renderer.GeoRenderer;
import mod.azure.azurelibarmor.renderer.layer.GeoRenderLayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public interface GeoRenderEvent {
    public GeoRenderer<?> getRenderer();

    public static abstract class Item
    extends Event
    implements GeoRenderEvent {
        private final GeoItemRenderer<?> renderer;

        public Item(GeoItemRenderer<?> renderer) {
            this.renderer = renderer;
        }

        public GeoItemRenderer<?> getRenderer() {
            return this.renderer;
        }

        public ItemStack getItemStack() {
            return ((GeoItemRenderer)this.getRenderer()).getCurrentItemStack();
        }

        public static class CompileRenderLayers
        extends Item {
            public CompileRenderLayers(GeoItemRenderer<?> renderer) {
                super(renderer);
            }

            public void addLayer(GeoRenderLayer renderLayer) {
                ((GeoItemRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }
        }

        public static class Post
        extends Item {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;
            private final float partialTick;
            private final int packedLight;

            public Post(GeoItemRenderer<?> renderer, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
                super(renderer);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
                this.partialTick = partialTick;
                this.packedLight = packedLight;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }

            public float getPartialTick() {
                return this.partialTick;
            }

            public int getPackedLight() {
                return this.packedLight;
            }
        }

        @Cancelable
        public static class Pre
        extends Item {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;
            private final float partialTick;
            private final int packedLight;

            public Pre(GeoItemRenderer<?> renderer, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
                super(renderer);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
                this.partialTick = partialTick;
                this.packedLight = packedLight;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }

            public float getPartialTick() {
                return this.partialTick;
            }

            public int getPackedLight() {
                return this.packedLight;
            }
        }
    }

    public static abstract class Armor
    extends Event
    implements GeoRenderEvent {
        private final GeoArmorRenderer<?> renderer;

        public Armor(GeoArmorRenderer<?> renderer) {
            this.renderer = renderer;
        }

        public GeoArmorRenderer<?> getRenderer() {
            return this.renderer;
        }

        @Nullable
        public Entity getEntity() {
            return ((GeoArmorRenderer)this.getRenderer()).getCurrentEntity();
        }

        @Nullable
        public ItemStack getItemStack() {
            return ((GeoArmorRenderer)this.getRenderer()).getCurrentStack();
        }

        @Nullable
        public EquipmentSlot getEquipmentSlot() {
            return ((GeoArmorRenderer)this.getRenderer()).getCurrentSlot();
        }

        public static class CompileRenderLayers
        extends Armor {
            public CompileRenderLayers(GeoArmorRenderer<?> renderer) {
                super(renderer);
            }

            public void addLayer(GeoRenderLayer renderLayer) {
                ((GeoArmorRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }
        }

        public static class Post
        extends Armor {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;
            private final float partialTick;
            private final int packedLight;

            public Post(GeoArmorRenderer<?> renderer, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
                super(renderer);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
                this.partialTick = partialTick;
                this.packedLight = packedLight;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }

            public float getPartialTick() {
                return this.partialTick;
            }

            public int getPackedLight() {
                return this.packedLight;
            }
        }

        @Cancelable
        public static class Pre
        extends Armor {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;
            private final float partialTick;
            private final int packedLight;

            public Pre(GeoArmorRenderer<?> renderer, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
                super(renderer);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
                this.partialTick = partialTick;
                this.packedLight = packedLight;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }

            public float getPartialTick() {
                return this.partialTick;
            }

            public int getPackedLight() {
                return this.packedLight;
            }
        }
    }
}

