/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.items;

import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.helper.AzureGunTypeEnum;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class AzureBaseGunItem
extends Item
implements GeoItem {
    protected final AzureGunTypeEnum azureGunTypeEnum;
    private static final String firing = "firing";
    private static final String controller = "controller";
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer(this);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache(this);

    public AzureBaseGunItem(AzureGunTypeEnum azureGunTypeEnum, int maxClipSize) {
        super(new Item.Properties().m_41487_(1).m_41503_(maxClipSize + 1));
        this.azureGunTypeEnum = azureGunTypeEnum;
        SingletonGeoAnimatable.registerSyncedAnimatable(this);
    }

    public AzureGunTypeEnum getAzureGunTypeEnum() {
        return this.azureGunTypeEnum;
    }

    public Item getAmmoType() {
        return null;
    }

    public SoundEvent getReloadSound() {
        return null;
    }

    public SoundEvent getFiringSound() {
        return null;
    }

    public int getReloadAmount() {
        return 1;
    }

    public int getCoolDown() {
        return 1;
    }

    public int getReloadCoolDown() {
        return 1;
    }

    private void singleFire(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Player player) {
        player.m_36335_().m_41524_((Item)this, this.getCoolDown());
        AzureLibUtil.spawnLightSource((Entity)player, player.m_9236_().m_46801_(player.m_20183_()));
        itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
    }

    public static void shoot(Player player) {
        Item item;
        if (player.m_21205_().m_41773_() < player.m_21205_().m_41776_() - 1 && (item = player.m_21205_().m_41720_()) instanceof AzureBaseGunItem) {
            AzureBaseGunItem gunBase = (AzureBaseGunItem)item;
            if (!player.m_36335_().m_41519_(player.m_21205_().m_41720_())) {
                gunBase.singleFire(player.m_21205_(), player.m_9236_(), player);
            }
        } else {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12088_, SoundSource.PLAYERS, 0.25f, 1.3f);
        }
    }

    public static void reload(Player user, InteractionHand hand) {
        Item item = user.m_21205_().m_41720_();
        if (item instanceof AzureBaseGunItem) {
            AzureBaseGunItem gunBase = (AzureBaseGunItem)item;
            while (!user.m_7500_() && user.m_21205_().m_41773_() != 0 && user.m_150109_().m_18947_(gunBase.getAmmoType()) > 0) {
                AzureLibUtil.removeAmmo(gunBase.getAmmoType(), user);
                user.m_36335_().m_41524_((Item)gunBase, gunBase.getReloadCoolDown());
                user.m_21205_().m_41622_(-gunBase.getReloadAmount(), (LivingEntity)user, s -> user.m_21190_(hand));
                user.m_21205_().m_41754_(3);
                if (gunBase.getReloadSound() != null) {
                    user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), gunBase.getReloadSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (user.m_9236_().f_46443_) continue;
                gunBase.triggerAnim((Entity)user, GeoItem.getOrAssignId(user.m_21120_(hand), (ServerLevel)user.m_9236_()), controller, "reload");
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player user, @NotNull InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    public boolean m_6813_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull BlockState blockState, @NotNull BlockPos blockPos, @NotNull LivingEntity livingEntity) {
        return false;
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.m_237115_((String)("Ammo: " + (itemStack.m_41776_() - itemStack.m_41773_() - 1) + " / " + (itemStack.m_41776_() - 1))).m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(itemStack, level, tooltip, tooltipFlag);
    }

    @Override
    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<AzureBaseGunItem>(this, controller, event -> PlayState.CONTINUE).triggerableAnim(firing, RawAnimation.begin().then(firing, Animation.LoopType.PLAY_ONCE)).triggerableAnim("reload", RawAnimation.begin().then("reload", Animation.LoopType.PLAY_ONCE)));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

