/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.common.block;

import com.teamabnormals.autumnity.common.entity.animal.Snail;
import com.teamabnormals.autumnity.common.entity.animal.Turkey;
import com.teamabnormals.autumnity.core.AutumnityConfig;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import com.teamabnormals.autumnity.core.registry.AutumnityEntityTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class TallFoulBerryBushBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape TOP_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public TallFoulBerryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((Boolean)AutumnityConfig.COMMON.foulBerriesRequirePips.get() != false ? (ItemLike)AutumnityItems.FOUL_BERRY_PIPS.get() : (ItemLike)AutumnityItems.FOUL_BERRIES.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)AGE) == 0 && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            return TOP_SHAPE;
        }
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(10) == 0) {
            VoxelShape voxelshape = this.m_5940_(stateIn, (BlockGetter)worldIn, pos, CollisionContext.m_82749_());
            Vec3 vector3d = voxelshape.m_83215_().m_82399_();
            double d0 = (double)pos.m_123341_() + vector3d.f_82479_;
            double d1 = (double)pos.m_123343_() + vector3d.f_82481_;
            int i = MobEffects.f_19614_.m_19484_();
            double d2 = (double)(i >> 16 & 0xFF) / 255.0;
            double d3 = (double)(i >> 8 & 0xFF) / 255.0;
            double d4 = (double)(i >> 0 & 0xFF) / 255.0;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123811_, d0 + (double)(rand.m_188501_() / 5.0f), (double)pos.m_123342_() + (0.5 - (double)rand.m_188501_()), d1 + (double)(rand.m_188501_() / 5.0f), d2, d3, d4);
        }
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 3 && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && worldIn.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_(4) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            TallFoulBerryBushBlock.setHalfState((Level)worldIn, pos, state, i + 1);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.m_6095_() != EntityType.f_20550_ && entityIn.m_6095_() != AutumnityEntityTypes.SNAIL.get() && entityIn.m_6095_() != AutumnityEntityTypes.TURKEY.get()) {
            LivingEntity livingentity = (LivingEntity)entityIn;
            livingentity.m_7601_(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(worldIn.f_46443_ || livingentity.m_21023_(MobEffects.f_19614_) || livingentity.m_6144_())) {
                livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60));
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        boolean flag;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && player.m_21120_(handIn).m_41720_() == Items.f_42499_) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            TallFoulBerryBushBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AutumnityItems.FOUL_BERRIES.get(), 2));
            worldIn.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i - 1)), 2);
            TallFoulBerryBushBlock.setHalfState(worldIn, pos, state, i - 1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    public void placeAt(LevelAccessor worldIn, BlockPos pos, int flags) {
        this.placeAt(worldIn, pos, 3, flags);
    }

    public void placeAt(LevelAccessor worldIn, BlockPos pos, int age, int flags) {
        worldIn.m_7731_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(age)), flags);
        worldIn.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(age)), flags);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52858_, AGE});
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.m_61143_((Property)AGE) + 1);
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
        TallFoulBerryBushBlock.setHalfState((Level)worldIn, pos, state, i);
    }

    private static void setHalfState(Level worldIn, BlockPos pos, BlockState state, int age) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            if (worldIn.m_8055_(pos.m_7495_()).m_60734_() == AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get()) {
                worldIn.m_7731_(pos.m_7495_(), (BlockState)worldIn.m_8055_(pos.m_7495_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
            }
        } else if (worldIn.m_8055_(pos.m_7494_()).m_60734_() == AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get()) {
            worldIn.m_7731_(pos.m_7494_(), (BlockState)worldIn.m_8055_(pos.m_7494_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
        }
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        if (!(entity instanceof Snail) && !(entity instanceof Turkey)) {
            return BlockPathTypes.DAMAGE_OTHER;
        }
        return super.getBlockPathType(state, world, pos, entity);
    }
}

