/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.builtin;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.atmospheric.common.levelgen.structure.processor.PreventWaterloggingSpreadProcessor;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericLootTableProvider;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;

public class AtmosphericProcessorLists {
    public static final ResourceKey<StructureProcessorList> PREVENT_WATERLOGGING_SPREAD = AtmosphericProcessorLists.createKey("prevent_waterlogging_spread");
    public static final ResourceKey<StructureProcessorList> ZOMBIE_SCRUBLAND = AtmosphericProcessorLists.createKey("zombie_scrubland");
    public static final ResourceKey<StructureProcessorList> FARM_SCRUBLAND = AtmosphericProcessorLists.createKey("farm_scrubland");
    public static final ResourceKey<StructureProcessorList> PETRIFIED_ARID_GARDEN = AtmosphericProcessorLists.createKey("petrified_arid_garden");
    public static final ResourceKey<StructureProcessorList> ARID_GARDEN_SAND_ARCHAEOLOGY = AtmosphericProcessorLists.createKey("arid_garden_sand_archaeology");

    private static ResourceKey<StructureProcessorList> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("atmospheric", name));
    }

    private static void register(BootstapContext<StructureProcessorList> context, ResourceKey<StructureProcessorList> key, List<StructureProcessor> processors) {
        context.m_255272_(key, (Object)new StructureProcessorList(processors));
    }

    public static void bootstrap(BootstapContext<StructureProcessorList> context) {
        AtmosphericProcessorLists.register(context, PREVENT_WATERLOGGING_SPREAD, (List<StructureProcessor>)ImmutableList.of((Object)((Object)new PreventWaterloggingSpreadProcessor())));
        AtmosphericProcessorLists.register(context, ZOMBIE_SCRUBLAND, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new TagMatchTest(BlockTags.f_13103_), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50016_.m_49966_()), (Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50681_), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50016_.m_49966_()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.LAUREL_LOG.get(), 0.02f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50033_.m_49966_()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.LAUREL_PLANKS.get(), 0.07f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50033_.m_49966_()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.MORADO_PLANKS.get(), 0.07f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50033_.m_49966_()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.CARMINE_SHINGLES.get(), 0.1f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50033_.m_49966_()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AtmosphericBlocks.CARMINE_SHINGLE_STAIRS.get(), 0.1f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50033_.m_49966_()), (Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.8f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50444_.m_49966_()))), (Object)((Object)new PreventWaterloggingSpreadProcessor())));
        AtmosphericProcessorLists.register(context, FARM_SCRUBLAND, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.f_50092_, 0.8f), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_50444_.m_49966_()))), (Object)((Object)new PreventWaterloggingSpreadProcessor())));
        AtmosphericProcessorLists.register(context, PETRIFIED_ARID_GARDEN, (List<StructureProcessor>)ImmutableList.of((Object)new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest((Block)AtmosphericBlocks.ARID_SAND.get()), (RuleTest)AlwaysTrueTest.f_73954_, Blocks.f_271197_.m_49966_()))), (IntProvider)ConstantInt.m_146483_((int)6)), (Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTableProvider.AtmosphericArchaeologyLoot.ARID_GARDEN_COMMON, 8), (Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTableProvider.AtmosphericArchaeologyLoot.ARID_GARDEN_RARE, 6), (Object)new CappedProcessor((StructureProcessor)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.f_50016_), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)AtmosphericBlocks.ARID_SAND.get()).m_49966_()))), (IntProvider)ConstantInt.m_146483_((int)1000)), (Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTableProvider.AtmosphericArchaeologyLoot.ARID_GARDEN_COMMON, 10), (Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTableProvider.AtmosphericArchaeologyLoot.ARID_GARDEN_RARE, 2)));
        AtmosphericProcessorLists.register(context, ARID_GARDEN_SAND_ARCHAEOLOGY, (List<StructureProcessor>)ImmutableList.of((Object)AtmosphericProcessorLists.aridGardenArchyLootProcessor(AtmosphericLootTableProvider.AtmosphericArchaeologyLoot.ARID_GARDEN_COMMON, 3)));
    }

    private static CappedProcessor aridGardenArchyLootProcessor(ResourceLocation lootTable, int max) {
        return new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest((Block)AtmosphericBlocks.ARID_SAND.get()), (RuleTest)AlwaysTrueTest.f_73954_, (PosRuleTest)PosAlwaysTrueTest.f_74188_, ((Block)AtmosphericBlocks.SUSPICIOUS_ARID_SAND.get()).m_49966_(), (RuleBlockEntityModifier)new AppendLoot(lootTable)))), (IntProvider)ConstantInt.m_146483_((int)max));
    }
}

