/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class YuccaTreeFeature
extends BlueprintTreeFeature {
    public YuccaTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int trunkHeight = config.f_68190_.m_226153_(random);
        for (int y = 0; y < trunkHeight; ++y) {
            this.addLog(origin.m_6630_(y));
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos pos = this.createYuccaBranch(origin.m_6630_(trunkHeight - 1), direction, random);
            this.createLeafLayer(pos.m_7494_(), random, false);
            this.createLeafLayer(pos, random, true);
            this.createLeafLayer(pos.m_7495_(), random, false);
        }
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.YUCCA_SAPLING.get()).m_49966_();
    }

    public BlockPos createYuccaBranch(BlockPos pos, Direction direction, RandomSource rand) {
        int length = 4 + rand.m_188503_(2);
        for (int i = 0; i < length; ++i) {
            this.addLog(pos.m_121945_(direction));
            if (i == length - 1) continue;
            pos = pos.m_7494_().m_5484_(direction, rand.m_188503_(2));
        }
        return pos.m_121945_(direction);
    }

    public void createLeafLayer(BlockPos newPos, RandomSource random, boolean square) {
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                if (square) {
                    this.addFoliage(newPos.m_7918_(i, 0, k));
                    continue;
                }
                if (Math.abs(i) != 1 || Math.abs(k) != 1) {
                    this.addFoliage(newPos.m_7918_(i, 0, k));
                    continue;
                }
                if (random.m_188503_(4) != 0) continue;
                this.addFoliage(newPos.m_7918_(i, 0, k));
            }
        }
    }
}

