/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableInt;

public class SurfaceFossilFeature
extends Feature<FossilFeatureConfiguration> {
    public SurfaceFossilFeature(Codec<FossilFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FossilFeatureConfiguration> context) {
        int i;
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        FossilFeatureConfiguration config = (FossilFeatureConfiguration)context.m_159778_();
        int fossilIndex = random.m_188503_(config.f_159797_.size());
        StructureTemplateManager structureManager = level.m_6018_().m_7654_().m_236738_();
        StructureTemplate fossilStructure = structureManager.m_230359_((ResourceLocation)config.f_159797_.get(fossilIndex));
        ChunkPos chunkPos = new ChunkPos(origin);
        BoundingBox boundingBox = new BoundingBox(chunkPos.m_45604_() - 16, level.m_141937_(), chunkPos.m_45605_() - 16, chunkPos.m_45608_() + 16, level.m_151558_(), chunkPos.m_45609_() + 16);
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_74381_(boundingBox).m_230324_(random);
        Vec3i size = fossilStructure.m_163808_(rotation);
        BlockPos offsetPos = origin.m_7918_(-size.m_123341_() / 2, 0, -size.m_123343_() / 2);
        int y = level.m_151558_();
        for (i = 0; i < size.m_123341_(); ++i) {
            for (int j = 0; j < size.m_123343_(); ++j) {
                y = Math.min(y, level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, offsetPos.m_123341_() + i, offsetPos.m_123343_() + j));
            }
        }
        i = Math.max(y - random.m_188503_(10), level.m_141937_() + 64);
        BlockPos pos = fossilStructure.m_74583_(offsetPos.m_175288_(i), Mirror.NONE, rotation);
        if (SurfaceFossilFeature.countEmptyCorners(level, fossilStructure.m_74633_(settings, pos)) > config.f_159801_) {
            return false;
        }
        settings.m_74394_();
        List processors = ((StructureProcessorList)config.f_159799_.m_203334_()).m_74425_();
        Objects.requireNonNull(settings);
        processors.forEach(arg_0 -> ((StructurePlaceSettings)settings).m_74383_(arg_0));
        fossilStructure.m_230328_((ServerLevelAccessor)level, pos, pos, settings, random, 4);
        return true;
    }

    private static int countEmptyCorners(WorldGenLevel level, BoundingBox boundingBox) {
        MutableInt mutableInt = new MutableInt(0);
        boundingBox.m_162380_(pos -> {
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_() || state.m_60713_(Blocks.f_49991_) || state.m_60713_(Blocks.f_49990_)) {
                mutableInt.add(1);
            }
        });
        return mutableInt.getValue();
    }
}

