/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericEntityTypeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.atmospheric.core.registry.builtin.AtmosphericDamageTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BarrelCactusBlock
extends Block
implements IPlantable,
BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] COLLISION_BY_AGE = new VoxelShape[]{Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)};

    public BarrelCactusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60734_() instanceof BarrelCactusBlock) {
            return (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min(3, (Integer)state.m_61143_((Property)AGE) + 1)));
        }
        return this.m_49966_();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_43722_().m_41720_() == AtmosphericItems.BARREL_CACTUS.get() && (Integer)state.m_61143_((Property)AGE) < 3 || super.m_6864_(state, useContext);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)AtmosphericItems.BARREL_CACTUS.get());
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 3 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_(3) == 0 ? 1 : 0) != 0)) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)));
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COLLISION_BY_AGE[(Integer)state.m_61143_((Property)AGE)];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)AGE)];
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState downState = worldIn.m_8055_(pos.m_7495_());
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(worldIn.m_8055_(pos.m_121945_(direction)).m_60734_() instanceof CactusBlock)) continue;
            return false;
        }
        return downState.m_204336_(AtmosphericBlockTags.BARREL_CACTUS_PLACEABLE) && !worldIn.m_8055_(pos.m_7494_()).m_278721_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!entity.m_6095_().m_204039_(AtmosphericEntityTypeTags.CACTUS_IMMUNE) && (Integer)state.m_61143_((Property)AGE) > 0) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if ((Integer)state.m_61143_((Property)AGE) != 0) {
                    living.m_7292_(new MobEffectInstance((MobEffect)AtmosphericMobEffects.WORSENING.get(), ((Integer)state.m_61143_((Property)AGE) + 1) * 40));
                }
            }
            if (level.m_46467_() % 20L == 0L) {
                LivingEntity living;
                float damage = 0.5f * (float)((Integer)state.m_61143_((Property)AGE)).intValue();
                if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6844_(EquipmentSlot.HEAD).m_150930_((Item)AtmosphericItems.BARREL_CACTUS.get())) {
                    damage /= 2.0f;
                }
                entity.m_6469_(AtmosphericDamageTypes.barrelCactus(level), damage);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (!entity.m_20193_().m_5776_() && !serverPlayer.m_7500_()) {
                        AtmosphericCriteriaTriggers.BARREL_CACTUS_PRICK.trigger(serverPlayer);
                    }
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.DESERT;
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return this.m_49966_();
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.DANGER_OTHER;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }
}

