/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts_compatibility.core.platform;

import com.kekecreations.arts_and_crafts_compatibility.common.item.CompatBlockItem;
import com.kekecreations.arts_and_crafts_compatibility.core.platform.services.RegistryHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;

public class ForgeRegistryHelper
implements RegistryHelper {
    private static final RegistryMap registryMap = new RegistryMap();
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"arts_and_crafts_compat");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"arts_and_crafts_compat");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"arts_and_crafts_compat");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"arts_and_crafts_compat");

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, String name, Supplier<T> entry) {
        return registryMap.register(registry, name, entry);
    }

    @Override
    public Supplier<SoundEvent> registerSound(String modID, String id) {
        return SOUNDS.register(id, () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(modID, id)));
    }

    @Override
    public <T extends Block> Supplier<T> registerBlockWithItem(String modID, String id, Supplier<T> blockSupplier) {
        RegistryObject block = BLOCKS.register(id, blockSupplier);
        ITEMS.register(id, () -> new CompatBlockItem(modID, (Block)block.get(), new Item.Properties()));
        return block;
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String id, Supplier<T> blockSupplier) {
        return BLOCKS.register(id, blockSupplier);
    }

    @Override
    public Supplier<SimpleParticleType> registerParticle(String id) {
        return PARTICLE_TYPES.register(id, () -> new SimpleParticleType(false));
    }

    private static class RegistryMap {
        private final Map<ResourceLocation, DeferredRegister<?>> registries = new HashMap();

        private RegistryMap() {
        }

        private <T> RegistryObject<T> register(Registry<? super T> registry, String name, Supplier<T> entry) {
            DeferredRegister reg = this.registries.computeIfAbsent(registry.m_123023_().m_135782_(), key -> {
                ForgeRegistry forgeReg = RegistryManager.ACTIVE.getRegistry(key);
                if (forgeReg == null) {
                    return null;
                }
                DeferredRegister defReg = DeferredRegister.create((IForgeRegistry)forgeReg, (String)"arts_and_crafts_compat");
                defReg.register(FMLJavaModLoadingContext.get().getModEventBus());
                return defReg;
            });
            return reg != null ? reg.register(name, entry) : null;
        }
    }
}

