/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.forge.client;

import com.kekecreations.arts_and_crafts.client.particle.ChalkDustParticle;
import com.kekecreations.arts_and_crafts.client.renderer.entity.ACBoatRenderer;
import com.kekecreations.arts_and_crafts.client.renderer.entity.FloatingBlockRenderer;
import com.kekecreations.arts_and_crafts.client.renderer.tile.ACBedBER;
import com.kekecreations.arts_and_crafts.client.renderer.tile.DyedDecoratedPotBER;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import com.kekecreations.arts_and_crafts.core.registry.ACEntityTypes;
import com.kekecreations.arts_and_crafts.core.registry.ACParticles;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(modid="arts_and_crafts", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ACEntityTypes.FLOATING_BLOCK.get(), FloatingBlockRenderer::new);
        event.registerEntityRenderer(ACEntityTypes.BOAT.get(), context -> new ACBoatRenderer(context, false));
        event.registerEntityRenderer(ACEntityTypes.CHEST_BOAT.get(), context -> new ACBoatRenderer(context, true));
        event.registerBlockEntityRenderer(ACEntityTypes.CUSTOM_DECORATED_POT_BLOCK_ENTITY.get(), DyedDecoratedPotBER::new);
        event.registerBlockEntityRenderer(ACEntityTypes.CUSTOM_BED_BLOCK_ENTITY.get(), ACBedBER::new);
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ACBoatRenderer.BOAT, BoatModel::m_246613_);
        event.registerLayerDefinition(ACBoatRenderer.CHEST_BOAT, ChestBoatModel::m_247175_);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent registerParticleProvidersEvent) {
        for (DyeColor colours : DyeColor.values()) {
            registerParticleProvidersEvent.registerSpriteSet((ParticleType)ACParticles.getChalkDrawParticle(colours.m_41060_()), ChalkDustParticle.Factory::new);
        }
        registerParticleProvidersEvent.registerSpriteSet((ParticleType)ACParticles.BLEACHED_CHALK_DRAW.get(), ChalkDustParticle.Factory::new);
    }

    @SubscribeEvent
    public static void registerBlockColours(RegisterColorHandlersEvent.Block registerColorHandlersEvent) {
        for (DyeColor colours : DyeColor.values()) {
            registerColorHandlersEvent.register((blockState, blockAndTintGetter, blockPos, i) -> {
                if (blockAndTintGetter == null || blockPos == null) {
                    return GrassColor.m_276205_();
                }
                return BiomeColors.m_108793_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
            }, new Block[]{ACBlocks.getDyedPottedFern(colours)});
        }
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        for (DyeColor colours : DyeColor.values()) {
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getChalkDust(colours.m_41060_()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCrimsonFungus(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCrimsonRoots(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedWarpedFungus(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedWarpedRoots(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedOakSapling(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedSpruceSapling(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedBirchSapling(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedAcaciaSapling(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedJungleSapling(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCherrySapling(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedDarkOakSapling(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedMangrovePropagule(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedFern(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedDandelion(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedPoppy(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedBlueOrchid(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedAllium(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedAzureBluet(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedRedTulip(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedOrangeTulip(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedWhiteTulip(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedPinkTulip(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedOxeyeDaisy(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCornflower(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedLilyOfTheValley(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedWitherRose(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedRedMushroom(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedBrownMushroom(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedDeadBush(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCactus(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedBamboo(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedAzalea(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedFloweringAzalea(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedTorchFlower(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPottedCorkSapling(colours), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.getDyedPlaster(colours.m_41060_()), (RenderType)RenderType.m_110463_());
        }
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ACBlocks.CORK_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ACBlocks.POTTED_CORK_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ACBlocks.PLASTER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.LOTUS_FLOWER.get(), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ACBlocks.BLEACHED_CHALK_DUST.get(), (RenderType)RenderType.m_110463_());
    }
}

