/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.common.item;

import com.kekecreations.arts_and_crafts.common.block.ChalkDustBlock;
import com.kekecreations.arts_and_crafts.common.misc.KekeBlockStateProperties;
import com.kekecreations.arts_and_crafts.common.util.ChalkUtils;
import com.kekecreations.arts_and_crafts.core.platform.Services;
import com.kekecreations.arts_and_crafts.core.registry.ACBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChalkStickItem
extends Item {
    private final Integer dyeColor;
    public static final String TAG_CHALK_PATTERN = "ChalkPattern";

    public ChalkStickItem(Integer dyeColor, Item.Properties properties) {
        super(properties);
        this.dyeColor = dyeColor;
    }

    public boolean m_245993_(FeatureFlagSet $$0) {
        return Services.CONFIG.areChalkSticksEnabled();
    }

    public int getDyeColor() {
        return this.dyeColor;
    }

    public int getChalkPattern(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null && compoundTag.m_128441_(TAG_CHALK_PATTERN)) {
            return compoundTag.m_128451_(TAG_CHALK_PATTERN);
        }
        return 100;
    }

    public void setChalkPattern(ItemStack itemStack, int chalkPattern) {
        itemStack.m_41784_().m_128405_(TAG_CHALK_PATTERN, chalkPattern);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> toolTipComponents, @NotNull TooltipFlag flag) {
        super.m_7373_(itemStack, level, toolTipComponents, flag);
        if (level != null) {
            switch (this.getChalkPattern(itemStack)) {
                case 0: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_0").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 1: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_1").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 2: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_2").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 3: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_3").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 4: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_4").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 5: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_5").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 6: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_6").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 7: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_7").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 8: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_8").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 9: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_9").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 10: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_10").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 11: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_11").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 12: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_12").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 13: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_13").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 14: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_14").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 15: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_15").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 16: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_16").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 17: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_17").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 18: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_18").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 19: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_19").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 20: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_20").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 21: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_21").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 22: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_22").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 23: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_23").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 24: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_24").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 25: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_25").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 26: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_26").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 27: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_27").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 28: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_28").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 29: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_29").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 30: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_30").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 31: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_31").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case 32: {
                    toolTipComponents.add((Component)Component.m_237115_((String)"tooltip.arts_and_crafts.chalk_pattern_32").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Player player = useOnContext.m_43723_();
        BlockPos blockPos = useOnContext.m_8083_();
        Level level = useOnContext.m_43725_();
        BlockState blockState = level.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        RandomSource random = level.m_213780_();
        Vec3 clickLocation = useOnContext.m_43720_();
        ItemStack itemStack = useOnContext.m_43722_();
        if (level.m_5776_() && block instanceof ChalkDustBlock) {
            ChalkDustBlock chalkDustBlock = (ChalkDustBlock)block;
            if (player != null) {
                if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ChalkStickItem && !(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ChalkStickItem)) {
                    if (chalkDustBlock.getDyeColor() == this.getDyeColor()) {
                        ChalkUtils.spawnChalkParticle(level, clickLocation.m_7096_(), clickLocation.m_7098_() + 0.2, clickLocation.m_7094_(), this.getDyeColor());
                    }
                } else if (!player.m_6144_() && chalkDustBlock.getDyeColor() == this.getDyeColor()) {
                    ChalkUtils.spawnChalkParticle(level, clickLocation.m_7096_(), clickLocation.m_7098_() + 0.2, clickLocation.m_7094_(), this.getDyeColor());
                }
            }
        }
        if (!level.m_5776_()) {
            if (itemStack.m_41783_() != null && !itemStack.m_41783_().m_128441_(TAG_CHALK_PATTERN)) {
                this.setChalkPattern(itemStack, 0);
            }
            InteractionResult interactionResult = this.place(new BlockPlaceContext(useOnContext));
            if (block instanceof ChalkDustBlock) {
                ChalkDustBlock chalkDustBlock = (ChalkDustBlock)block;
                if (player != null) {
                    if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ChalkStickItem && !(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ChalkStickItem)) {
                        if (chalkDustBlock.getDyeColor() == this.getDyeColor()) {
                            ChalkUtils.spawnChalkParticle(level, clickLocation.m_7096_(), clickLocation.m_7098_() + 0.2, clickLocation.m_7094_(), this.getDyeColor());
                            level.m_46597_(blockPos, ChalkUtils.changeChalkDustState(blockState, player, 1));
                            level.m_5594_(null, blockPos, SoundEvents.f_144094_, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.2f + 0.9f);
                            return InteractionResult.SUCCESS;
                        }
                    } else {
                        if (player.m_6144_()) {
                            this.setChalkPattern(player.m_21120_(InteractionHand.MAIN_HAND), ChalkUtils.getChalkPatternFromChalkDust(blockState));
                            return InteractionResult.SUCCESS;
                        }
                        if (chalkDustBlock.getDyeColor() == this.getDyeColor()) {
                            ChalkUtils.spawnChalkParticle(level, clickLocation.m_7096_(), clickLocation.m_7098_() + 0.2, clickLocation.m_7094_(), this.getDyeColor());
                            level.m_46597_(blockPos, ChalkUtils.changeChalkDustState(blockState, player, 1));
                            level.m_5594_(null, blockPos, SoundEvents.f_144094_, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.2f + 0.9f);
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
            return interactionResult;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult place(BlockPlaceContext blockPlaceContext) {
        if (!blockPlaceContext.m_7059_() || blockPlaceContext.m_8083_().m_123342_() > 319) {
            return InteractionResult.FAIL;
        }
        Level level = blockPlaceContext.m_43725_();
        BlockPos pos = blockPlaceContext.m_8083_();
        Player player = blockPlaceContext.m_43723_();
        ItemStack itemStack = blockPlaceContext.m_43722_();
        Item item = itemStack.m_41720_();
        if (item instanceof ChalkStickItem) {
            ChalkStickItem chalkStick = (ChalkStickItem)item;
            BlockState state = ACBlocks.getChalkDust(this.getDyeColor()).m_5573_(blockPlaceContext);
            BlockState clickedState = level.m_8055_(pos);
            if (state != null && !(clickedState.m_60734_() instanceof ChalkDustBlock)) {
                RandomSource randomSource = level.m_213780_();
                if (chalkStick.getChalkPattern(itemStack) != 100) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)KekeBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(chalkStick.getChalkPattern(itemStack))));
                } else {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)KekeBlockStateProperties.CHALK_PATTERN, (Comparable)Integer.valueOf(0)));
                }
                level.m_5594_(null, pos, SoundEvents.f_144094_, SoundSource.BLOCKS, 0.5f, randomSource.m_188501_() * 0.2f + 0.9f);
                level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)clickedState));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10591_.m_285767_(serverPlayer, pos, itemStack);
                }
                clickedState.m_60734_().m_6402_(level, pos, clickedState, (LivingEntity)player, itemStack);
                if (player != null && !player.m_150110_().f_35937_ && !(clickedState.m_60734_() instanceof ChalkDustBlock)) {
                    itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(blockPlaceContext.m_43724_()));
                }
                if (!level.m_5776_()) {
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }
}

