/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.client.renderer.tile;

import com.kekecreations.arts_and_crafts.common.entity.DyedDecoratedPotBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;

public class DyedDecoratedPotBER
implements BlockEntityRenderer<DyedDecoratedPotBlockEntity> {
    private static final String NECK = "neck";
    private static final String FRONT = "front";
    private static final String BACK = "back";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private final ModelPart neck;
    private final ModelPart frontSide;
    private final ModelPart backSide;
    private final ModelPart leftSide;
    private final ModelPart rightSide;
    private final ModelPart top;
    private final ModelPart bottom;
    private Material baseMaterial = Objects.requireNonNull(Sheets.m_272280_((ResourceKey)DecoratedPotPatterns.f_271266_));

    public DyedDecoratedPotBER(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(ModelLayers.f_271426_);
        this.neck = modelPart.m_171324_(NECK);
        this.top = modelPart.m_171324_(TOP);
        this.bottom = modelPart.m_171324_(BOTTOM);
        ModelPart modelPart2 = context.m_173582_(ModelLayers.f_271216_);
        this.frontSide = modelPart2.m_171324_(FRONT);
        this.backSide = modelPart2.m_171324_(BACK);
        this.leftSide = modelPart2.m_171324_(LEFT);
        this.rightSide = modelPart2.m_171324_(RIGHT);
    }

    public void render(DyedDecoratedPotBlockEntity decoratedPotBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        this.baseMaterial = new Material(Sheets.f_271463_, this.renderBaseMaterial(decoratedPotBlockEntity));
        poseStack.m_85836_();
        Direction direction = decoratedPotBlockEntity.getDirection();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - direction.m_122435_()));
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        VertexConsumer vertexConsumer = this.baseMaterial.m_119194_(multiBufferSource, RenderType::m_110446_);
        this.neck.m_104301_(poseStack, vertexConsumer, i, j);
        this.top.m_104301_(poseStack, vertexConsumer, i, j);
        this.bottom.m_104301_(poseStack, vertexConsumer, i, j);
        DecoratedPotBlockEntity.Decorations decorations = decoratedPotBlockEntity.getDecorations();
        this.renderSide(this.frontSide, poseStack, multiBufferSource, i, j, decorations.f_283810_(), decoratedPotBlockEntity);
        this.renderSide(this.backSide, poseStack, multiBufferSource, i, j, decorations.f_283886_(), decoratedPotBlockEntity);
        this.renderSide(this.leftSide, poseStack, multiBufferSource, i, j, decorations.f_283809_(), decoratedPotBlockEntity);
        this.renderSide(this.rightSide, poseStack, multiBufferSource, i, j, decorations.f_283873_(), decoratedPotBlockEntity);
        poseStack.m_85849_();
    }

    private void renderSide(ModelPart modelPart, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, Item item, DyedDecoratedPotBlockEntity pot) {
        Minecraft instance = Minecraft.m_91087_();
        TextureAtlas textureAtlas = instance.m_91304_().m_119428_(Sheets.f_271463_);
        TextureAtlasSprite sprite = textureAtlas.m_118316_(this.renderSideMaterial(pot, item));
        VertexConsumer vertex = sprite.m_118381_(multiBufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)Sheets.f_271463_)));
        modelPart.m_104301_(poseStack, vertex, i, j);
    }

    private ResourceLocation renderSideMaterial(DyedDecoratedPotBlockEntity potEntity, Item item) {
        ResourceKey patternKey = DecoratedPotPatterns.m_271696_((Item)item);
        if (patternKey != null) {
            return patternKey.m_135782_().m_247266_(path -> "entity/decorated_pot/" + path + "_" + potEntity.getDyeColor().m_41065_());
        }
        return new ResourceLocation("entity/decorated_pot/decorated_pot_side_" + potEntity.getDyeColor().m_41065_());
    }

    private ResourceLocation renderBaseMaterial(DyedDecoratedPotBlockEntity potEntity) {
        return new ResourceLocation("entity/decorated_pot/decorated_pot_base_" + potEntity.getDyeColor().m_41065_());
    }
}

