/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.arts_and_crafts.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.kekecreations.arts_and_crafts.common.entity.ACBoat;
import com.kekecreations.arts_and_crafts.common.entity.ACChestBoat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class ACBoatRenderer
extends EntityRenderer<Boat> {
    public static final ModelLayerLocation BOAT = new ModelLayerLocation(new ResourceLocation("arts_and_crafts", "boat"), "main");
    public static final ModelLayerLocation CHEST_BOAT = new ModelLayerLocation(new ResourceLocation("arts_and_crafts", "chest_boat"), "main");
    private final Map<ACBoat.WoodType, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(ACBoat.WoodType.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)ACBoatRenderer.getTextureLocation(type, chestBoat), this.createBoatModel(context, (ACBoat.WoodType)((Object)type), chestBoat))));

    public ACBoatRenderer(EntityRendererProvider.Context context, boolean chestBoat) {
        super(context);
    }

    public void render(Boat boat, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        float h;
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.375f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float f = (float)boat.m_38385_() - partialTicks;
        float g = boat.m_38384_() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * g / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(h = boat.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStack.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getBoatPair(boat);
        ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
        ListModel listModel = (ListModel)pair.getSecond();
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listModel.m_6973_((Entity)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.m_6299_(listModel.m_103119_(resourceLocation));
        listModel.m_7695_(matrixStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexConsumer2 = buffer.m_6299_(RenderType.m_110478_());
            if (listModel instanceof WaterPatchModel) {
                WaterPatchModel waterPatchModel = (WaterPatchModel)listModel;
                waterPatchModel.m_102282_().m_104301_(matrixStack, vertexConsumer2, packedLight, OverlayTexture.f_118083_);
            }
        }
        matrixStack.m_85849_();
        super.m_7392_((Entity)boat, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, ACBoat.WoodType type, boolean chestBoat) {
        ModelPart modelPart = context.m_174023_(chestBoat ? CHEST_BOAT : BOAT);
        return chestBoat ? new ChestBoatModel(modelPart) : new BoatModel(modelPart);
    }

    private static ResourceLocation getTextureLocation(ACBoat.WoodType type, boolean chestBoat) {
        String path = chestBoat ? "textures/entity/chest_boat/" + type.name().toLowerCase() + ".png" : "textures/entity/boat/" + type.name().toLowerCase() + ".png";
        return new ResourceLocation("arts_and_crafts", path);
    }

    public ResourceLocation getTextureLocation(Boat boat) {
        return (ResourceLocation)this.getBoatPair(boat).getFirst();
    }

    private Pair<ResourceLocation, ListModel<Boat>> getBoatPair(Boat boat) {
        if (boat instanceof ACBoat) {
            ACBoat customBoat = (ACBoat)boat;
            return this.boatResources.get((Object)customBoat.getBoatWoodType());
        }
        if (boat instanceof ACChestBoat) {
            ACChestBoat customBoat = (ACChestBoat)boat;
            return this.boatResources.get((Object)customBoat.getBoatWoodType());
        }
        return this.boatResources.get((Object)ACBoat.WoodType.CORK);
    }
}

