/*
 * Decompiled with CFR 0.152.
 */
package net.archers;

import net.archers.config.ArchersItemConfig;
import net.archers.config.Default;
import net.archers.config.TweaksConfig;
import net.archers.effect.Effects;
import net.archers.item.Armors;
import net.archers.item.Group;
import net.archers.item.Weapons;
import net.archers.item.misc.Misc;
import net.archers.util.SoundHelper;
import net.fabric_extras.ranged_weapon.api.CrossbowMechanics;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.spell_engine.api.item.trinket.SpellBooks;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_power.api.enchantment.EnchantmentRestriction;
import net.tinyconfig.ConfigManager;

public class ArchersMod
implements ModInitializer {
    public static final String ID = "archers";
    public static ConfigManager<ArchersItemConfig> itemConfig = new ConfigManager("items_v2", (Object)Default.itemConfig).builder().setDirectory("archers").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory("archers").sanitize(true).build();

    public void onInitialize() {
        tweaksConfig.refresh();
        this.registerItemGroup();
        this.registerItems();
        SoundHelper.registerSounds();
        Effects.register();
        this.subscribeEvents();
        if (((TweaksConfig)ArchersMod.tweaksConfig.value).enable_infinity_for_crossbows) {
            EnchantmentRestriction.permit((class_1887)class_1893.field_9125, itemStack -> itemStack.method_7909() instanceof class_1764);
        }
        CrossbowMechanics.PullTime.modifier = (originalPullTime, crossbow) -> {
            int quickCharge = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)crossbow);
            float multiplier = ((TweaksConfig)ArchersMod.tweaksConfig.value).quick_charge_enchantment_multiplier_per_level;
            return originalPullTime - (int)((double)originalPullTime * (double)multiplier) * quickCharge;
        };
    }

    private void registerItemGroup() {
        Group.ARCHERS = FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)Armors.archerArmorSet_T2.head.method_8389())).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.archers.general")).method_47324();
        class_2378.method_39197((class_2378)class_7923.field_44687, Group.KEY, (Object)Group.ARCHERS);
    }

    private void registerItems() {
        itemConfig.refresh();
        SpellBooks.createAndRegister((class_2960)new class_2960(ID, "archer"), (SpellContainer.ContentType)SpellContainer.ContentType.ARCHERY, Group.KEY);
        Misc.register();
        Weapons.register(((ArchersItemConfig)ArchersMod.itemConfig.value).ranged_weapons, ((ArchersItemConfig)ArchersMod.itemConfig.value).melee_weapons);
        Armors.register(((ArchersItemConfig)ArchersMod.itemConfig.value).armor_sets);
        itemConfig.save();
    }

    private void subscribeEvents() {
    }
}

