/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scanning;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import dev.architectury.injectables.annotations.ExpectPlatform;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.TileIdMap;
import hunternif.mc.impl.atlas.core.scanning.ITileDetector;
import hunternif.mc.impl.atlas.core.scanning.TileHeightType;
import hunternif.mc.impl.atlas.core.scanning.forge.TileDetectorBaseImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;

public class TileDetectorBase
implements ITileDetector {
    private static final ResourceLocation waterPoolBiome = Biomes.f_48208_.m_135782_();
    private static final int priorityRavine = 12;
    private static final int priorityWaterPool = 4;
    private static final int priorityLavaPool = 6;
    private static final int ravineMinDepth = 7;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean hasSwampWater(Holder<Biome> biomeTag) {
        return TileDetectorBaseImpl.hasSwampWater(biomeTag);
    }

    static int priorityForBiome(Holder<Biome> biomeTag) {
        if (biomeTag.m_203656_(BiomeTags.f_207603_) || biomeTag.m_203656_(BiomeTags.f_207605_) || biomeTag.m_203656_(BiomeTags.f_207602_)) {
            return 4;
        }
        if (biomeTag.m_203656_(BiomeTags.f_207604_)) {
            return 3;
        }
        return 1;
    }

    protected static TileHeightType getHeightTypeFromY(int y, int sealevel) {
        if (y < sealevel + 10) {
            return TileHeightType.VALLEY;
        }
        if (y < sealevel + 20) {
            return TileHeightType.LOW;
        }
        if (y < sealevel + 35) {
            return TileHeightType.MID;
        }
        if (y < sealevel + 50) {
            return TileHeightType.HIGH;
        }
        return TileHeightType.PEAK;
    }

    protected static ResourceLocation getBiomeIdentifier(Level world, Biome biome) {
        return world.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
    }

    protected static void updateOccurrencesMap(Multiset<ResourceLocation> map, ResourceLocation biome, int weight) {
        map.add((Object)biome, weight);
    }

    protected static void updateOccurrencesMap(Multiset<ResourceLocation> map, Level world, Biome biome, TileHeightType type, int weight) {
        ResourceLocation id = TileDetectorBase.getBiomeIdentifier(world, biome);
        id = new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + type.getName());
        map.add((Object)id, weight);
    }

    @Override
    public int getScanRadius() {
        return AntiqueAtlasMod.CONFIG.scanRadius;
    }

    @Override
    public ResourceLocation getBiomeID(Level world, ChunkAccess chunk) {
        HashMultiset biomeOccurrences = HashMultiset.create((int)world.m_9598_().m_175515_(Registries.f_256952_).m_13562_());
        Registry biomeRegistry = world.m_9598_().m_175515_(Registries.f_256952_);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = (Biome)chunk.m_203495_(x, world.m_5736_(), z).m_203334_();
                Holder.Reference biomeTag = biomeRegistry.m_246971_((ResourceKey)biomeRegistry.m_7854_((Object)biome).orElse(null));
                int y = chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING).m_64242_(x, z);
                if (AntiqueAtlasMod.CONFIG.doScanPonds && y > 0) {
                    Block topBlock = chunk.m_8055_(new BlockPos(x, y - 1, z)).m_60734_();
                    if (topBlock == Blocks.f_49990_) {
                        if (TileDetectorBase.hasSwampWater((Holder<Biome>)biomeTag)) {
                            TileDetectorBase.updateOccurrencesMap((Multiset<ResourceLocation>)biomeOccurrences, TileIdMap.SWAMP_WATER, 4);
                        } else {
                            TileDetectorBase.updateOccurrencesMap((Multiset<ResourceLocation>)biomeOccurrences, waterPoolBiome, 4);
                        }
                    } else if (topBlock == Blocks.f_49991_) {
                        TileDetectorBase.updateOccurrencesMap((Multiset<ResourceLocation>)biomeOccurrences, TileIdMap.TILE_LAVA, 6);
                    }
                }
                if (AntiqueAtlasMod.CONFIG.doScanRavines && y > 0 && y < world.m_5736_() - 7) {
                    TileDetectorBase.updateOccurrencesMap((Multiset<ResourceLocation>)biomeOccurrences, TileIdMap.TILE_RAVINE, 12);
                }
                TileDetectorBase.updateOccurrencesMap((Multiset<ResourceLocation>)biomeOccurrences, world, biome, TileDetectorBase.getHeightTypeFromY(y, world.m_5736_()), TileDetectorBase.priorityForBiome((Holder<Biome>)biomeTag));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        return (ResourceLocation)((Multiset.Entry)biomeOccurrences.entrySet().stream().max(Ordering.natural().onResultOf(Multiset.Entry::getCount)).orElseThrow()).getElement();
    }
}

