/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.network.packet.s2c.play.PutGlobalTileS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.Streams;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class TileDataStorage
extends SavedData {
    private static final int VERSION = 3;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_TILE_LIST = "tiles";
    private static final int CHUNK_SIZE = 10000;
    private final Map<ChunkPos, ResourceLocation> tiles = new ConcurrentHashMap<ChunkPos, ResourceLocation>(2, 0.75f, 2);

    public static TileDataStorage readNbt(CompoundTag compound) {
        TileDataStorage data = new TileDataStorage();
        int version = compound.m_128451_(TAG_VERSION);
        if (version < 3) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 3);
            return data;
        }
        ListTag tileList = compound.m_128437_(TAG_TILE_LIST, 10);
        tileList.forEach(tag1 -> {
            CompoundTag tile = (CompoundTag)tag1;
            ChunkPos coords = new ChunkPos(tile.m_128451_("x"), tile.m_128451_("y"));
            data.tiles.put(coords, ResourceLocation.m_135820_((String)tile.m_128461_("id")));
        });
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128405_(TAG_VERSION, 3);
        ListTag tileList = new ListTag();
        for (Map.Entry<ChunkPos, ResourceLocation> entry : this.tiles.entrySet()) {
            CompoundTag tile = new CompoundTag();
            tile.m_128405_("x", entry.getKey().f_45578_);
            tile.m_128405_("y", entry.getKey().f_45579_);
            tile.m_128359_("id", entry.getValue().toString());
            tileList.add((Object)tile);
        }
        compound.m_128365_(TAG_TILE_LIST, (Tag)tileList);
        return compound;
    }

    public ResourceLocation getTile(int x, int z) {
        return this.tiles.get(new ChunkPos(x, z));
    }

    public void setTile(int x, int z, ResourceLocation tile) {
        this.tiles.put(new ChunkPos(x, z), tile);
        this.m_77762_();
    }

    public void removeTile(int x, int z) {
        this.tiles.remove(new ChunkPos(x, z));
        this.m_77762_();
    }

    public void syncToPlayer(Player player, ResourceKey<Level> world) {
        Streams.chunked(this.tiles.entrySet().stream(), 10000).forEach(chunk -> new PutGlobalTileS2CPacket(world, (List<Map.Entry<ChunkPos, ResourceLocation>>)chunk).send((ServerPlayer)player));
        Log.info("Sent custom biome data to player %s", player.m_20203_().m_81368_());
    }
}

