/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.network.packet.s2c.play.MapDataS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class AtlasData
extends SavedData {
    public static final int VERSION = 4;
    public static final String TAG_VERSION = "aaVersion";
    public static final String TAG_WORLD_MAP_LIST = "qWorldMap";
    public static final String TAG_WORLD_ID = "qWorldID";
    public static final String TAG_VISITED_CHUNKS = "qVisitedChunks";
    public static final String TAG_BROWSING_X = "qBrowseX";
    public static final String TAG_BROWSING_Y = "qBrowseY";
    public static final String TAG_BROWSING_ZOOM = "qBrowseZoom";
    private final Map<ResourceKey<Level>, WorldData> worldMap = new ConcurrentHashMap<ResourceKey<Level>, WorldData>(2, 0.75f, 2);
    private final Set<Player> playersSentTo = new HashSet<Player>();

    public static AtlasData fromNbt(CompoundTag compound) {
        AtlasData data = new AtlasData();
        data.updateFromNbt(compound);
        return data;
    }

    public void updateFromNbt(CompoundTag compound) {
        int version = compound.m_128451_(TAG_VERSION);
        if (version < 4) {
            Log.warn("Outdated atlas data format! Was %d but current is %d.", version, 4);
            return;
        }
        ListTag worldMapList = compound.m_128437_(TAG_WORLD_MAP_LIST, 10);
        for (int d = 0; d < worldMapList.size(); ++d) {
            CompoundTag worldTag = worldMapList.m_128728_(d);
            ResourceKey worldID = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(worldTag.m_128461_(TAG_WORLD_ID)));
            ListTag dimensionTag = (ListTag)worldTag.m_128423_(TAG_VISITED_CHUNKS);
            WorldData dimData = this.getWorldData((ResourceKey<Level>)worldID);
            dimData.readFromNBT(dimensionTag);
            double zoom = worldTag.m_128459_(TAG_BROWSING_ZOOM);
            if (zoom == 0.0) {
                zoom = 0.5;
            }
            dimData.setBrowsingPosition(worldTag.m_128451_(TAG_BROWSING_X), worldTag.m_128451_(TAG_BROWSING_Y), zoom);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        return this.writeToNBT(compound, true);
    }

    public CompoundTag writeToNBT(CompoundTag compound, boolean includeTileData) {
        ListTag dimensionMapList = new ListTag();
        compound.m_128405_(TAG_VERSION, 4);
        for (Map.Entry<ResourceKey<Level>, WorldData> dimensionEntry : this.worldMap.entrySet()) {
            CompoundTag dimTag = new CompoundTag();
            dimTag.m_128359_(TAG_WORLD_ID, dimensionEntry.getKey().m_135782_().toString());
            WorldData dimData = dimensionEntry.getValue();
            if (includeTileData) {
                dimTag.m_128365_(TAG_VISITED_CHUNKS, (Tag)dimData.writeToNBT());
            }
            dimTag.m_128405_(TAG_BROWSING_X, dimData.getBrowsingX());
            dimTag.m_128405_(TAG_BROWSING_Y, dimData.getBrowsingY());
            dimTag.m_128347_(TAG_BROWSING_ZOOM, dimData.getBrowsingZoom());
            dimensionMapList.add((Object)dimTag);
        }
        compound.m_128365_(TAG_WORLD_MAP_LIST, (Tag)dimensionMapList);
        return compound;
    }

    public void setTile(ResourceKey<Level> world, int x, int y, ResourceLocation tile) {
        WorldData worldData = this.getWorldData(world);
        worldData.setTile(x, y, tile);
    }

    public ResourceLocation removeTile(ResourceKey<Level> world, int x, int y) {
        WorldData dimData = this.getWorldData(world);
        return dimData.removeTile(x, y);
    }

    public Set<ResourceKey<Level>> getVisitedWorlds() {
        return this.worldMap.keySet();
    }

    public WorldData getWorldData(ResourceKey<Level> world) {
        return this.worldMap.computeIfAbsent(world, k -> new WorldData(this, world));
    }

    public Map<ChunkPos, ResourceLocation> getSeenChunksInWorld(ResourceKey<Level> world) {
        return this.getWorldData(world).getSeenChunks();
    }

    public Collection<Player> getSyncedPlayers() {
        return Collections.unmodifiableCollection(this.playersSentTo);
    }

    public boolean isSyncedToPlayer(Player player) {
        return this.playersSentTo.contains(player);
    }

    public void syncToPlayer(int atlasID, Player player) {
        CompoundTag data = new CompoundTag();
        this.writeToNBT(data, false);
        new MapDataS2CPacket(atlasID, data).send((ServerPlayer)player);
        for (ResourceKey<Level> world : this.worldMap.keySet()) {
            this.worldMap.get(world).syncToPlayer(atlasID, player);
        }
        Log.info("Sent Atlas #%d data to player %s", atlasID, player.m_20203_().m_81368_());
        this.playersSentTo.add(player);
    }

    public boolean isEmpty() {
        return this.worldMap.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AtlasData)) {
            return false;
        }
        AtlasData other = (AtlasData)((Object)obj);
        if (other.worldMap.size() != this.worldMap.size()) {
            return false;
        }
        for (ResourceKey<Level> key : this.worldMap.keySet()) {
            if (this.worldMap.get(key).equals(other.worldMap.get(key))) continue;
            return false;
        }
        return true;
    }
}

