/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class ATexture
implements ITexture {
    final ResourceLocation texture;
    final boolean autobind;
    private final RenderType LAYER;

    public ATexture(ResourceLocation texture) {
        this(texture, true);
    }

    public ATexture(ResourceLocation texture, boolean autobind) {
        this.texture = texture;
        this.autobind = autobind;
        this.LAYER = RenderType.m_110497_((ResourceLocation)texture);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
    }

    @Override
    public void draw(GuiGraphics context, int x, int y) {
        this.draw(context, x, y, this.width(), this.height());
    }

    @Override
    public void draw(GuiGraphics context, int x, int y, int width, int height) {
        this.draw(context, x, y, width, height, 0, 0, this.width(), this.height());
    }

    @Override
    public void draw(GuiGraphics context, int x, int y, int u, int v, int regionWidth, int regionHeight) {
        this.draw(context, x, y, regionWidth, regionHeight, u, v, regionWidth, regionHeight);
    }

    @Override
    public void draw(GuiGraphics context, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight) {
        if (this.autobind) {
            this.bind();
        }
        context.m_280411_(this.getTexture(), x, y, width, height, (float)u, (float)v, regionWidth, regionHeight, this.width(), this.height());
    }

    @Override
    public void drawCenteredWithRotation(GuiGraphics context, int x, int y, int width, int height, float rotation) {
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        context.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f + rotation));
        context.m_280168_().m_252880_((float)(-width) / 2.0f, (float)(-height) / 2.0f, 0.0f);
        this.draw(context, 0, 0, width, height);
        context.m_280168_().m_85849_();
    }

    @Override
    public void drawWithLight(MultiBufferSource consumer, PoseStack matrices, int x, int y, int width, int height, int light) {
        this.drawWithLight(consumer, matrices, x, y, width, height, 0, 0, this.width(), this.height(), light);
    }

    @Override
    public void drawWithLight(MultiBufferSource consumer, PoseStack matrices, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int light) {
        if (this.autobind) {
            this.bind();
        }
        this.drawTexturedQuadWithLight(consumer, matrices.m_85850_().m_252922_(), x, x + width, y, y + height, ((float)u + 0.0f) / (float)this.width(), ((float)u + (float)regionWidth) / (float)this.width(), ((float)v + 0.0f) / (float)this.height(), ((float)v + (float)regionHeight) / (float)this.height(), light);
    }

    private void drawTexturedQuadWithLight(MultiBufferSource vertexConsumer, Matrix4f matrices, int x0, int x1, int y0, int y1, float u0, float u1, float v0, float v1, int light) {
        VertexConsumer consumer = vertexConsumer.m_6299_(this.LAYER);
        consumer.m_252986_(matrices, (float)x0, (float)y1, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_85969_(light).m_5752_();
        consumer.m_252986_(matrices, (float)x1, (float)y1, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_85969_(light).m_5752_();
        consumer.m_252986_(matrices, (float)x1, (float)y0, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_85969_(light).m_5752_();
        consumer.m_252986_(matrices, (float)x0, (float)y0, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_85969_(light).m_5752_();
    }
}

