/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.api.impl;

import hunternif.mc.api.MarkerAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.packet.c2s.play.DeleteMarkerC2SPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.DeleteMarkerS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.PutMarkersS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collections;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkerApiImpl
implements MarkerAPI {
    private static final int GLOBAL = -1;

    @Override
    @Nullable
    public Marker putMarker(@NotNull Level world, boolean visibleAhead, int atlasID, ResourceLocation marker, Component label, int x, int z) {
        return this.doPutMarker(world, visibleAhead, atlasID, marker, label, x, z);
    }

    @Override
    @Nullable
    public Marker putGlobalMarker(@NotNull Level world, boolean visibleAhead, ResourceLocation marker, Component label, int x, int z) {
        return this.doPutMarker(world, visibleAhead, -1, marker, label, x, z);
    }

    private Marker doPutMarker(Level world, boolean visibleAhead, int atlasID, ResourceLocation markerId, Component label, int x, int z) {
        Marker marker = null;
        if (!world.f_46443_ && world.m_7654_() != null) {
            GlobalMarkersData data = atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            marker = ((MarkersData)data).createAndSaveMarker(markerId, (ResourceKey<Level>)world.m_46472_(), x, z, visibleAhead, label);
            new PutMarkersS2CPacket(atlasID, (ResourceKey<Level>)world.m_46472_(), Collections.singleton(marker)).send((ServerLevel)world);
        }
        return marker;
    }

    @Override
    public void deleteMarker(@NotNull Level world, int atlasID, int markerID) {
        this.doDeleteMarker(world, atlasID, markerID);
    }

    @Override
    public void deleteGlobalMarker(@NotNull Level world, int markerID) {
        this.doDeleteMarker(world, -1, markerID);
    }

    private void doDeleteMarker(Level world, int atlasID, int markerID) {
        if (world.f_46443_) {
            if (atlasID == -1) {
                Log.warn("Client tried to delete a global marker!", new Object[0]);
            } else {
                new DeleteMarkerC2SPacket(atlasID, markerID).send();
            }
        } else {
            GlobalMarkersData data = atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            data.removeMarker(markerID);
            new DeleteMarkerS2CPacket(atlasID, markerID).send(((ServerLevel)world).m_7654_());
        }
    }
}

