/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.world.noise.OpenSimplex2S;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class PillarRockFeature
extends Feature<SimpleBlockConfiguration> {
    private static final int RADIUS_MIN = 5;
    private static final int RADIUS_MAX = 10;
    private static final float HEIGHT_RELATIVE_TO_RADIUS_MIN = 1.5f;
    private static final float HEIGHT_RELATIVE_TO_RADIUS_MAX = 2.0f;
    private static final float TOP_HEIGHT_PROPORTION = 0.3f;
    private static final float TOP_START_HEMISPHERE_OFFSET_MIN = 0.875f;
    private static final float TOP_START_HEMISPHERE_OFFSET_MAX = 0.9375f;
    private static final float BOTTOM_START_HEMISPHERE_OFFSET_MIN = 0.25f;
    private static final float BOTTOM_START_HEMISPHERE_OFFSET_MAX = 0.5f;
    private static final double NOISE_FREQUENCY_XZ = 0.1;
    private static final double NOISE_FREQUENCY_Y = 0.08333333333333334;
    public static final float NOISE_MODULATION_AMOUNT = 0.6f;
    private static final long NOISE_SEED_FLIP_MASK = 4187418520378946841L;

    public PillarRockFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        SimpleBlockConfiguration config = (SimpleBlockConfiguration)context.m_159778_();
        BlockState state = config.f_68069_().m_213972_(context.m_225041_(), context.m_159777_());
        long noiseSeed = level.m_7328_() ^ 0x3A1CB2F559143519L;
        float radXZ = Mth.m_14207_((float)random.m_188501_()) * 5.0f + 5.0f;
        float height = Mth.m_216267_((RandomSource)random, (float)1.5f, (float)2.0f) * radXZ;
        float topHeight = radXZ * 0.3f;
        float bottomHeight = height - topHeight;
        float creasePositionY = height * 0.5f - topHeight;
        float topStartHemisphereOffset = Mth.m_216267_((RandomSource)random, (float)0.875f, (float)0.9375f);
        float bottomStartHemisphereOffset = Mth.m_216267_((RandomSource)random, (float)0.25f, (float)0.5f);
        float dyTopMultiplier = (1.0f - topStartHemisphereOffset) / topHeight;
        float dyBottomMultiplier = (bottomStartHemisphereOffset - 1.0f) / bottomHeight;
        float dyTopOffset = topStartHemisphereOffset - dyTopMultiplier * creasePositionY;
        float dyBottomOffset = bottomStartHemisphereOffset - dyBottomMultiplier * creasePositionY;
        float dySqTopAtCrease = Mth.m_14207_((float)(creasePositionY * dyTopMultiplier + dyTopOffset));
        float dySqBottomAtCrease = Mth.m_14207_((float)(creasePositionY * dyBottomMultiplier + dyBottomOffset));
        float topStartDistSqXZCorrection = (1.0f - dySqTopAtCrease) / (radXZ * radXZ);
        float bottomStartDistSqXZCorrection = (1.0f - dySqBottomAtCrease) / (radXZ * radXZ);
        float falloffCurveTopMultiplier = -1.0f / (1.0f - dySqTopAtCrease);
        float falloffCurveBottomMultiplier = -1.0f / (1.0f - dySqBottomAtCrease);
        float falloffCurveTopOffset = 1.0f - falloffCurveTopMultiplier * dySqTopAtCrease;
        float falloffCurveBottomOffset = 1.0f - falloffCurveBottomMultiplier * dySqBottomAtCrease;
        int radYBound = Mth.m_14167_((float)(height * 0.5f));
        int radXZBound = Mth.m_14167_((float)radXZ);
        for (int dy = -radYBound; dy <= radYBound; ++dy) {
            boolean isTop = (float)dy >= creasePositionY;
            float dySq = isTop ? Mth.m_14207_((float)((float)dy * dyTopMultiplier + dyTopOffset)) : Mth.m_14207_((float)((float)dy * dyBottomMultiplier + dyBottomOffset));
            for (int dz = -radXZBound; dz <= radXZBound; ++dz) {
                for (int dx = -radXZBound; dx <= radXZBound; ++dx) {
                    boolean isInRange;
                    float distSqXZ = (float)(dx * dx + dz * dz) * (isTop ? topStartDistSqXZCorrection : bottomStartDistSqXZCorrection);
                    float distSq = distSqXZ + dySq;
                    float baseDensityHere = isTop ? distSq * falloffCurveTopMultiplier + falloffCurveTopOffset : distSq * falloffCurveBottomMultiplier + falloffCurveBottomOffset;
                    boolean bl = isInRange = baseDensityHere >= 0.6f;
                    if (!isInRange) {
                        float noiseHere = OpenSimplex2S.noise3_ImproveXZ(noiseSeed, (double)(dx + origin.m_123341_()) * 0.1, (double)(dy + origin.m_123342_()) * 0.08333333333333334, (double)(dz + origin.m_123343_()) * 0.1) * 0.3f + 0.3f;
                        float densityHere = baseDensityHere - noiseHere;
                        boolean bl2 = isInRange = densityHere > 0.0f;
                    }
                    if (!isInRange) continue;
                    BlockPos local = origin.m_7918_(dx, dy, dz);
                    level.m_7731_(local, state, 3);
                }
            }
        }
        return false;
    }
}

