/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.util.DistributionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CactusPatchFeature
extends Feature<NoneFeatureConfiguration> {
    public static final int MAX_PLACEMENT_ATTEMPTS = 16;
    public static final float PLACEMENT_SKIP_CHANCE = 0.25f;
    public static final int MAX_TOTAL_PLACEMENTS = 4;
    public static final int PLACEMENT_RADIUS_XZ = 7;
    public static final int PLACEMENT_RADIUS_Y = 5;
    public static final int MAX_CACTUS_HEIGHT = 3;
    public static final float CACTUS_HEIGHT_GROWTH_CHANCE = 0.3f;

    public CactusPatchFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        int cactiRemaining = 4;
        for (int j = 0; j < 16; ++j) {
            BlockPos pos;
            if (cactiRemaining <= 0) {
                return true;
            }
            if (random.m_188501_() < 0.25f || !level.m_8055_((pos = DistributionUtils.ellipsoidCenterBiasedSpread(7.0f, 5.0f, random, (x, y, z) -> origin.m_7918_(Math.round(x), Math.round(y), Math.round(z)))).m_7495_()).m_60713_((Block)BlockModule.ANCIENT_SAND.get())) continue;
            boolean placedCactus = false;
            for (int i = 0; i < 3 && level.m_8055_(pos.m_6630_(i)).m_60795_() && level.m_8055_(pos.m_6630_(i).m_122012_()).m_60795_() && level.m_8055_(pos.m_6630_(i).m_122029_()).m_60795_() && level.m_8055_(pos.m_6630_(i).m_122024_()).m_60795_() && level.m_8055_(pos.m_6630_(i).m_122019_()).m_60795_(); ++i) {
                level.m_7731_(pos.m_6630_(i), Blocks.f_50128_.m_49966_(), 3);
                placedCactus = true;
                if (random.m_188501_() >= 0.3f) break;
            }
            if (!placedCactus) continue;
            --cactiRemaining;
        }
        return cactiRemaining < 4;
    }
}

