/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.feature;

import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.processor.BlockReplaceProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.DragonEggProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.ObsidianProcessor;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BetterEndPodiumFeature
extends Feature<NoneFeatureConfiguration> {
    private static final List<StructureProcessor> PROCESSORS = List.of(new BlockReplaceProcessor(Blocks.f_50497_.m_49966_(), new BlockStateRandomizer(Blocks.f_50752_.m_49966_()), false, false, false, false), new DragonEggProcessor());
    private static final StructureProcessor ACTIVE_PORTAL_PROCESSOR = new BlockReplaceProcessor(Blocks.f_50504_.m_49966_(), new BlockStateRandomizer(Blocks.f_50257_.m_49966_()), false, false, false, false);
    private static final StructureProcessor INACTIVE_PORTAL_PROCESSOR = new BlockReplaceProcessor(Blocks.f_50504_.m_49966_(), new BlockStateRandomizer(Blocks.f_50016_.m_49966_()), false, false, false, false);
    private final boolean isInitialSpawn;
    private final boolean isBottomOnly;
    private final boolean isActive;

    public BetterEndPodiumFeature(boolean isInitialSpawn, boolean isBottomOnly, boolean isActive) {
        super(NoneFeatureConfiguration.f_67815_);
        this.isInitialSpawn = isInitialSpawn;
        this.isBottomOnly = isBottomOnly;
        this.isActive = isActive;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        ServerLevel serverLevel;
        WorldGenLevel level = ctx.m_159774_();
        RandomSource randomSource = ctx.m_225041_();
        BlockPos pos = ctx.m_159777_();
        int numberTimesDragonKilled = 0;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_8586_() != null) {
            numberTimesDragonKilled = ((IDragonFight)serverLevel.m_8586_()).betterendisland$numTimesDragonKilled();
        }
        ResourceLocation template = this.chooseTemplate();
        boolean placed = this.placeTemplate((ServerLevelAccessor)level, randomSource, pos, Rotation.NONE, template, numberTimesDragonKilled);
        if (this.isInitialSpawn) {
            BlockPos centerPos = pos.m_6630_(6);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos crystalPos = centerPos.m_5484_(direction, 8);
                EndCrystal crystal = new EndCrystal((Level)level, (double)crystalPos.m_123341_() + 0.5, (double)crystalPos.m_123342_(), (double)crystalPos.m_123343_() + 0.5);
                crystal.m_31056_(false);
                crystal.m_20331_(true);
                level.m_7967_((Entity)crystal);
            }
        }
        return placed;
    }

    private ResourceLocation chooseTemplate() {
        if (this.isBottomOnly) {
            return new ResourceLocation("betterendisland", "tower_bottom_open");
        }
        String towerType = this.isInitialSpawn ? "initial" : "broken";
        String towerName = "tower_" + towerType;
        return new ResourceLocation("betterendisland", towerName);
    }

    private boolean placeTemplate(ServerLevelAccessor level, RandomSource randomSource, BlockPos centerPos, Rotation rotation, ResourceLocation id, int numberTimesDragonKilled) {
        Optional templateOptional = level.m_6018_().m_215082_().m_230407_(id);
        if (templateOptional.isEmpty()) {
            BetterEndIslandCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return false;
        }
        StructureTemplate template = (StructureTemplate)templateOptional.get();
        BlockPos cornerPos = centerPos.m_7918_(-template.m_163801_().m_123341_() / 2, 0, -template.m_163801_().m_123343_() / 2);
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings();
        PROCESSORS.forEach(arg_0 -> ((StructurePlaceSettings)structurePlaceSettings).m_74383_(arg_0));
        if (this.isActive) {
            structurePlaceSettings.m_74383_(ACTIVE_PORTAL_PROCESSOR);
        } else {
            structurePlaceSettings.m_74383_(INACTIVE_PORTAL_PROCESSOR);
        }
        structurePlaceSettings.m_74383_((StructureProcessor)new ObsidianProcessor(numberTimesDragonKilled));
        structurePlaceSettings.m_74379_(rotation);
        structurePlaceSettings.m_74385_(this.isBottomOnly ? new BlockPos(3, 0, 3) : new BlockPos(14, 0, 14));
        template.m_230328_(level, cornerPos, centerPos, structurePlaceSettings, randomSource, 2);
        return true;
    }
}

