/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import net.konwboy.tumbleweed.common.EntityTumbleweed;
import net.konwboy.tumbleweed.services.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class Spawner {
    private static final int TRY_SPAWN_TICKS = 200;
    private static final int MOB_COUNT_DIV = 289;
    private static final int SEARCH_RADIUS = 2;
    private static final int SPAWN_ATTEMPTS = 10;
    private static final TagKey<Biome> BIOME_WHITELIST = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("tumbleweed", "whitelist"));
    private static final TagKey<Block> SPAWNER_BLOCKS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("tumbleweed", "spawners"));

    public static void endWorldTick(EntityType<EntityTumbleweed> type, ServerLevel world) {
        if (world.m_46467_() % 200L == 7L) {
            world.m_46473_().m_6180_("spawn_tumbleweed");
            Spawner.trySpawn(type, world);
            world.m_46473_().m_7238_();
        }
        world.m_143280_(type, t -> true).forEach(EntityTumbleweed::tickDespawnNonEntityProcessing);
    }

    private static void trySpawn(EntityType<EntityTumbleweed> type, ServerLevel world) {
        if (!world.m_46469_().m_46207_(GameRules.f_46134_)) {
            return;
        }
        HashSet eligibleChunksForSpawning = Sets.newHashSet();
        for (Player entityplayer : world.m_6907_()) {
            if (entityplayer.m_5833_()) continue;
            int playerX = Mth.m_14107_((double)(entityplayer.m_20185_() / 16.0));
            int playerZ = Mth.m_14107_((double)(entityplayer.m_20189_() / 16.0));
            for (int x = 8; x >= -8; --x) {
                for (int z = 8; z >= -8; --z) {
                    Holder biome;
                    boolean corner = x == -8 || x == 8 || z == -8 || z == 8;
                    ChunkPos chunk = new ChunkPos(x + playerX, z + playerZ);
                    if (eligibleChunksForSpawning.contains(chunk) || corner || !world.m_6857_().m_61927_(chunk) || Spawner.isNonEntityProcessing(world, chunk.m_45615_()) || !(biome = world.m_204166_(new BlockPos(chunk.m_45604_() + 8, 0, chunk.m_45605_() + 8))).m_203656_(BIOME_WHITELIST)) continue;
                    eligibleChunksForSpawning.add(chunk);
                }
            }
        }
        ArrayList chunkList = Lists.newArrayList((Iterable)eligibleChunksForSpawning);
        Collections.shuffle(chunkList);
        BlockPos worldSpawn = new BlockPos(world.m_6106_().m_6789_(), world.m_6106_().m_6527_(), world.m_6106_().m_6526_());
        long current = world.m_143280_(type, e -> true).size();
        int max = Mth.m_14165_((double)((double)(Services.CONFIG.maxPerPlayer() * eligibleChunksForSpawning.size()) / 289.0));
        block3: for (ChunkPos chunk : chunkList) {
            if (current > (long)max) break;
            if (world.f_46441_.m_188500_() > Services.CONFIG.spawnChance()) continue;
            BlockPos start = Spawner.getRandomSurfacePosition((Level)world, chunk.f_45578_, chunk.f_45579_);
            BlockPos spawner = null;
            block4: for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos check = world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(start.m_123341_() + x, 0, start.m_123343_() + z));
                    BlockState state = world.m_8055_(check);
                    if (!state.m_222976_().m_203656_(SPAWNER_BLOCKS) || !world.m_46861_(check)) continue;
                    spawner = check;
                    continue block4;
                }
            }
            if (spawner == null) continue;
            int packSize = 1 + (world.f_46441_.m_188501_() < 0.2f ? 1 : 0);
            int packSpawned = 0;
            for (int i = 0; i < 10; ++i) {
                int z;
                int y;
                int x = spawner.m_123341_() + world.f_46441_.m_188503_(5) - world.f_46441_.m_188503_(5);
                if (Spawner.isNonEntityProcessing(world, new BlockPos(x, y = spawner.m_123342_() + world.f_46441_.m_188503_(2) - world.f_46441_.m_188503_(2), z = spawner.m_123343_() + world.f_46441_.m_188503_(5) - world.f_46441_.m_188503_(5))) || !world.m_8055_(new BlockPos(x, y - 1, z)).m_60815_() || world.m_45914_((double)x, (double)y, (double)z, 32.0)) continue;
                if (worldSpawn.m_123331_(new Vec3i(x, y, z)) < 576.0) continue;
                EntityTumbleweed entity = (EntityTumbleweed)type.m_20615_((Level)world);
                entity.setSize(world.f_46441_.m_188503_(5) - 2);
                entity.m_7678_((double)x + 0.5, (double)y + 0.5 + 0.5 * world.f_46441_.m_188500_(), (double)z + 0.5, 0.0f, 0.0f);
                if (entity.isNotColliding()) {
                    ++current;
                    ++packSpawned;
                    world.m_7967_((Entity)entity);
                }
                if (packSpawned == packSize) continue block3;
            }
        }
    }

    private static BlockPos getRandomSurfacePosition(Level world, int chunkX, int chunkZ) {
        LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
        int x = chunkX * 16 + world.f_46441_.m_188503_(14) + 2;
        int z = chunkZ * 16 + world.f_46441_.m_188503_(14) + 2;
        int y = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        return new BlockPos(x, y, z);
    }

    public static boolean isNonEntityProcessing(ServerLevel world, BlockPos pos) {
        return !world.m_143340_(pos);
    }
}

