/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.FramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntitySlave
extends BaseBlockEntity
implements IDrawerGroup,
IFramedBlockEntity {
    private static final int[] drawerSlots = new int[]{0};
    public final ControllerData controllerData = new ControllerData();
    public final MaterialData materialData = new MaterialData();
    static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemRepository>(){});
    static Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerGroup>(){});
    private final DrawerItemHandler itemHandler = new DrawerItemHandler(this);
    private final ItemRepositoryProxy itemRepository = new ItemRepositoryProxy();
    private final LazyOptional<IItemHandler> capabilityItemHandler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IItemRepository> capabilityItemRepository = LazyOptional.of(() -> this.itemRepository);
    private final LazyOptional<IDrawerGroup> capabilityGroup = LazyOptional.of(() -> this);

    public BlockEntitySlave(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.injectData(this.controllerData);
        this.injectPortableData(this.materialData);
    }

    public BlockEntitySlave(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.CONTROLLER_SLAVE.get(), pos, state);
    }

    @Override
    public boolean isGroupValid() {
        return !this.m_58901_();
    }

    public void bindController(BlockPos coord) {
        if (this.controllerData.bindCoord(coord)) {
            this.m_6596_();
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerData.getCoord();
    }

    public BlockEntityController getController() {
        return this.controllerData.getController(this);
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.m_58899_())) {
            return drawerSlots;
        }
        return controller.getAccessibleDrawerSlots();
    }

    @Override
    public int getDrawerCount() {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.m_58899_())) {
            return 0;
        }
        return controller.getDrawerCount();
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        BlockEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.m_58899_())) {
            return Drawers.DISABLED;
        }
        return controller.getDrawer(slot);
    }

    public void m_6596_() {
        BlockEntityController controller = this.getController();
        if (controller != null && controller.isValidSlave(this.m_58899_())) {
            controller.m_6596_();
        }
        super.m_6596_();
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            return this.capabilityItemHandler.cast();
        }
        if (capability == ITEM_REPOSITORY_CAPABILITY) {
            return this.capabilityItemRepository.cast();
        }
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return this.capabilityGroup.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.capabilityItemHandler.invalidate();
        this.capabilityItemRepository.invalidate();
        this.capabilityGroup.invalidate();
    }

    @Override
    public MaterialData material() {
        return this.materialData;
    }

    @NotNull
    public ModelData getModelData() {
        return FramedModelProperties.getModelData(this);
    }

    private class ItemRepositoryProxy
    implements IItemRepository {
        private ItemRepositoryProxy() {
        }

        @Override
        @NotNull
        public NonNullList<IItemRepository.ItemRecord> getAllItems() {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(BlockEntitySlave.this.m_58899_())) {
                return NonNullList.m_122779_();
            }
            return controller.getItemRepository().getAllItems();
        }

        @Override
        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(BlockEntitySlave.this.m_58899_())) {
                return stack;
            }
            return controller.getItemRepository().insertItem(stack, simulate, predicate);
        }

        @Override
        @NotNull
        public ItemStack extractItem(@NotNull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(BlockEntitySlave.this.m_58899_())) {
                return ItemStack.f_41583_;
            }
            return controller.getItemRepository().extractItem(stack, amount, simulate, predicate);
        }

        @Override
        public int getStoredItemCount(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(BlockEntitySlave.this.m_58899_())) {
                return 0;
            }
            return controller.getItemRepository().getStoredItemCount(stack, predicate);
        }

        @Override
        public int getRemainingItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(BlockEntitySlave.this.m_58899_())) {
                return 0;
            }
            return controller.getItemRepository().getRemainingItemCapacity(stack, predicate);
        }

        @Override
        public int getItemCapacity(@NotNull ItemStack stack, Predicate<ItemStack> predicate) {
            BlockEntityController controller = BlockEntitySlave.this.getController();
            if (controller == null || !controller.isValidSlave(BlockEntitySlave.this.m_58899_())) {
                return 0;
            }
            return controller.getItemRepository().getItemCapacity(stack, predicate);
        }
    }
}

