/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.hypherionmc.simplerpc.core.configuration.objects.ConfigVariables;
import me.hypherionmc.simplerpc.core.configuration.objects.CustomVariablesConfig;
import me.hypherionmc.simplerpc.core.configuration.objects.Dimension;
import me.hypherionmc.simplerpc.core.configuration.objects.RPCButton;
import me.hypherionmc.simplerpc.core.configuration.objects.ServerEntry;
import me.hypherionmc.simplerpc.core.util.MinecraftUtilHandler;
import org.apache.commons.lang3.text.WordUtils;

public class APIUtils {
    public static String CUR_DIR = System.getProperty("user.dir");

    public static String worldNameToReadable(String name) {
        if (name.split(":").length > 1) {
            name = name.split(":")[1];
        }
        name = name.replace("_", " ");
        return WordUtils.capitalizeFully((String)name);
    }

    public static Optional<Dimension> findDimension(List<Dimension> list, String dimensionName, String biome) {
        if (dimensionName.toLowerCase().contains("minecraft:")) {
            dimensionName = dimensionName.replace("minecraft:", "");
        }
        if (biome.toLowerCase().contains("minecraft:")) {
            biome = biome.replace("minecraft:", "");
        }
        dimensionName = dimensionName.toLowerCase();
        biome = biome.toLowerCase();
        String finalDimensionName = dimensionName;
        String finalBiomeName = "biome:" + biome;
        if (list.stream().anyMatch(c -> c.name.equalsIgnoreCase(finalDimensionName))) {
            return list.stream().filter(c -> c.name.equalsIgnoreCase(finalDimensionName)).findFirst();
        }
        if (list.stream().anyMatch(c -> c.name.equalsIgnoreCase(finalBiomeName))) {
            return list.stream().filter(c -> c.name.equalsIgnoreCase(finalBiomeName)).findFirst();
        }
        String joined = finalDimensionName + "|" + finalBiomeName.replace("biome:", "");
        return list.stream().filter(c -> c.name.equalsIgnoreCase(joined)).findFirst();
    }

    public static List<RPCButton> parseButtons(List<RPCButton> buttons, MinecraftUtilHandler utilHandler, CustomVariablesConfig config) {
        ArrayList<RPCButton> buttons1 = new ArrayList<RPCButton>();
        buttons.forEach(bt -> {
            bt.label = utilHandler.parseVarsInternal(bt.label, config);
            bt.url = utilHandler.parseVarsInternal(bt.url, config);
            buttons1.add((RPCButton)bt);
        });
        return buttons1;
    }

    public static String parseVariables(String input, CustomVariablesConfig variables) {
        if (variables.enabled) {
            for (ConfigVariables v : variables.variables) {
                input = input.replace("%" + v.name + "%", v.value);
            }
        }
        return input;
    }

    public static Optional<ServerEntry> findServer(List<ServerEntry> list, String ipAddress) {
        return list.stream().filter(c -> c.ip.equalsIgnoreCase(ipAddress)).findFirst();
    }

    public static String stringNN(String obj) {
        return obj == null ? "Unknown" : obj;
    }
}

