/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin;

import com.github.exopandora.shouldersurfing.ShoulderSurfingCommon;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingPlugin;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ServiceLoader;

public abstract class PluginLoader {
    private static final PluginLoader INSTANCE = ServiceLoader.load(PluginLoader.class).findFirst().orElseThrow();
    private static final String ENTRYPOINT_KEY = "entrypoint";
    protected static final String PLUGIN_JSON_PATH = "shouldersurfing_plugin.json";

    public abstract void loadPlugins();

    protected void loadPlugin(String modName, String modId, Path path) {
        ShoulderSurfingCommon.LOGGER.info("Registering plugin for {} ({})", (Object)modName, (Object)modId);
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject configuration = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (configuration.has(ENTRYPOINT_KEY)) {
                String entrypoint = configuration.get(ENTRYPOINT_KEY).getAsString();
                IShoulderSurfingPlugin plugin = (IShoulderSurfingPlugin)Class.forName(entrypoint).getConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.register(ShoulderSurfingRegistrar.getInstance());
            } else {
                ShoulderSurfingCommon.LOGGER.error("Plugin for {} ({}) does not contain an entrypoint", (Object)modName, (Object)modId);
            }
        }
        catch (Throwable e) {
            ShoulderSurfingCommon.LOGGER.error("Failed to load plugin for {} ({})", (Object)modName, (Object)modId, (Object)e);
        }
    }

    public static PluginLoader getInstance() {
        return INSTANCE;
    }
}

