/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.mixins;

import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class MixinCamera {
    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_90572_(float var1, float var2);

    @Inject(method={"setup"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setPosition(DDD)V", shift=At.Shift.AFTER, ordinal=0)})
    private void setupRotations(BlockGetter level, Entity cameraEntity, boolean detached, boolean isMirrored, float partialTick, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (!(Perspective.SHOULDER_SURFING != Perspective.current() || cameraEntity instanceof LivingEntity && (livingEntity = (LivingEntity)cameraEntity).m_5803_())) {
            ShoulderSurfingCamera camera = ShoulderSurfingImpl.getInstance().getCamera();
            Vec2f rotations = camera.calcRotations(cameraEntity, partialTick);
            this.m_90572_(rotations.y(), rotations.x());
        }
    }

    @Redirect(method={"setup"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;move(DDD)V", ordinal=0))
    private void setupPosition(Camera cameraIn, double x, double y, double z, BlockGetter level, Entity cameraEntity, boolean detached, boolean isMirrored, float partialTick) {
        LivingEntity livingEntity;
        if (!(Perspective.SHOULDER_SURFING != Perspective.current() || cameraEntity instanceof LivingEntity && (livingEntity = (LivingEntity)cameraEntity).m_5803_())) {
            ShoulderSurfingCamera camera = ShoulderSurfingImpl.getInstance().getCamera();
            Vec3 cameraOffset = camera.calcOffset(cameraIn, level, partialTick, cameraEntity);
            this.m_90568_(-cameraOffset.m_7094_(), cameraOffset.m_7098_(), cameraOffset.m_7096_());
        } else {
            this.m_90568_(x, y, z);
        }
    }
}

