/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.api.model;

import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.model.Couple;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.api.model.PickOrigin;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;

public final class OffsetPickContext
extends PickContext {
    private final PickOrigin blockPickOrigin;
    private final PickOrigin entityPickOrigin;

    public OffsetPickContext(Camera camera, ClipContext.Fluid fluidContext, Entity entity, PickOrigin blockPickOrigin, PickOrigin entityPickOrigin) {
        super(camera, fluidContext, entity);
        this.blockPickOrigin = blockPickOrigin;
        this.entityPickOrigin = entityPickOrigin;
    }

    @Override
    public ClipContext.Block blockContext() {
        IShoulderSurfing instance = ShoulderSurfing.getInstance();
        if (instance.isAiming() || instance.getCrosshairRenderer().isCrosshairDynamic(this.entity())) {
            return ClipContext.Block.COLLIDER;
        }
        return ClipContext.Block.OUTLINE;
    }

    @Override
    public Couple<Vec3> entityTrace(double interactionRange, float partialTick) {
        return OffsetPickContext.calcRay(this.camera(), this.entity(), interactionRange, partialTick, this.entityPickOrigin);
    }

    @Override
    public Couple<Vec3> blockTrace(double interactionRange, float partialTick) {
        return OffsetPickContext.calcRay(this.camera(), this.entity(), interactionRange, partialTick, this.blockPickOrigin);
    }

    private static Couple<Vec3> calcRay(Camera camera, Entity entity, double interactionRange, float partialTick, PickOrigin pickOrigin) {
        Vec3 eyePosition = entity.m_20299_(partialTick);
        Vec3 cameraPos = camera.m_90583_();
        Vec3 cameraOffset = cameraPos.m_82546_(eyePosition);
        Vec3 renderOffset = ShoulderSurfing.getInstance().getCamera().getRenderOffset();
        Vec3 rayTraceStartOffset = new Vec3(camera.m_252775_()).m_82490_(renderOffset.m_7096_()).m_82549_(new Vec3(camera.m_253028_()).m_82490_(renderOffset.m_7098_()));
        Vec3 viewVector = new Vec3(camera.m_253058_());
        double interactionRangeSq = Mth.m_144952_((double)interactionRange);
        if (rayTraceStartOffset.m_82556_() < interactionRangeSq) {
            interactionRange = Math.sqrt(interactionRangeSq - rayTraceStartOffset.m_82556_());
        }
        double distance = interactionRange + cameraOffset.m_82554_(rayTraceStartOffset);
        Vec3 startPos = pickOrigin.calc(cameraPos, eyePosition, rayTraceStartOffset);
        Vec3 endPos = cameraPos.m_82549_(viewVector.m_82490_(distance));
        return new Couple<Vec3>(startPos, endPos);
    }
}

