/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.inventory.BackpackMenu;
import org.violetmoon.quark.addons.oddities.module.BackpackModule;
import org.violetmoon.quark.base.handler.ProxiedItemStackHandler;
import org.violetmoon.zeta.item.IZetaItem;
import org.violetmoon.zeta.item.ext.IZetaItemExtensions;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class BackpackItem
extends DyeableArmorItem
implements IZetaItem,
IZetaItemExtensions,
MenuProvider {
    private static final String WORN_TEXTURE = "quark:textures/misc/backpack_worn.png";
    private static final String WORN_OVERLAY_TEXTURE = "quark:textures/misc/backpack_worn_overlay.png";
    private final ZetaModule module;

    public BackpackItem(ZetaModule module) {
        super((ArmorMaterial)ArmorMaterials.LEATHER, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41487_(1).m_41503_(0).m_41497_(Rarity.RARE));
        this.module = module;
        module.zeta.registry.registerItem((Item)this, "backpack");
        if (module.category.isAddon()) {
            module.zeta.requiredModTooltipHandler.map((Item)this, module.category.requiredMod);
        }
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.f_256869_, (ItemLike)this, (ItemLike)Items.f_42450_, (boolean)true);
    }

    public int getDefaultTooltipHideFlagsZeta(@NotNull ItemStack stack) {
        return stack.m_41793_() ? ItemStack.TooltipPart.ENCHANTMENTS.m_41809_() : 0;
    }

    public ZetaModule getModule() {
        return this.module;
    }

    public IZetaItem setCondition(BooleanSupplier condition) {
        return this;
    }

    public boolean doesConditionApply() {
        return true;
    }

    public static boolean doesBackpackHaveItems(ItemStack stack) {
        LazyOptional handlerOpt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        if (!handlerOpt.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)handlerOpt.orElse((Object)new ItemStackHandler());
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean canEquipZeta(ItemStack stack, EquipmentSlot equipmentSlot, Entity ent) {
        return equipmentSlot == EquipmentSlot.CHEST;
    }

    public boolean isBookEnchantableZeta(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTableZeta(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public int getEnchantmentValueZeta(ItemStack stack) {
        return 0;
    }

    public boolean m_41465_() {
        return false;
    }

    public <T extends LivingEntity> int damageItemZeta(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public void m_6883_(@NotNull ItemStack stack, Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean hasItems = !BackpackModule.superOpMode && BackpackItem.doesBackpackHaveItems(stack);
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        boolean isCursed = enchants.containsKey(Enchantments.f_44975_);
        boolean changedEnchants = false;
        if (hasItems) {
            if (BackpackModule.isEntityWearingBackpack(entityIn, stack)) {
                if (!isCursed) {
                    enchants.put(Enchantments.f_44975_, 1);
                    changedEnchants = true;
                }
                if (BackpackModule.itemsInBackpackTick) {
                    LazyOptional handlerOpt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                    IItemHandler handler = (IItemHandler)handlerOpt.orElse((Object)new ItemStackHandler());
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack inStack = handler.getStackInSlot(i);
                        if (inStack.m_41619_()) continue;
                        inStack.m_41720_().m_6883_(inStack, worldIn, entityIn, i, false);
                    }
                }
            } else {
                ItemStack copy = stack.m_41777_();
                stack.m_41764_(0);
                entityIn.m_5552_(copy, 0.0f);
            }
        } else if (isCursed) {
            enchants.remove(Enchantments.f_44975_);
            changedEnchants = true;
        }
        if (changedEnchants) {
            EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)stack);
        }
    }

    public boolean onEntityItemUpdateZeta(ItemStack stack, ItemEntity entityItem) {
        if (BackpackModule.superOpMode || entityItem.m_9236_().f_46443_) {
            return false;
        }
        if (!stack.m_41782_()) {
            return false;
        }
        LazyOptional handlerOpt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        if (!handlerOpt.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)handlerOpt.orElse((Object)new ItemStackHandler());
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            if (stackAt.m_41619_()) continue;
            ItemStack copy = stackAt.m_41777_();
            Containers.m_18992_((Level)entityItem.m_9236_(), (double)entityItem.m_20185_(), (double)entityItem.m_20186_(), (double)entityItem.m_20189_(), (ItemStack)copy);
        }
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        boolean isCursed = enchants.containsKey(Enchantments.f_44975_);
        if (isCursed) {
            enchants.remove(Enchantments.f_44975_);
            EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)stack);
        }
        stack.m_41749_("Inventory");
        return false;
    }

    @NotNull
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag oldCapNbt) {
        ProxiedItemStackHandler handler = new ProxiedItemStackHandler(stack, 27);
        if (oldCapNbt != null && oldCapNbt.m_128441_("Parent")) {
            CompoundTag itemData = oldCapNbt.m_128469_("Parent");
            ItemStackHandler stacks = new ItemStackHandler();
            stacks.deserializeNBT(itemData);
            for (int i = 0; i < stacks.getSlots(); ++i) {
                handler.setStackInSlot(i, stacks.getStackInSlot(i));
            }
            oldCapNbt.m_128473_("Parent");
        }
        return handler;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_40390_) {
        return ImmutableMultimap.of();
    }

    public String getArmorTextureZeta(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return type != null && type.equals("overlay") ? WORN_OVERLAY_TEXTURE : WORN_TEXTURE;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new BackpackMenu(id, player);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_5524_());
    }
}

