/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.event;

import com.google.common.base.Stopwatch;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.shaders.FogShape;
import fuzs.puzzleslib.api.client.event.v1.AddToastCallback;
import fuzs.puzzleslib.api.client.event.v1.ClientChunkEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientEntityLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientLevelTickEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientPlayerEvents;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.ContainerScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.CustomizeChatPanelCallback;
import fuzs.puzzleslib.api.client.event.v1.FogEvents;
import fuzs.puzzleslib.api.client.event.v1.GameRenderEvents;
import fuzs.puzzleslib.api.client.event.v1.GatherDebugTextEvents;
import fuzs.puzzleslib.api.client.event.v1.InputEvents;
import fuzs.puzzleslib.api.client.event.v1.InteractionInputEvents;
import fuzs.puzzleslib.api.client.event.v1.InventoryMobEffectsCallback;
import fuzs.puzzleslib.api.client.event.v1.ItemTooltipCallback;
import fuzs.puzzleslib.api.client.event.v1.ModelEvents;
import fuzs.puzzleslib.api.client.event.v1.MovementInputUpdateCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderBlockOverlayCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderGuiCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderGuiElementEvents;
import fuzs.puzzleslib.api.client.event.v1.RenderHandCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderHighlightCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.RenderLivingEvents;
import fuzs.puzzleslib.api.client.event.v1.RenderNameTagCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderPlayerEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenKeyboardEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.ScreenOpeningCallback;
import fuzs.puzzleslib.api.client.event.v1.ScreenTooltipEvents;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.core.ForgeEventInvokerRegistry;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.data.MutableBoolean;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.event.ForgeButtonList;
import fuzs.puzzleslib.impl.client.event.ForgeModelBakerImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ToastAddEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;

public final class ForgeClientEventInvokers {
    private static final Supplier<Set<ResourceLocation>> TOP_LEVEL_MODEL_LOCATIONS = Suppliers.memoize(ForgeClientEventInvokers::getTopLevelModelLocations);

    public static void registerLoadingHandlers() {
        ForgeEventInvokerRegistry.INSTANCE.register(ModelEvents.ModifyUnbakedModel.class, ModelEvent.ModifyBakingResult.class, (callback, evt) -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            Map models = evt.getModels();
            HashMap bakedCache = Maps.newHashMap();
            HashMultimap missingTextures = HashMultimap.create();
            BakedModel missingModel = (BakedModel)models.get(ModelBakery.f_119230_);
            Objects.requireNonNull(missingModel, "missing model is null");
            HashMap additionalModels = Maps.newHashMap();
            Function<ResourceLocation, UnbakedModel> modelGetter = resourceLocation -> {
                if (additionalModels.containsKey(resourceLocation)) {
                    return (UnbakedModel)additionalModels.get(resourceLocation);
                }
                return evt.getModelBakery().m_119341_(resourceLocation);
            };
            IdentityHashMap unbakedCache = Maps.newIdentityHashMap();
            for (ResourceLocation modelLocation : TOP_LEVEL_MODEL_LOCATIONS.get()) {
                try {
                    EventResultHolder<UnbakedModel> result = callback.onModifyUnbakedModel(modelLocation, () -> (UnbakedModel)modelGetter.apply(modelLocation), modelGetter, (resourceLocation, unbakedModel) -> {
                        if (resourceLocation instanceof ModelResourceLocation) {
                            throw new IllegalArgumentException("model resource location is not supported");
                        }
                        additionalModels.put(resourceLocation, unbakedModel);
                    });
                    if (!result.isInterrupt()) continue;
                    UnbakedModel unbakedModel2 = result.getInterrupt().get();
                    additionalModels.put(modelLocation, unbakedModel2);
                    BakedModel bakedModel = unbakedCache.computeIfAbsent(unbakedModel2, arg_0 -> ForgeClientEventInvokers.lambda$registerLoadingHandlers$3(modelLocation, bakedCache, modelGetter, (Multimap)missingTextures, missingModel, unbakedModel2, arg_0));
                    models.put(modelLocation, bakedModel);
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to modify unbaked model", (Throwable)exception);
                }
            }
            missingTextures.asMap().forEach((resourceLocation, materials) -> PuzzlesLib.LOGGER.warn("Missing textures in model {}:\n{}", resourceLocation, (Object)materials.stream().sorted(Material.f_244523_).map(material -> "    " + material.m_119193_() + ":" + material.m_119203_()).collect(Collectors.joining("\n"))));
            PuzzlesLib.LOGGER.info("Modifying unbaked models took {}ms", (Object)stopwatch.stop().elapsed().toMillis());
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ModelEvents.ModifyBakedModel.class, ModelEvent.ModifyBakingResult.class, (callback, evt) -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            Map models = evt.getModels();
            HashMap bakedCache = Maps.newHashMap();
            HashMultimap missingTextures = HashMultimap.create();
            BakedModel missingModel = (BakedModel)models.get(ModelBakery.f_119230_);
            Objects.requireNonNull(missingModel, "missing model is null");
            Function<ResourceLocation, ModelBaker> modelBaker = arg_0 -> ForgeClientEventInvokers.lambda$registerLoadingHandlers$7(bakedCache, evt, (Multimap)missingTextures, missingModel, arg_0);
            Function<ResourceLocation, BakedModel> modelGetter = resourceLocation -> {
                if (models.containsKey(resourceLocation)) {
                    return (BakedModel)models.get(resourceLocation);
                }
                return ((ModelBaker)modelBaker.apply((ResourceLocation)resourceLocation)).m_245240_(resourceLocation, (ModelState)BlockModelRotation.X0_Y0);
            };
            for (ResourceLocation modelLocation : TOP_LEVEL_MODEL_LOCATIONS.get()) {
                try {
                    EventResultHolder<BakedModel> result = callback.onModifyBakedModel(modelLocation, () -> (BakedModel)modelGetter.apply(modelLocation), () -> (ModelBaker)modelBaker.apply(modelLocation), modelGetter, models::putIfAbsent);
                    result.getInterrupt().ifPresent(bakedModel -> models.put(modelLocation, bakedModel));
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to modify baked model", (Throwable)exception);
                }
            }
            missingTextures.asMap().forEach((resourceLocation, materials) -> PuzzlesLib.LOGGER.warn("Missing textures in model {}:\n{}", resourceLocation, (Object)materials.stream().sorted(Material.f_244523_).map(material -> "    " + material.m_119193_() + ":" + material.m_119203_()).collect(Collectors.joining("\n"))));
            PuzzlesLib.LOGGER.info("Modifying baked models took {}ms", (Object)stopwatch.stop().elapsed().toMillis());
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ModelEvents.AdditionalBakedModel.class, ModelEvent.ModifyBakingResult.class, (callback, evt) -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            Map models = evt.getModels();
            HashMultimap missingTextures = HashMultimap.create();
            HashMap bakedCache = Maps.newHashMap();
            BakedModel missingModel = (BakedModel)models.get(ModelBakery.f_119230_);
            Objects.requireNonNull(missingModel, "missing model is null");
            try {
                callback.onAdditionalBakedModel(models::putIfAbsent, resourceLocation -> models.getOrDefault(resourceLocation, missingModel), () -> ForgeClientEventInvokers.lambda$registerLoadingHandlers$16(bakedCache, evt, (Multimap)missingTextures, missingModel));
            }
            catch (Exception exception) {
                PuzzlesLib.LOGGER.error("Failed to add additional baked models", (Throwable)exception);
            }
            missingTextures.asMap().forEach((resourceLocation, materials) -> PuzzlesLib.LOGGER.warn("Missing textures:\n{}", (Object)materials.stream().sorted(Material.f_244523_).map(material -> "    " + material.m_119193_() + ":" + material.m_119203_()).collect(Collectors.joining("\n"))));
            PuzzlesLib.LOGGER.info("Adding additional baked models took {}ms", (Object)stopwatch.stop().elapsed().toMillis());
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ModelEvents.AfterModelLoading.class, ModelEvent.BakingCompleted.class, (callback, evt) -> callback.onAfterModelLoading(() -> ((ModelEvent.BakingCompleted)evt).getModelManager()));
        ForgeEventInvokerRegistry.INSTANCE.register(ModelEvents.CompleteModelLoading.class, ModelEvent.BakingCompleted.class, (callback, evt) -> callback.onCompleteModelLoading(() -> ((ModelEvent.BakingCompleted)evt).getModelManager(), () -> ((ModelEvent.BakingCompleted)evt).getModelBakery()));
    }

    public static void register() {
        ForgeEventInvokerRegistry.INSTANCE.register(ClientTickEvents.Start.class, TickEvent.ClientTickEvent.class, (callback, evt) -> {
            if (evt.phase == TickEvent.Phase.START) {
                callback.onStartClientTick(Minecraft.m_91087_());
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientTickEvents.End.class, TickEvent.ClientTickEvent.class, (callback, evt) -> {
            if (evt.phase == TickEvent.Phase.END) {
                callback.onEndClientTick(Minecraft.m_91087_());
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderGuiCallback.class, RenderGuiEvent.Post.class, (callback, evt) -> callback.onRenderGui(Minecraft.m_91087_(), evt.getGuiGraphics(), evt.getPartialTick(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_()));
        ForgeEventInvokerRegistry.INSTANCE.register(ItemTooltipCallback.class, ItemTooltipEvent.class, (callback, evt) -> callback.onItemTooltip(evt.getItemStack(), evt.getEntity(), evt.getToolTip(), evt.getFlags()));
        ForgeEventInvokerRegistry.INSTANCE.register(RenderNameTagCallback.class, RenderNameTagEvent.class, (callback, evt) -> {
            DefaultedValue<Component> content = DefaultedValue.fromEvent(arg_0 -> ((RenderNameTagEvent)evt).setContent(arg_0), () -> ((RenderNameTagEvent)evt).getContent(), () -> ((RenderNameTagEvent)evt).getOriginalContent());
            EventResult result = callback.onRenderNameTag(evt.getEntity(), content, evt.getEntityRenderer(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight(), evt.getPartialTick());
            if (result.isInterrupt()) {
                evt.setResult(result.getAsBoolean() ? Event.Result.ALLOW : Event.Result.DENY);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ContainerScreenEvents.Background.class, ContainerScreenEvent.Render.Background.class, (callback, evt) -> callback.onDrawBackground(evt.getContainerScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY()));
        ForgeEventInvokerRegistry.INSTANCE.register(ContainerScreenEvents.Foreground.class, ContainerScreenEvent.Render.Foreground.class, (callback, evt) -> callback.onDrawForeground(evt.getContainerScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY()));
        ForgeEventInvokerRegistry.INSTANCE.register(InventoryMobEffectsCallback.class, ScreenEvent.RenderInventoryMobEffects.class, (callback, evt) -> {
            MutableBoolean fullSizeRendering = MutableBoolean.fromEvent(arg_0 -> ((ScreenEvent.RenderInventoryMobEffects)evt).setCompact(arg_0), () -> ((ScreenEvent.RenderInventoryMobEffects)evt).isCompact());
            MutableInt horizontalOffset = MutableInt.fromEvent(arg_0 -> ((ScreenEvent.RenderInventoryMobEffects)evt).setHorizontalOffset(arg_0), () -> ((ScreenEvent.RenderInventoryMobEffects)evt).getHorizontalOffset());
            EventResult result = callback.onInventoryMobEffects(evt.getScreen(), evt.getAvailableSpace(), fullSizeRendering, horizontalOffset);
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ScreenOpeningCallback.class, ScreenEvent.Opening.class, (callback, evt) -> {
            DefaultedValue<Screen> newScreen = DefaultedValue.fromEvent(arg_0 -> ((ScreenEvent.Opening)evt).setNewScreen(arg_0), () -> ((ScreenEvent.Opening)evt).getNewScreen(), () -> ((ScreenEvent.Opening)evt).getScreen());
            EventResult result = callback.onScreenOpening(evt.getCurrentScreen(), newScreen);
            if (result.isInterrupt() || newScreen.getAsOptional().filter(screen -> screen == evt.getCurrentScreen()).isPresent()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ComputeFovModifierCallback.class, ComputeFovModifierEvent.class, (callback, evt) -> {
            float fovEffectScale = ((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()).floatValue();
            if (fovEffectScale == 0.0f) {
                return;
            }
            Consumer<Float> consumer = value -> evt.setNewFovModifier(Mth.m_14179_((float)fovEffectScale, (float)1.0f, (float)value.floatValue()));
            Supplier<Float> supplier = () -> Float.valueOf((evt.getNewFovModifier() - 1.0f) / fovEffectScale + 1.0f);
            callback.onComputeFovModifier(evt.getPlayer(), DefaultedFloat.fromEvent(consumer, supplier, () -> ((ComputeFovModifierEvent)evt).getFovModifier()));
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ScreenEvents.BeforeInit.class, ScreenEvent.Init.Pre.class, (callback, evt) -> callback.onBeforeInit(Minecraft.m_91087_(), evt.getScreen(), evt.getScreen().f_96543_, evt.getScreen().f_96544_, new ForgeButtonList(evt.getScreen().f_169369_)));
        ForgeEventInvokerRegistry.INSTANCE.register(ScreenEvents.AfterInit.class, ScreenEvent.Init.Post.class, (callback, evt) -> callback.onAfterInit(Minecraft.m_91087_(), evt.getScreen(), evt.getScreen().f_96543_, evt.getScreen().f_96544_, new ForgeButtonList(evt.getScreen().f_169369_), arg_0 -> ((ScreenEvent.Init.Post)evt).addListener(arg_0), arg_0 -> ((ScreenEvent.Init.Post)evt).removeListener(arg_0)));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.BeforeInitV2.class, ScreenEvent.Init.Pre.class, (callback, evt) -> callback.onBeforeInit(Minecraft.m_91087_(), evt.getScreen(), evt.getScreen().f_96543_, evt.getScreen().f_96544_, new ForgeButtonList(evt.getScreen().f_169369_)));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.AfterInitV2.class, ScreenEvent.Init.Post.class, (callback, evt) -> {
            ScreenEvents.ConsumingOperator<GuiEventListener> addWidget = new ScreenEvents.ConsumingOperator<GuiEventListener>(arg_0 -> ((ScreenEvent.Init.Post)evt).addListener(arg_0));
            ScreenEvents.ConsumingOperator<GuiEventListener> removeWidget = new ScreenEvents.ConsumingOperator<GuiEventListener>(arg_0 -> ((ScreenEvent.Init.Post)evt).removeListener(arg_0));
            callback.onAfterInit(Minecraft.m_91087_(), evt.getScreen(), evt.getScreen().f_96543_, evt.getScreen().f_96544_, new ForgeButtonList(evt.getScreen().f_169369_), addWidget, removeWidget);
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.Remove.class, ScreenEvent.Closing.class, (callback, evt) -> callback.onRemove(evt.getScreen()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.BeforeRender.class, ScreenEvent.Render.Pre.class, (callback, evt) -> callback.onBeforeRender(evt.getScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenEvents.AfterRender.class, ScreenEvent.Render.Post.class, (callback, evt) -> callback.onAfterRender(evt.getScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseClick.class, ScreenEvent.MouseButtonPressed.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseClick(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseClick.class, ScreenEvent.MouseButtonPressed.Post.class, (callback, evt) -> callback.onAfterMouseClick(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseRelease.class, ScreenEvent.MouseButtonReleased.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseRelease(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseRelease.class, ScreenEvent.MouseButtonReleased.Post.class, (callback, evt) -> callback.onAfterMouseRelease(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseScroll.class, ScreenEvent.MouseScrolled.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseScroll(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getScrollDelta(), evt.getScrollDelta());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseScroll.class, ScreenEvent.MouseScrolled.Post.class, (callback, evt) -> callback.onAfterMouseScroll(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getScrollDelta(), evt.getScrollDelta()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.BeforeMouseDrag.class, ScreenEvent.MouseDragged.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseDrag(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getMouseButton(), evt.getDragX(), evt.getDragY());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenMouseEvents.AfterMouseDrag.class, ScreenEvent.MouseDragged.Post.class, (callback, evt) -> callback.onAfterMouseDrag(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getMouseButton(), evt.getDragX(), evt.getDragY()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyPress.class, ScreenEvent.KeyPressed.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeKeyPress(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyPress.class, ScreenEvent.KeyPressed.Post.class, (callback, evt) -> callback.onAfterKeyPress(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers()));
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.BeforeKeyRelease.class, ScreenEvent.KeyReleased.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeKeyRelease(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeClientEventInvokers.registerScreenEvent(ScreenKeyboardEvents.AfterKeyRelease.class, ScreenEvent.KeyReleased.Post.class, (callback, evt) -> callback.onAfterKeyRelease(evt.getScreen(), evt.getKeyCode(), evt.getScanCode(), evt.getModifiers()));
        ForgeEventInvokerRegistry.INSTANCE.register(RenderGuiElementEvents.Before.class, RenderGuiOverlayEvent.Pre.class, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            RenderGuiElementEvents.GuiOverlay overlay = (RenderGuiElementEvents.GuiOverlay)context;
            Minecraft minecraft = Minecraft.m_91087_();
            if (!evt.getOverlay().id().equals((Object)overlay.id()) || !overlay.filter().test(minecraft)) {
                return;
            }
            EventResult result = callback.onBeforeRenderGuiElement(minecraft, evt.getGuiGraphics(), evt.getPartialTick(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderGuiElementEvents.After.class, RenderGuiOverlayEvent.Post.class, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            RenderGuiElementEvents.GuiOverlay overlay = (RenderGuiElementEvents.GuiOverlay)context;
            Minecraft minecraft = Minecraft.m_91087_();
            if (!evt.getOverlay().id().equals((Object)overlay.id()) || !overlay.filter().test(minecraft)) {
                return;
            }
            callback.onAfterRenderGuiElement(minecraft, evt.getGuiGraphics(), evt.getPartialTick(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_());
        });
        ForgeEventInvokerRegistry.INSTANCE.register(CustomizeChatPanelCallback.class, CustomizeGuiOverlayEvent.Chat.class, (callback, evt) -> {
            MutableInt posX = MutableInt.fromEvent(arg_0 -> ((CustomizeGuiOverlayEvent.Chat)evt).setPosX(arg_0), () -> ((CustomizeGuiOverlayEvent.Chat)evt).getPosX());
            MutableInt posY = MutableInt.fromEvent(arg_0 -> ((CustomizeGuiOverlayEvent.Chat)evt).setPosY(arg_0), () -> ((CustomizeGuiOverlayEvent.Chat)evt).getPosY());
            callback.onRenderChatPanel(evt.getWindow(), evt.getGuiGraphics(), evt.getPartialTick(), posX, posY);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientEntityLevelEvents.Load.class, EntityJoinLevelEvent.class, (callback, evt) -> {
            if (!evt.getLevel().f_46443_) {
                return;
            }
            EventResult result = callback.onEntityLoad(evt.getEntity(), (ClientLevel)evt.getLevel());
            if (result.isInterrupt()) {
                if (evt.getEntity() instanceof Player) {
                    throw new UnsupportedOperationException("Cannot prevent player from spawning in!");
                }
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientEntityLevelEvents.Unload.class, EntityLeaveLevelEvent.class, (callback, evt) -> {
            if (!evt.getLevel().f_46443_) {
                return;
            }
            callback.onEntityUnload(evt.getEntity(), (ClientLevel)evt.getLevel());
        });
        ForgeEventInvokerRegistry.INSTANCE.register(InputEvents.BeforeMouseAction.class, InputEvent.MouseButton.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseAction(evt.getButton(), evt.getAction(), evt.getModifiers());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(InputEvents.AfterMouseAction.class, InputEvent.MouseButton.Post.class, (callback, evt) -> callback.onAfterMouseAction(evt.getButton(), evt.getAction(), evt.getModifiers()));
        ForgeEventInvokerRegistry.INSTANCE.register(InputEvents.BeforeMouseScroll.class, InputEvent.MouseScrollingEvent.class, (callback, evt) -> {
            EventResult result = callback.onBeforeMouseScroll(evt.isLeftDown(), evt.isMiddleDown(), evt.isRightDown(), evt.getScrollDelta(), evt.getScrollDelta());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(InputEvents.AfterMouseScroll.class, InputEvent.MouseScrollingEvent.class, (callback, evt) -> callback.onAfterMouseScroll(evt.isLeftDown(), evt.isMiddleDown(), evt.isRightDown(), evt.getScrollDelta(), evt.getScrollDelta()));
        ForgeEventInvokerRegistry.INSTANCE.register(InputEvents.BeforeKeyAction.class, InputEvent.Key.class, (callback, evt) -> callback.onBeforeKeyAction(evt.getKey(), evt.getScanCode(), evt.getAction(), evt.getModifiers()));
        ForgeEventInvokerRegistry.INSTANCE.register(InputEvents.AfterKeyAction.class, InputEvent.Key.class, (callback, evt) -> callback.onAfterKeyAction(evt.getKey(), evt.getScanCode(), evt.getAction(), evt.getModifiers()));
        ForgeEventInvokerRegistry.INSTANCE.register(ComputeCameraAnglesCallback.class, ViewportEvent.ComputeCameraAngles.class, (callback, evt) -> {
            MutableFloat pitch = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setPitch(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)evt).getPitch());
            MutableFloat yaw = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setYaw(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)evt).getYaw());
            MutableFloat roll = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeCameraAngles)evt).setRoll(arg_0), () -> ((ViewportEvent.ComputeCameraAngles)evt).getRoll());
            callback.onComputeCameraAngles(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTick(), pitch, yaw, roll);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderLivingEvents.Before.class, RenderLivingEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeRenderEntity(evt.getEntity(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderLivingEvents.After.class, RenderLivingEvent.Post.class, (callback, evt) -> callback.onAfterRenderEntity(evt.getEntity(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight()));
        ForgeEventInvokerRegistry.INSTANCE.register(RenderPlayerEvents.Before.class, RenderPlayerEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onBeforeRenderPlayer(evt.getEntity(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderPlayerEvents.After.class, RenderPlayerEvent.Post.class, (callback, evt) -> callback.onAfterRenderPlayer(evt.getEntity(), evt.getRenderer(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight()));
        ForgeEventInvokerRegistry.INSTANCE.register(RenderHandCallback.class, RenderHandEvent.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            EventResult result = callback.onRenderHand((Player)minecraft.f_91074_, evt.getHand(), evt.getItemStack(), evt.getPoseStack(), evt.getMultiBufferSource(), evt.getPackedLight(), evt.getPartialTick(), evt.getInterpolatedPitch(), evt.getSwingProgress(), evt.getEquipProgress());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientLevelTickEvents.Start.class, TickEvent.LevelTickEvent.class, (callback, evt) -> {
            Level patt30976$temp;
            if (evt.phase != TickEvent.Phase.START || !((patt30976$temp = evt.level) instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt30976$temp;
            callback.onStartLevelTick(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientLevelTickEvents.End.class, TickEvent.LevelTickEvent.class, (callback, evt) -> {
            Level patt31325$temp;
            if (evt.phase != TickEvent.Phase.END || !((patt31325$temp = evt.level) instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt31325$temp;
            callback.onEndLevelTick(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientChunkEvents.Load.class, ChunkEvent.Load.class, (callback, evt) -> {
            LevelAccessor patt31617$temp = evt.getLevel();
            if (!(patt31617$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt31617$temp;
            callback.onChunkLoad(level, (LevelChunk)evt.getChunk());
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientChunkEvents.Unload.class, ChunkEvent.Unload.class, (callback, evt) -> {
            LevelAccessor patt31918$temp = evt.getLevel();
            if (!(patt31918$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt31918$temp;
            callback.onChunkUnload(level, (LevelChunk)evt.getChunk());
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientPlayerEvents.LoggedIn.class, ClientPlayerNetworkEvent.LoggingIn.class, (callback, evt) -> callback.onLoggedIn(evt.getPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection()));
        ForgeEventInvokerRegistry.INSTANCE.register(ClientPlayerEvents.LoggedOut.class, ClientPlayerNetworkEvent.LoggingOut.class, (callback, evt) -> {
            if (evt.getPlayer() == null || evt.getMultiPlayerGameMode() == null) {
                return;
            }
            Objects.requireNonNull(evt.getConnection(), "connection is null");
            callback.onLoggedOut(evt.getPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection());
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientPlayerEvents.Copy.class, ClientPlayerNetworkEvent.Clone.class, (callback, evt) -> callback.onCopy(evt.getOldPlayer(), evt.getNewPlayer(), evt.getMultiPlayerGameMode(), evt.getConnection()));
        ForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.Attack.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, evt) -> {
            EventResult result;
            if (!evt.isAttack()) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91077_ != null && (result = callback.onAttackInteraction(minecraft, minecraft.f_91074_)).isInterrupt()) {
                evt.setSwingHand(false);
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.AttackV2.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, evt) -> {
            EventResult result;
            if (!evt.isAttack()) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91077_ != null && (result = callback.onAttackInteraction(minecraft, minecraft.f_91074_, minecraft.f_91077_)).isInterrupt()) {
                evt.setSwingHand(false);
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.Use.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, evt) -> {
            EventResult result;
            if (!evt.isUseItem()) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91077_ != null && minecraft.f_91074_.m_21120_(evt.getHand()).m_246617_(minecraft.f_91073_.m_246046_()) && (minecraft.f_91077_.m_6662_() != HitResult.Type.ENTITY || minecraft.f_91073_.m_6857_().m_61937_(((EntityHitResult)minecraft.f_91077_).m_82443_().m_20183_())) && (result = callback.onUseInteraction(minecraft, minecraft.f_91074_, evt.getHand(), minecraft.f_91077_)).isInterrupt()) {
                evt.setSwingHand(false);
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(InteractionInputEvents.Pick.class, InputEvent.InteractionKeyMappingTriggered.class, (callback, evt) -> {
            if (!evt.isPickBlock()) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            EventResult result = callback.onPickInteraction(minecraft, minecraft.f_91074_, minecraft.f_91077_);
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientLevelEvents.Load.class, LevelEvent.Load.class, (callback, evt) -> {
            LevelAccessor patt36764$temp = evt.getLevel();
            if (!(patt36764$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt36764$temp;
            callback.onLevelLoad(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ClientLevelEvents.Unload.class, LevelEvent.Unload.class, (callback, evt) -> {
            LevelAccessor patt37061$temp = evt.getLevel();
            if (!(patt37061$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt37061$temp;
            callback.onLevelUnload(Minecraft.m_91087_(), level);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(MovementInputUpdateCallback.class, MovementInputUpdateEvent.class, (callback, evt) -> callback.onMovementInputUpdate((LocalPlayer)evt.getEntity(), evt.getInput()));
        ForgeEventInvokerRegistry.INSTANCE.register(ModelEvents.ModifyBakingResult.class, ModelEvent.ModifyBakingResult.class, (callback, evt) -> callback.onModifyBakingResult(evt.getModels(), () -> ((ModelEvent.ModifyBakingResult)evt).getModelBakery()));
        ForgeEventInvokerRegistry.INSTANCE.register(ModelEvents.BakingCompleted.class, ModelEvent.BakingCompleted.class, (callback, evt) -> callback.onBakingCompleted(() -> ((ModelEvent.BakingCompleted)evt).getModelManager(), evt.getModels(), () -> ((ModelEvent.BakingCompleted)evt).getModelBakery()));
        ForgeEventInvokerRegistry.INSTANCE.register(RenderBlockOverlayCallback.class, RenderBlockScreenEffectEvent.class, (callback, evt) -> {
            EventResult result = callback.onRenderBlockOverlay((LocalPlayer)evt.getPlayer(), evt.getPoseStack(), evt.getBlockState());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(FogEvents.Render.class, ViewportEvent.RenderFog.class, (callback, evt) -> {
            MutableFloat nearPlaneDistance = MutableFloat.fromEvent(t -> {
                evt.setNearPlaneDistance(t.floatValue());
                evt.setCanceled(true);
            }, () -> ((ViewportEvent.RenderFog)evt).getNearPlaneDistance());
            MutableFloat farPlaneDistance = MutableFloat.fromEvent(t -> {
                evt.setFarPlaneDistance(t.floatValue());
                evt.setCanceled(true);
            }, () -> ((ViewportEvent.RenderFog)evt).getFarPlaneDistance());
            MutableValue<FogShape> fogShape = MutableValue.fromEvent(t -> {
                evt.setFogShape(t);
                evt.setCanceled(true);
            }, () -> ((ViewportEvent.RenderFog)evt).getFogShape());
            callback.onRenderFog(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTick(), evt.getMode(), evt.getType(), nearPlaneDistance, farPlaneDistance, fogShape);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(FogEvents.ComputeColor.class, ViewportEvent.ComputeFogColor.class, (callback, evt) -> {
            MutableFloat red = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFogColor)evt).setRed(arg_0), () -> ((ViewportEvent.ComputeFogColor)evt).getRed());
            MutableFloat green = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFogColor)evt).setGreen(arg_0), () -> ((ViewportEvent.ComputeFogColor)evt).getGreen());
            MutableFloat blue = MutableFloat.fromEvent(arg_0 -> ((ViewportEvent.ComputeFogColor)evt).setBlue(arg_0), () -> ((ViewportEvent.ComputeFogColor)evt).getBlue());
            callback.onComputeFogColor(evt.getRenderer(), evt.getCamera(), (float)evt.getPartialTick(), red, green, blue);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(ScreenTooltipEvents.Render.class, RenderTooltipEvent.Pre.class, (callback, evt) -> {
            EventResult result = callback.onRenderTooltip(evt.getGraphics(), evt.getX(), evt.getY(), evt.getScreenWidth(), evt.getScreenHeight(), evt.getFont(), evt.getComponents(), evt.getTooltipPositioner());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderHighlightCallback.class, RenderHighlightEvent.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (!(minecraft.m_91288_() instanceof Player) || minecraft.f_91066_.f_92062_) {
                return;
            }
            EventResult result = callback.onRenderHighlight(evt.getLevelRenderer(), evt.getCamera(), minecraft.f_91063_, evt.getTarget(), evt.getPartialTick(), evt.getPoseStack(), evt.getMultiBufferSource(), minecraft.f_91073_);
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderLevelEvents.AfterTerrain.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onRenderLevelAfterTerrain(evt.getLevelRenderer(), evt.getCamera(), minecraft.f_91063_, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.f_91073_);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderLevelEvents.AfterEntities.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onRenderLevelAfterEntities(evt.getLevelRenderer(), evt.getCamera(), minecraft.f_91063_, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.f_91073_);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderLevelEvents.AfterTranslucent.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onRenderLevelAfterTranslucent(evt.getLevelRenderer(), evt.getCamera(), minecraft.f_91063_, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.f_91073_);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(RenderLevelEvents.AfterLevel.class, RenderLevelStageEvent.class, (callback, evt) -> {
            if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onRenderLevelAfterLevel(evt.getLevelRenderer(), evt.getCamera(), minecraft.f_91063_, evt.getPartialTick(), evt.getPoseStack(), evt.getProjectionMatrix(), evt.getFrustum(), minecraft.f_91073_);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(GameRenderEvents.Before.class, TickEvent.RenderTickEvent.class, (callback, evt) -> {
            if (evt.phase != TickEvent.Phase.START) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onBeforeGameRender(minecraft, minecraft.f_91063_, evt.renderTickTime);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(GameRenderEvents.After.class, TickEvent.RenderTickEvent.class, (callback, evt) -> {
            if (evt.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            callback.onAfterGameRender(minecraft, minecraft.f_91063_, evt.renderTickTime);
        });
        ForgeEventInvokerRegistry.INSTANCE.register(AddToastCallback.class, ToastAddEvent.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            EventResult result = callback.onAddToast(minecraft.m_91300_(), evt.getToast());
            if (result.isInterrupt()) {
                evt.setCanceled(true);
            }
        });
        ForgeEventInvokerRegistry.INSTANCE.register(GatherDebugTextEvents.Left.class, CustomizeGuiOverlayEvent.DebugText.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (!minecraft.f_91066_.f_92063_) {
                return;
            }
            callback.onGatherLeftDebugText(evt.getLeft());
        });
        ForgeEventInvokerRegistry.INSTANCE.register(GatherDebugTextEvents.Right.class, CustomizeGuiOverlayEvent.DebugText.class, (callback, evt) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (!minecraft.f_91066_.f_92063_) {
                return;
            }
            callback.onGatherRightDebugText(evt.getRight());
        });
    }

    private static <T, E extends ScreenEvent> void registerScreenEvent(Class<T> clazz, Class<E> event, BiConsumer<T, E> converter) {
        ForgeEventInvokerRegistry.INSTANCE.register(clazz, event, (callback, evt, context) -> {
            Objects.requireNonNull(context, "context is null");
            if (!((Class)context).isInstance(evt.getScreen())) {
                return;
            }
            converter.accept(callback, evt);
        });
    }

    private static Set<ResourceLocation> getTopLevelModelLocations() {
        HashSet modelLocations = Sets.newHashSet((Object[])new ResourceLocation[]{ModelBakery.f_119230_});
        for (Block block : BuiltInRegistries.f_256975_) {
            block.m_49965_().m_61056_().forEach(blockState -> modelLocations.add(BlockModelShaper.m_110895_((BlockState)blockState)));
        }
        for (ResourceLocation resourcelocation : BuiltInRegistries.f_257033_.m_6566_()) {
            modelLocations.add(new ModelResourceLocation(resourcelocation, "inventory"));
        }
        modelLocations.add(ItemRenderer.f_244055_);
        modelLocations.add(ItemRenderer.f_243706_);
        return Collections.unmodifiableSet(modelLocations);
    }

    private static /* synthetic */ ModelBaker lambda$registerLoadingHandlers$16(Map bakedCache, ModelEvent.ModifyBakingResult evt, Multimap missingTextures, BakedModel missingModel) {
        return new ForgeModelBakerImpl((ResourceLocation)ModelBakery.f_119230_, bakedCache, arg_0 -> ((ModelBakery)evt.getModelBakery()).m_119341_(arg_0), (arg_0, arg_1) -> ((Multimap)missingTextures).put(arg_0, arg_1), missingModel);
    }

    private static /* synthetic */ ModelBaker lambda$registerLoadingHandlers$7(Map bakedCache, ModelEvent.ModifyBakingResult evt, Multimap missingTextures, BakedModel missingModel, ResourceLocation resourceLocation) {
        return new ForgeModelBakerImpl(resourceLocation, bakedCache, arg_0 -> ((ModelBakery)evt.getModelBakery()).m_119341_(arg_0), (arg_0, arg_1) -> ((Multimap)missingTextures).put(arg_0, arg_1), missingModel);
    }

    private static /* synthetic */ BakedModel lambda$registerLoadingHandlers$3(ResourceLocation modelLocation, Map bakedCache, Function modelGetter, Multimap missingTextures, BakedModel missingModel, UnbakedModel unbakedModel, UnbakedModel $) {
        ForgeModelBakerImpl modelBaker = new ForgeModelBakerImpl(modelLocation, bakedCache, modelGetter, (arg_0, arg_1) -> ((Multimap)missingTextures).put(arg_0, arg_1), missingModel);
        return modelBaker.bake(unbakedModel, modelLocation);
    }
}

