package trash;

import daripher.skilltree.SkillTreeMod;
import daripher.skilltree.skill.PassiveSkill;
import net.minecraft.resources.ResourceLocation;

public class SkillTreeConnector {
    public void connectSkillsBetweenTrees(SkillProvider tree1, SkillProvider tree2, String skillName1, String skillName2) {
        PassiveSkill skill1 = tree1.getSkills().get(getSkillId(skillName1));
        PassiveSkill skill2 = tree2.getSkills().get(getSkillId(skillName2));

        if (skill1 != null && skill2 != null) {
            skill1.connect(skill2);
        } else {
            System.err.println("One of the skills was not found: " + skillName1 + " or " + skillName2);
        }
    }

    private ResourceLocation getSkillId(String skillName) {
        return new ResourceLocation(SkillTreeMod.MOD_ID, skillName);
    }
}
