/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.network.packet;

import galena.oreganized.world.IDoorProgressHolder;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record DoorPushingPacket(UUID player, boolean pushing) {
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.player);
        buffer.writeBoolean(this.pushing);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Player player = level.m_46003_(this.player());
            if (player instanceof IDoorProgressHolder) {
                IDoorProgressHolder progressHolder = (IDoorProgressHolder)player;
                if (this.pushing) {
                    progressHolder.oreganised$incrementOpeningProgress();
                } else {
                    progressHolder.oreganised$resetOpeningProgress();
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static DoorPushingPacket from(FriendlyByteBuf buffer) {
        UUID player = buffer.m_130259_();
        boolean pushing = buffer.readBoolean();
        return new DoorPushingPacket(player, pushing);
    }
}

