/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.index;

import com.google.common.collect.ImmutableBiMap;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import galena.oreganized.Oreganized;
import galena.oreganized.content.block.BulbBlock;
import galena.oreganized.content.block.CrystalGlassBlock;
import galena.oreganized.content.block.CrystalGlassPaneBlock;
import galena.oreganized.content.block.GargoyleBlock;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.content.block.LeadBarsBlock;
import galena.oreganized.content.block.LeadDoorBlock;
import galena.oreganized.content.block.LeadTrapdoorBlock;
import galena.oreganized.content.block.MeltableBlock;
import galena.oreganized.content.block.MeltablePillarBlock;
import galena.oreganized.content.block.MoltenLeadBlock;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import galena.oreganized.content.block.ShrapnelBombBlock;
import galena.oreganized.content.block.SpottedGlanceBlock;
import galena.oreganized.index.OFluids;
import galena.oreganized.index.OItems;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="oreganized", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OBlocks {
    public static final BlockSubRegistryHelper HELPER = (BlockSubRegistryHelper)Oreganized.REGISTRY_HELPER.getBlockSubHelper();
    public static ImmutableBiMap<Block, Block> WAXED_BLOCKS;
    public static final RegistryObject<Block> GLANCE;
    public static final RegistryObject<Block> POLISHED_GLANCE;
    public static final RegistryObject<Block> GLANCE_BRICKS;
    public static final RegistryObject<Block> CHISELED_GLANCE;
    public static final RegistryObject<SlabBlock> GLANCE_SLAB;
    public static final RegistryObject<SlabBlock> POLISHED_GLANCE_SLAB;
    public static final RegistryObject<SlabBlock> GLANCE_BRICK_SLAB;
    public static final RegistryObject<StairBlock> GLANCE_STAIRS;
    public static final RegistryObject<StairBlock> POLISHED_GLANCE_STAIRS;
    public static final RegistryObject<StairBlock> GLANCE_BRICK_STAIRS;
    public static final RegistryObject<WallBlock> GLANCE_WALL;
    public static final RegistryObject<WallBlock> GLANCE_BRICK_WALL;
    public static final RegistryObject<Block> SPOTTED_GLANCE;
    public static final RegistryObject<Block> WAXED_SPOTTED_GLANCE;
    public static final RegistryObject<Block> SILVER_ORE;
    public static final RegistryObject<Block> DEEPSLATE_SILVER_ORE;
    public static final RegistryObject<Block> LEAD_ORE;
    public static final RegistryObject<Block> DEEPSLATE_LEAD_ORE;
    public static final RegistryObject<Block> RAW_SILVER_BLOCK;
    public static final RegistryObject<Block> RAW_LEAD_BLOCK;
    public static final RegistryObject<Block> SILVER_BLOCK;
    public static final RegistryObject<Block> GARGOYLE;
    public static final RegistryObject<Block> LEAD_BOLT_CRATE;
    public static final RegistryObject<MeltableBlock> LEAD_BLOCK;
    public static final RegistryObject<MeltableBlock> LEAD_BRICKS;
    public static final RegistryObject<MeltablePillarBlock> CUT_LEAD;
    public static final RegistryObject<MeltablePillarBlock> LEAD_PILLAR;
    public static final RegistryObject<MeltableBlock> LEAD_BULB;
    public static final BlockSetType LEAD_BLOCK_SET;
    public static final RegistryObject<LeadDoorBlock> LEAD_DOOR;
    public static final RegistryObject<LeadTrapdoorBlock> LEAD_TRAPDOOR;
    public static final RegistryObject<LeadBarsBlock> LEAD_BARS;
    public static final RegistryObject<Block> ELECTRUM_BLOCK;
    public static final RegistryObject<Block> SHRAPNEL_BOMB;
    public static final Map<DyeColor, RegistryObject<Block>> CRYSTAL_GLASS;
    public static final Map<DyeColor, RegistryObject<Block>> CRYSTAL_GLASS_PANES;
    public static final RegistryObject<Block> GROOVED_ICE;
    public static final RegistryObject<Block> GROOVED_PACKED_ICE;
    public static final RegistryObject<Block> GROOVED_BLUE_ICE;
    public static final Map<DyeColor, RegistryObject<Block>> WAXED_CONCRETE_POWDER;
    public static final RegistryObject<LiquidBlock> MOLTEN_LEAD;
    public static final RegistryObject<Block> MOLTEN_LEAD_CAULDRON;

    private static BlockBehaviour.Properties leadProperties() {
        return BlockBehaviour.Properties.m_284310_().m_60913_(5.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56743_).m_60953_(IMeltableBlock::getLightLevel).m_60977_();
    }

    private static BlockBehaviour.Properties leadDecoProperties() {
        return OBlocks.leadProperties().m_60955_().m_60922_(($1, $2, $3, $4) -> false);
    }

    public static <T extends Block> Map<DyeColor, RegistryObject<T>> registerColored(UnaryOperator<String> nameCreator, Function<DyeColor, ? extends T> factory) {
        return Arrays.stream(DyeColor.values()).collect(Collectors.toMap(it -> it, color -> OBlocks.register((String)nameCreator.apply(color.m_7912_()), () -> (Block)factory.apply((DyeColor)color))));
    }

    public static <T extends Block> Map<DyeColor, RegistryObject<T>> registerColored(String baseName, Function<DyeColor, ? extends T> factory) {
        return OBlocks.registerColored(color -> color + "_" + baseName, factory);
    }

    public static <T extends Block> RegistryObject<T> baseRegister(String name, Supplier<? extends T> block, Function<RegistryObject<T>, Supplier<? extends Item>> item) {
        RegistryObject register = HELPER.createBlockNoItem(name, block);
        OItems.HELPER.createItem(name, item.apply(register));
        return register;
    }

    public static <B extends Block> RegistryObject<B> register(String name, Supplier<? extends Block> block) {
        return OBlocks.baseRegister(name, block, OBlocks::registerBlockItem);
    }

    private static <T extends Block> Supplier<BlockItem> registerBlockItem(RegistryObject<T> block) {
        return () -> new BlockItem(Objects.requireNonNull((Block)block.get()), new Item.Properties());
    }

    static {
        GLANCE = OBlocks.register("glance", () -> new Block(BlockBehaviour.Properties.m_284310_().m_155956_(6.0f).m_60978_(1.5f)));
        POLISHED_GLANCE = OBlocks.register("polished_glance", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLANCE.get()))));
        GLANCE_BRICKS = OBlocks.register("glance_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)POLISHED_GLANCE.get()))));
        CHISELED_GLANCE = OBlocks.register("chiseled_glance", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLANCE.get()))));
        GLANCE_SLAB = OBlocks.register("glance_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLANCE.get()))));
        POLISHED_GLANCE_SLAB = OBlocks.register("polished_glance_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)POLISHED_GLANCE.get()))));
        GLANCE_BRICK_SLAB = OBlocks.register("glance_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLANCE_BRICKS.get()))));
        GLANCE_STAIRS = OBlocks.register("glance_stairs", () -> new StairBlock(() -> ((Block)((Block)GLANCE.get())).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLANCE.get()))));
        POLISHED_GLANCE_STAIRS = OBlocks.register("polished_glance_stairs", () -> new StairBlock(() -> ((Block)((Block)POLISHED_GLANCE.get())).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)POLISHED_GLANCE.get()))));
        GLANCE_BRICK_STAIRS = OBlocks.register("glance_brick_stairs", () -> new StairBlock(() -> ((Block)((Block)GLANCE_BRICKS.get())).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLANCE_BRICKS.get()))));
        GLANCE_WALL = OBlocks.register("glance_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLANCE.get()))));
        GLANCE_BRICK_WALL = OBlocks.register("glance_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLANCE_BRICKS.get()))));
        SPOTTED_GLANCE = OBlocks.register("spotted_glance", () -> new SpottedGlanceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)GLANCE.get()))));
        WAXED_SPOTTED_GLANCE = OBlocks.register("waxed_spotted_glance", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SPOTTED_GLANCE.get()))));
        SILVER_ORE = OBlocks.register("silver_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49995_)));
        DEEPSLATE_SILVER_ORE = OBlocks.register("deepslate_silver_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152467_)));
        LEAD_ORE = OBlocks.register("lead_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49995_).m_60913_(3.0f, 3.0f)));
        DEEPSLATE_LEAD_ORE = OBlocks.register("deepslate_lead_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152467_)));
        RAW_SILVER_BLOCK = OBlocks.register("raw_silver_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152598_)));
        RAW_LEAD_BLOCK = OBlocks.register("raw_lead_block", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152598_)));
        SILVER_BLOCK = OBlocks.register("silver_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        GARGOYLE = OBlocks.register("gargoyle", () -> new GargoyleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
        LEAD_BOLT_CRATE = OBlocks.register("lead_bolt_crate", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60978_(1.5f).m_60918_(SoundType.f_56736_)));
        LEAD_BLOCK = OBlocks.register("lead_block", () -> new MeltableBlock(OBlocks.leadProperties()));
        LEAD_BRICKS = OBlocks.register("lead_bricks", () -> new MeltableBlock(OBlocks.leadProperties()));
        CUT_LEAD = OBlocks.register("cut_lead", () -> new MeltablePillarBlock(OBlocks.leadProperties()));
        LEAD_PILLAR = OBlocks.register("lead_pillar", () -> new MeltablePillarBlock(OBlocks.leadProperties()));
        LEAD_BULB = OBlocks.register("lead_bulb", () -> new BulbBlock(OBlocks.leadProperties().m_60953_(BulbBlock::getLightLevel)));
        LEAD_BLOCK_SET = BlockSetType.m_272115_((BlockSetType)new BlockSetType("lead", true, SoundType.f_56743_, SoundEvents.f_12055_, SoundEvents.f_12056_, SoundEvents.f_12011_, SoundEvents.f_12012_, SoundEvents.f_12066_, SoundEvents.f_12067_, SoundEvents.f_12443_, SoundEvents.f_12444_));
        LEAD_DOOR = OBlocks.baseRegister("lead_door", () -> new LeadDoorBlock(OBlocks.leadDecoProperties()), block -> () -> new DoubleHighBlockItem((Block)block.get(), new Item.Properties()));
        LEAD_TRAPDOOR = OBlocks.register("lead_trapdoor", () -> new LeadTrapdoorBlock(OBlocks.leadDecoProperties()));
        LEAD_BARS = OBlocks.register("lead_bars", () -> new LeadBarsBlock(OBlocks.leadDecoProperties()));
        ELECTRUM_BLOCK = OBlocks.register("electrum_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(5.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56743_)));
        SHRAPNEL_BOMB = OBlocks.register("shrapnel_bomb", () -> new ShrapnelBombBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50077_)));
        CRYSTAL_GLASS = OBlocks.registerColored("crystal_glass", (DyeColor dye) -> new CrystalGlassBlock((DyeColor)dye, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50214_).m_284268_(dye)));
        CRYSTAL_GLASS_PANES = OBlocks.registerColored("crystal_glass_pane", (DyeColor dye) -> new CrystalGlassPaneBlock((DyeColor)dye, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50370_).m_284268_(dye)));
        GROOVED_ICE = OBlocks.register("grooved_ice", () -> new IceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50126_).m_60911_(0.6f)));
        GROOVED_PACKED_ICE = OBlocks.register("grooved_packed_ice", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50354_).m_60911_(0.6f)));
        GROOVED_BLUE_ICE = OBlocks.register("grooved_blue_ice", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50568_).m_60911_(0.6f)));
        WAXED_CONCRETE_POWDER = OBlocks.registerColored(color -> "waxed_" + color + "_concrete_powder", (DyeColor dye) -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50519_).m_284268_(dye)));
        MOLTEN_LEAD = HELPER.createBlock("molten_lead", () -> new MoltenLeadBlock((Supplier<? extends FlowingFluid>)OFluids.MOLTEN_LEAD, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49991_).m_284180_(MapColor.f_283889_)));
        MOLTEN_LEAD_CAULDRON = HELPER.createBlock("molten_lead_cauldron", () -> new MoltenLeadCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152477_).m_60977_()));
    }
}

