/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data.provider;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class OLangProvider
implements DataProvider {
    private final Map<String, String> data = new TreeMap<String, String>();
    private final PackOutput output;
    private final String modid;
    private final String locale;
    private final List<Runnable> subProviders = Lists.newArrayList();

    public OLangProvider(PackOutput output, String modid, String locale) {
        this.output = output;
        this.modid = modid;
        this.locale = locale;
    }

    public void addSubProvider(Runnable runnable) {
        this.subProviders.add(runnable);
    }

    protected abstract void addTranslations();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.subProviders.forEach(Runnable::run);
        this.addTranslations();
        if (!this.data.isEmpty()) {
            return this.save(cache, this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(this.modid).resolve("lang").resolve(this.locale + ".json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String m_6055_() {
        return this.modid + " Languages: " + this.locale;
    }

    private CompletableFuture<?> save(CachedOutput cache, Path target) {
        JsonObject json = new JsonObject();
        this.data.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Block key, String name) {
        this.add(key.m_7705_(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    public void addPotion(Supplier<? extends Potion> potion, String name) {
        this.add("item.minecraft.potion.effect." + ForgeRegistries.POTIONS.getKey((Object)potion.get()).m_135815_(), "Potion of " + name);
        this.add("item.minecraft.splash_potion.effect." + ForgeRegistries.POTIONS.getKey((Object)potion.get()).m_135815_(), "Splash Potion of " + name);
        this.add("item.minecraft.lingering_potion.effect." + ForgeRegistries.POTIONS.getKey((Object)potion.get()).m_135815_(), "Lingering Potion of " + name);
        this.add("item.minecraft.tipped_arrow.effect." + ForgeRegistries.POTIONS.getKey((Object)potion.get()).m_135815_(), "Arrow of " + name);
    }

    public void addDisc(Supplier<? extends RecordItem> disc, String desc) {
        this.addItem(disc, "Music Disc");
        this.add(disc.get().m_5524_() + ".desc", desc);
    }

    public void addDisc(Supplier<? extends RecordItem> disc, String artist, String song) {
        this.addDisc(disc, artist + " - " + song);
    }

    public void addAdvTitle(String advancementTitle, String name) {
        this.data.putIfAbsent("advancements." + advancementTitle + ".title", name);
    }

    public void addAdvDesc(String advancementTitle, String name) {
        this.data.putIfAbsent("advancements." + advancementTitle + ".description", name);
    }

    public void addSubtitle(String category, String subtitleName, String name) {
        this.add("subtitles." + category + "." + subtitleName, name);
    }

    public void addDeath(String deathName, String name) {
        this.add("death.attack." + deathName, name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    public void add(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    public void add(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    public void tryBlock(Supplier<? extends Block> block) {
        String key = block.get().m_7705_();
        String value = this.formatString(ForgeRegistries.BLOCKS.getKey((Object)block.get()).m_135815_());
        this.data.putIfAbsent(key, value);
    }

    public void tryItem(Supplier<? extends Item> item) {
        String key = item.get().m_5524_();
        String value = this.formatString(ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_());
        this.data.putIfAbsent(key, value);
    }

    public void tryFluid(Supplier<? extends Fluid> fluid) {
        String key = Util.m_137492_((String)"fluid", (ResourceLocation)ForgeRegistries.FLUIDS.getKey((Object)fluid.get()));
        String value = this.formatString(ForgeRegistries.FLUIDS.getKey((Object)fluid.get()).m_135815_());
        this.data.putIfAbsent(key, value);
    }

    public void tryEntity(Supplier<? extends EntityType<?>> entity) {
        String key = entity.get().m_20675_();
        String value = this.formatString(ForgeRegistries.ENTITY_TYPES.getKey(entity.get()).m_135815_());
        this.data.putIfAbsent(key, value);
    }

    private String formatString(String key) {
        String[] strArr = key.split("_");
        StringBuffer res = new StringBuffer();
        for (String str : strArr) {
            char[] stringArray = str.trim().toCharArray();
            stringArray[0] = Character.toUpperCase(stringArray[0]);
            str = new String(stringArray);
            res.append(str).append(" ");
        }
        return res.toString().trim();
    }
}

