/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.message;

import com.github.L_Ender.cataclysm.capabilities.Gone_With_SandstormCapability;
import com.github.L_Ender.cataclysm.init.ModCapabilities;
import com.github.L_Ender.cataclysm.util.SandstormUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageToggleSandstorm {
    private final boolean toggle;

    public MessageToggleSandstorm(boolean toggle) {
        this.toggle = toggle;
    }

    public MessageToggleSandstorm(FriendlyByteBuf buf) {
        this.toggle = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.toggle);
    }

    public static class Handler {
        public static void handle(MessageToggleSandstorm message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null) {
                    SandstormUtils.toggleFlight((LivingEntity)player, message.toggle);
                    Gone_With_SandstormCapability.IGone_With_SandstormCapability SandstormCapability = ModCapabilities.getCapability((Entity)player, ModCapabilities.GONE_WITH_SANDSTORM_CAPABILITY);
                    if (SandstormCapability != null) {
                        SandstormCapability.setSandstorm(message.toggle);
                    }
                }
            });
        }
    }
}

