/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.block.PowderyCaneBlock;
import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.WitherRoseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class ResurgentSoilBlock
extends Block {
    public ResurgentSoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.f_46443_) {
            BlockPos abovePos = pos.m_7494_();
            BlockState aboveState = level.m_8055_(abovePos);
            Block aboveBlock = aboveState.m_60734_();
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = level.m_8055_(belowPos);
            Block belowBlock = belowState.m_60734_();
            if (aboveBlock == Blocks.f_50700_) {
                level.m_46597_(pos.m_7494_(), ((Block)MNDBlocks.CRIMSON_FUNGUS_COLONY.get()).m_49966_());
                return;
            }
            if (aboveBlock == Blocks.f_50691_) {
                level.m_46597_(pos.m_7494_(), ((Block)MNDBlocks.WARPED_FUNGUS_COLONY.get()).m_49966_());
                return;
            }
            if (aboveBlock == Blocks.f_50072_) {
                level.m_46597_(pos.m_7494_(), ((Block)ModBlocks.BROWN_MUSHROOM_COLONY.get()).m_49966_());
                return;
            }
            if (aboveBlock == Blocks.f_50073_) {
                level.m_46597_(pos.m_7494_(), ((Block)ModBlocks.RED_MUSHROOM_COLONY.get()).m_49966_());
                return;
            }
            if ((Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() == 0.0) {
                return;
            }
            if (aboveBlock == MNDBlocks.POWDERY_TORCH.get() && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / 15.0 && level.m_46859_(pos.m_6630_(2))) {
                level.m_46597_(pos.m_7494_(), (BlockState)((Block)MNDBlocks.POWDERY_CANE.get()).m_49966_().m_61124_((Property)PowderyCaneBlock.BASE, (Comparable)Boolean.valueOf(true)));
                level.m_46597_(pos.m_6630_(2), (BlockState)((BlockState)((Block)MNDBlocks.BULLET_PEPPER.get()).m_49966_().m_61124_((Property)PowderyCaneBlock.LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PowderyCaneBlock.AGE, (Comparable)Integer.valueOf(2)));
                return;
            }
            if (!aboveState.m_204336_(MNDTags.NOT_PROPAGATE_PLANT)) {
                if (aboveState.m_204336_(MNDTags.ABOVE_PROPAGATE_PLANT) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.6f) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
                if (aboveBlock instanceof FlowerBlock && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.8f) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
                if ((aboveBlock instanceof FungusBlock || aboveBlock instanceof MushroomBlock) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.4f) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
                if (aboveBlock instanceof MushroomColonyBlock) {
                    int age = (Integer)aboveState.m_61143_((Property)MushroomColonyBlock.COLONY_AGE);
                    if (age == 3 && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.4f) {
                        this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    }
                    return;
                }
                if (aboveBlock instanceof NetherWartBlock) {
                    int age = (Integer)aboveState.m_61143_((Property)NetherWartBlock.f_54967_);
                    if (age < 3) {
                        return;
                    }
                    if (age == 3 && level.f_46441_.m_188503_(8) == 0) {
                        this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    }
                    return;
                }
                if (aboveBlock instanceof PinkPetalsBlock) {
                    int age = (Integer)aboveState.m_61143_((Property)PinkPetalsBlock.f_271373_);
                    if (age != 4) {
                        this.performBonemealIfPossible(aboveBlock, pos.m_7494_(), aboveState, level, 1);
                    } else if (level.f_46441_.m_188503_(6) == 0) {
                        this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    }
                    return;
                }
                if (aboveBlock instanceof DoublePlantBlock && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / 2.0) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
                if (aboveBlock instanceof BushBlock && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / 3.0) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    return;
                }
            }
            if (!belowState.m_204336_(MNDTags.NOT_PROPAGATE_PLANT) && belowState.m_204336_(MNDTags.BELOW_PROPAGATE_PLANT) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.8f) {
                this.propagateBelowIfPossible(belowBlock, belowPos, level);
                return;
            }
            if (!(belowBlock instanceof CaveVinesBlock) && !(belowBlock instanceof CaveVinesPlantBlock) && (belowBlock instanceof GrowingPlantHeadBlock || belowBlock instanceof GrowingPlantBodyBlock) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.2f) {
                this.performBonemealIfPossible(belowBlock, pos.m_7495_(), belowState, level, 1);
            }
            if ((aboveBlock instanceof GrowingPlantHeadBlock || aboveBlock instanceof GrowingPlantBodyBlock) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.2f) {
                this.performBonemealIfPossible(aboveBlock, pos.m_7494_(), aboveState, level, 1);
            }
            if (aboveState.m_204336_(ModTags.UNAFFECTED_BY_RICH_SOIL) || aboveBlock instanceof TallFlowerBlock) {
                return;
            }
            this.performBonemealIfPossible(aboveBlock, pos.m_7494_(), aboveState, level, 1);
            this.performBonemealIfPossible(belowBlock, pos.m_7495_(), belowState, level, 1);
            ResurgentSoilBlock.growIfPossible(aboveState, abovePos, level, Blocks.f_50130_, 7);
            ResurgentSoilBlock.growIfPossible(aboveState, abovePos, level, Blocks.f_50128_, 7);
        }
    }

    private void performBonemealIfPossible(Block block, BlockPos position, BlockState state, ServerLevel level, int distance) {
        if (block instanceof BonemealableBlock) {
            BonemealableBlock growable = (BonemealableBlock)block;
            if ((double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / (double)distance) {
                if (growable.m_7370_((LevelReader)level, position, state, false) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)position, (BlockState)state, (boolean)true)) {
                    growable.m_214148_(level, level.f_46441_, position, state);
                    level.m_46796_(2005, position, 0);
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)position, (BlockState)state);
                } else {
                    BlockPos checkPos = position.m_7494_();
                    BlockState checkState = level.m_8055_(checkPos);
                    Block checkBlock = checkState.m_60734_();
                    while (checkBlock == block && distance <= 10) {
                        this.performBonemealIfPossible(checkBlock, checkPos, checkState, level, distance + 1);
                        ++distance;
                        checkPos = checkPos.m_7494_();
                        checkState = level.m_8055_(checkPos);
                        checkBlock = checkState.m_60734_();
                    }
                    checkPos = position.m_7495_();
                    checkState = level.m_8055_(checkPos);
                    checkBlock = checkState.m_60734_();
                    while (checkBlock == block && distance <= 10) {
                        this.performBonemealIfPossible(checkBlock, checkPos, checkState, level, distance + 1);
                        ++distance;
                        checkPos = checkPos.m_7495_();
                        checkState = level.m_8055_(checkPos);
                        checkBlock = checkState.m_60734_();
                    }
                }
            }
        }
    }

    public static void growIfPossible(BlockState aboveBlock, BlockPos abovePos, ServerLevel level, Block targetBlock, int maxHeight) {
        if (aboveBlock.m_60734_() == targetBlock && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.6f) {
            BlockPos topPos = abovePos;
            int height = 1;
            while (level.m_8055_(topPos.m_7494_()).m_60734_() == targetBlock) {
                topPos = topPos.m_7494_();
                ++height;
            }
            if (level.m_8055_(topPos.m_7494_()).m_60795_() && height < maxHeight) {
                level.m_46597_(topPos.m_7494_(), targetBlock.m_49966_());
            }
        }
    }

    private void propagateAboveIfPossible(Block block, BlockPos position, ServerLevel level) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos newPos = position.m_7918_(x, y, z);
                    BlockState newState = level.m_8055_(newPos);
                    if (!this.canAboveBlockSurvive(block, newState, level, newPos)) continue;
                    validPositions.add(newPos);
                }
            }
        }
        if (!validPositions.isEmpty()) {
            boolean canPropagate;
            BlockPos plantPos = (BlockPos)validPositions.get(level.f_46441_.m_188503_(validPositions.size()));
            BlockState targetState = level.m_8055_(plantPos);
            boolean bl = canPropagate = block instanceof LiquidBlockContainer && targetState.m_60734_() == Blocks.f_49990_ || !(block instanceof LiquidBlockContainer) && targetState.m_60734_() == Blocks.f_50016_ || block instanceof WitherRoseBlock && (targetState.m_60734_() instanceof FlowerBlock || targetState.m_60734_() instanceof FungusBlock || targetState.m_60734_() instanceof MushroomBlock) || block instanceof SimpleWaterloggedBlock && (targetState.m_60734_() == Blocks.f_50016_ || targetState.m_60734_() == Blocks.f_49990_);
            if (canPropagate) {
                this.placeBlock(block, level, plantPos);
            }
        }
    }

    private boolean canAboveBlockSurvive(Block block, BlockState newState, ServerLevel level, BlockPos newPos) {
        BlockState blockBelowState = level.m_8055_(newPos.m_7495_());
        if (block instanceof WitherRoseBlock && (newState.m_60734_() instanceof FlowerBlock || newState.m_60734_() instanceof FungusBlock || newState.m_60734_() instanceof MushroomBlock) && !(newState.m_60734_() instanceof WitherRoseBlock)) {
            return true;
        }
        if (block instanceof DoublePlantBlock && level.m_8055_(newPos.m_7494_()).m_60734_() == Blocks.f_50016_) {
            return ((DoublePlantBlock)block).m_7898_(block.m_49966_(), (LevelReader)level, newPos);
        }
        if (block instanceof NetherWartBlock) {
            return blockBelowState.m_60734_() == Blocks.f_50135_ || blockBelowState.m_60734_() == MNDBlocks.RESURGENT_SOIL.get() || blockBelowState.m_60734_() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
        }
        if (!(block instanceof WitherRoseBlock) && !(block instanceof DoublePlantBlock)) {
            return blockBelowState.m_60734_() == ModBlocks.RICH_SOIL.get() || blockBelowState.m_60734_() == MNDBlocks.RESURGENT_SOIL.get();
        }
        return false;
    }

    private void propagateBelowIfPossible(Block block, BlockPos position, ServerLevel level) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos newPos = position.m_7918_(x, y, z);
                    if (!this.canBelowBlockSurvive(level, newPos)) continue;
                    validPositions.add(newPos);
                }
            }
        }
        if (!validPositions.isEmpty()) {
            boolean canPropagate;
            BlockPos plantPos = (BlockPos)validPositions.get(level.f_46441_.m_188503_(validPositions.size()));
            BlockState targetState = level.m_8055_(plantPos);
            boolean bl = canPropagate = block instanceof LiquidBlockContainer && targetState.m_60734_() == Blocks.f_49990_ || !(block instanceof LiquidBlockContainer) && targetState.m_60734_() == Blocks.f_50016_ || block instanceof SimpleWaterloggedBlock && (targetState.m_60734_() == Blocks.f_50016_ || targetState.m_60734_() == Blocks.f_49990_);
            if (canPropagate) {
                this.placeBlock(block, level, plantPos);
            }
        }
    }

    private boolean canBelowBlockSurvive(ServerLevel level, BlockPos newPos) {
        BlockState blockAboveState = level.m_8055_(newPos.m_7494_());
        return blockAboveState.m_60734_() == ModBlocks.RICH_SOIL.get() || blockAboveState.m_60734_() == MNDBlocks.RESURGENT_SOIL.get() || blockAboveState.m_60734_() == ModBlocks.RICH_SOIL_FARMLAND.get() || blockAboveState.m_60734_() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
    }

    private void placeBlock(Block block, ServerLevel level, BlockPos pos) {
        BlockState state = block.m_49966_();
        if (block instanceof SimpleWaterloggedBlock) {
            FluidState fluidState = level.m_6425_(pos);
            state = fluidState.m_76152_() == Fluids.f_76193_ ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        if (block instanceof PinkPetalsBlock) {
            Random random = new Random();
            Direction[] allowedDirections = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
            Direction randomDirection = allowedDirections[random.nextInt(allowedDirections.length)];
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)PinkPetalsBlock.f_271347_, (Comparable)randomDirection));
        } else if (block instanceof DoublePlantBlock) {
            DoublePlantBlock cfr_ignored_0 = (DoublePlantBlock)block;
            DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)state, (BlockPos)pos, (int)3);
        } else {
            level.m_46597_(pos, state);
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        return toolAction.equals(ToolActions.HOE_TILL) && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_() ? ((Block)MNDBlocks.RESURGENT_SOIL_FARMLAND.get()).m_49966_() : null;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        return plantType != PlantType.CROP;
    }
}

