/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.util.IcarusHelper;
import dev.muon.medievalorigins.power.IcarusWingsPower;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={IcarusHelper.class}, remap=false)
public class IcarusHelperMixin {
    @ModifyReturnValue(method={"getConfigValues"}, at={@At(value="RETURN")})
    private static IcarusPlayerValues modifyConfigValues(final IcarusPlayerValues original, LivingEntity entity) {
        if (IcarusWingsPower.hasPower((Entity)entity)) {
            return new IcarusPlayerValues(){

                public float wingsSpeed() {
                    return original.wingsSpeed();
                }

                public float maxSlowedMultiplier() {
                    return original.maxSlowedMultiplier();
                }

                public boolean armorSlows() {
                    return original.armorSlows();
                }

                public boolean canLoopDeLoop() {
                    return original.canLoopDeLoop();
                }

                public boolean canSlowFall() {
                    return original.canSlowFall();
                }

                public float exhaustionAmount() {
                    return original.exhaustionAmount() / 4.0f;
                }

                public int maxHeightAboveWorld() {
                    return original.maxHeightAboveWorld();
                }

                public boolean maxHeightEnabled() {
                    return original.maxHeightEnabled();
                }

                public float requiredFoodAmount() {
                    return 0.0f;
                }
            };
        }
        return original;
    }

    @WrapOperation(method={"hasWings"}, at={@At(value="INVOKE", target="Ljava/util/function/Predicate;test(Ljava/lang/Object;)Z")})
    private static boolean hasWingsFromOrigin(Predicate<LivingEntity> instance, Object entity, Operation<Boolean> original) {
        if (IcarusWingsPower.hasPower((Entity)((LivingEntity)entity))) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, entity});
    }

    @WrapOperation(method={"getEquippedWings"}, at={@At(value="INVOKE", target="Ljava/util/function/Function;apply(Ljava/lang/Object;)Ljava/lang/Object;")})
    private static Object getOriginWings(Function<LivingEntity, ItemStack> instance, Object entity, Operation<ItemStack> original) {
        if (IcarusWingsPower.hasPower((Entity)((LivingEntity)entity))) {
            return null;
        }
        return original.call(new Object[]{instance, entity});
    }
}

