/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import com.mojang.datafixers.util.Either;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionOnDurabilityChangePower
extends Power {
    @Nullable
    private final EquipmentSlot slot;
    @Nullable
    private final Predicate<Tuple<Level, ItemStack>> itemCondition;
    @Nullable
    private final Consumer<Entity> increaseAction;
    @Nullable
    private final Consumer<Tuple<Level, Mutable<ItemStack>>> itemIncreaseAction;
    @Nullable
    private final Consumer<Entity> decreaseAction;
    @Nullable
    private final Consumer<Tuple<Level, Mutable<ItemStack>>> itemDecreaseAction;
    @Nullable
    private final Consumer<Entity> breakAction;
    @Nullable
    private final Consumer<Tuple<Level, Mutable<ItemStack>>> itemBreakAction;
    Set<Either<EquipmentSlot, Integer>> operatedStacks = new HashSet<Either<EquipmentSlot, Integer>>();

    public ActionOnDurabilityChangePower(PowerType<?> type, LivingEntity entity, @Nullable EquipmentSlot slot, @Nullable Predicate<Tuple<Level, ItemStack>> itemCondition, @Nullable Consumer<Entity> increaseAction, @Nullable Consumer<Tuple<Level, Mutable<ItemStack>>> itemIncreaseAction, @Nullable Consumer<Entity> decreaseAction, @Nullable Consumer<Tuple<Level, Mutable<ItemStack>>> itemDecreaseAction, @Nullable Consumer<Entity> breakAction, @Nullable Consumer<Tuple<Level, Mutable<ItemStack>>> itemBreakAction) {
        super(type, entity);
        this.slot = slot;
        this.itemCondition = itemCondition;
        this.increaseAction = increaseAction;
        this.itemIncreaseAction = itemIncreaseAction;
        this.decreaseAction = decreaseAction;
        this.itemDecreaseAction = itemDecreaseAction;
        this.breakAction = breakAction;
        this.itemBreakAction = itemBreakAction;
        this.setTicking();
    }

    public void tick() {
        this.operatedStacks.clear();
    }

    public void onRemoved() {
        this.operatedStacks.clear();
    }

    public boolean doesApply(ItemStack stack) {
        return !(this.slot != null && !ItemStack.m_41728_((ItemStack)this.entity.m_6844_(this.slot), (ItemStack)stack) || this.itemCondition != null && !this.itemCondition.test((Tuple<Level, ItemStack>)new Tuple((Object)this.entity.m_9236_(), (Object)stack)));
    }

    private void executeAction(ItemStack stack, Consumer<Entity> entityAction, Consumer<Tuple<Level, Mutable<ItemStack>>> itemAction) {
        EquipmentSlot slot2;
        Optional<Object> equipmentSlot = Optional.empty();
        for (EquipmentSlot slot2 : EquipmentSlot.values()) {
            if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)this.entity.m_6844_(slot2))) continue;
            equipmentSlot = Optional.of(slot2);
            break;
        }
        Optional finalEquipmentSlot = equipmentSlot;
        Optional<Object> playerInventoryIndex = Optional.empty();
        if (equipmentSlot.isEmpty() && (slot2 = this.entity) instanceof Player) {
            Player player = (Player)slot2;
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)((ItemStack)player.m_150109_().f_35974_.get(i)))) continue;
                playerInventoryIndex = Optional.of(i);
                break;
            }
        }
        Optional<Integer> finalPlayerInventoryIndex = playerInventoryIndex;
        if (equipmentSlot.isEmpty() && playerInventoryIndex.isEmpty() || finalEquipmentSlot.isPresent() && this.operatedStacks.stream().anyMatch(either -> either.left().isPresent() && ((EquipmentSlot)either.left().get()).equals(finalEquipmentSlot.get())) || this.entity instanceof Player && finalPlayerInventoryIndex.isPresent() && this.operatedStacks.stream().anyMatch(either -> either.right().isPresent() && ((Integer)either.right().get()).intValue() == ((Integer)finalPlayerInventoryIndex.get()).intValue())) {
            return;
        }
        equipmentSlot.ifPresent(slot1 -> this.operatedStacks.add((Either<EquipmentSlot, Integer>)Either.left((Object)slot1)));
        playerInventoryIndex.ifPresent(index -> this.operatedStacks.add((Either<EquipmentSlot, Integer>)Either.right((Object)index)));
        if (entityAction != null) {
            entityAction.accept((Entity)this.entity);
        }
        if (itemAction != null) {
            MutableObject mutable = new MutableObject((Object)stack.m_41777_());
            itemAction.accept((Tuple<Level, Mutable<ItemStack>>)new Tuple((Object)this.entity.m_9236_(), (Object)mutable));
            if (equipmentSlot.isPresent()) {
                this.entity.m_8061_((EquipmentSlot)equipmentSlot.get(), (ItemStack)mutable.getValue());
            } else {
                LivingEntity livingEntity = this.entity;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_150109_().f_35974_.set(((Integer)playerInventoryIndex.get()).intValue(), (Object)((ItemStack)mutable.getValue()));
                }
            }
        }
    }

    public void executeIncreaseAction(ItemStack stack) {
        this.executeAction(stack, this.increaseAction, this.itemIncreaseAction);
    }

    public void executeDecreaseAction(ItemStack stack) {
        this.executeAction(stack, this.decreaseAction, this.itemDecreaseAction);
    }

    public void executeBreakAction(ItemStack stack) {
        this.executeAction(stack, this.breakAction, this.itemBreakAction);
    }

    public static class Factory
    extends SimplePowerFactory<ActionOnDurabilityChangePower> {
        public Factory() {
            super("action_on_durability_change", new SerializableData().add("slot", SerializableDataTypes.EQUIPMENT_SLOT, null).add("item_condition", Services.CONDITION.itemDataType(), null).add("increase_action", Services.ACTION.entityDataType(), null).add("increase_item_action", Services.ACTION.itemDataType(), null).add("decrease_action", Services.ACTION.entityDataType(), null).add("decrease_item_action", Services.ACTION.itemDataType(), null).add("break_action", Services.ACTION.entityDataType(), null).add("break_item_action", Services.ACTION.itemDataType(), null), data -> (type, entity) -> new ActionOnDurabilityChangePower((PowerType<?>)type, (LivingEntity)entity, (EquipmentSlot)data.get("slot"), Services.CONDITION.itemPredicate((SerializableData.Instance)data, "item_condition"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "increase_action"), Services.ACTION.itemConsumer((SerializableData.Instance)data, "increase_item_action"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "decrease_action"), Services.ACTION.itemConsumer((SerializableData.Instance)data, "decrease_item_action"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "break_action"), Services.ACTION.itemConsumer((SerializableData.Instance)data, "break_item_action")));
            this.allowCondition();
        }

        @Override
        @NotNull
        public Class<ActionOnDurabilityChangePower> getPowerClass() {
            return ActionOnDurabilityChangePower.class;
        }
    }
}

