/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class ActionOnBonemealPower
extends Power {
    @Nullable
    private final Consumer<Triple<Level, BlockPos, Direction>> blockAction;
    @Nullable
    private final Consumer<Entity> entityAction;
    @Nullable
    private final Predicate<BlockInWorld> blockCondition;

    public ActionOnBonemealPower(PowerType<?> type, LivingEntity entity, @Nullable Consumer<Triple<Level, BlockPos, Direction>> blockAction, @Nullable Consumer<Entity> entityAction, @Nullable Predicate<BlockInWorld> blockCondition) {
        super(type, entity);
        this.blockAction = blockAction;
        this.entityAction = entityAction;
        this.blockCondition = blockCondition;
    }

    public boolean doesApply(BlockInWorld cachedBlockPosition) {
        return this.blockCondition == null || this.blockCondition.test(cachedBlockPosition);
    }

    public void executeActions(Level world, BlockPos blockPos, Direction direction) {
        if (this.blockAction != null) {
            this.blockAction.accept((Triple<Level, BlockPos, Direction>)Triple.of((Object)world, (Object)blockPos, (Object)direction));
        }
        if (this.entityAction != null) {
            this.entityAction.accept((Entity)this.entity);
        }
    }

    public static class Factory
    extends SimplePowerFactory<ActionOnBonemealPower> {
        public Factory() {
            super("action_on_bonemeal", new SerializableData().add("block_action", Services.ACTION.blockDataType(), null).add("self_action", Services.ACTION.entityDataType(), null).add("block_condition", Services.CONDITION.biomeDataType(), null), data -> (type, entity) -> new ActionOnBonemealPower((PowerType<?>)type, (LivingEntity)entity, Services.ACTION.blockConsumer((SerializableData.Instance)data, "block_action"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "self_action"), Services.CONDITION.blockPredicate((SerializableData.Instance)data, "block_condition")));
            this.allowCondition();
        }

        @Override
        public Class<ActionOnBonemealPower> getPowerClass() {
            return ActionOnBonemealPower.class;
        }
    }
}

