/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class ActionOnBlockPlacedPower
extends Power {
    @Nullable
    private final Consumer<Triple<Level, BlockPos, Direction>> blockAction;
    public final Predicate<Tuple<Level, ItemStack>> itemCondition;

    public ActionOnBlockPlacedPower(PowerType<?> type, LivingEntity entity, @Nullable Consumer<Triple<Level, BlockPos, Direction>> blockAction, Predicate<Tuple<Level, ItemStack>> itemCondition) {
        super(type, entity);
        this.itemCondition = itemCondition;
        this.blockAction = blockAction;
    }

    public void executeAction(@Nullable BlockPos pos) {
        if (pos == null || this.blockAction == null) {
            return;
        }
        this.blockAction.accept((Triple<Level, BlockPos, Direction>)Triple.of((Object)this.entity.m_9236_(), (Object)pos, (Object)Direction.UP));
    }

    public static class Factory
    extends SimplePowerFactory<ActionOnBlockPlacedPower> {
        public Factory() {
            super("action_on_block_placed", new SerializableData().add("block_action", Services.ACTION.blockDataType(), null).add("item_condition", Services.CONDITION.itemDataType()), data -> (type, entity) -> new ActionOnBlockPlacedPower((PowerType<?>)type, (LivingEntity)entity, Services.ACTION.blockConsumer((SerializableData.Instance)data, "block_action"), Services.CONDITION.itemPredicate((SerializableData.Instance)data, "item_condition")));
            this.allowCondition();
        }

        @Override
        public Class<ActionOnBlockPlacedPower> getPowerClass() {
            return ActionOnBlockPlacedPower.class;
        }
    }
}

