/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform.services;

import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.apoli.util.ResourceOperation;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.merchantpug.apugli.network.c2s.ApugliPacketC2S;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ValueModifyingPowerFactory;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public double getReachDistance(Entity var1);

    public double getAttackRange(Entity var1);

    public <K> SerializableDataType<K> getKeyDataType();

    public <M> SerializableDataType<M> getModifierDataType();

    public <M> SerializableDataType<List<M>> getModifiersDataType();

    public double applyModifiers(Entity var1, List<?> var2, double var3);

    default public <P> double applyModifiers(LivingEntity entity, ValueModifyingPowerFactory<P> power, double value, Predicate<P> predicate) {
        List modifierList = Services.POWER.getPowers(entity, power).stream().filter(p -> predicate == null || predicate.test(p)).map(p -> power.getModifiers(p, (Entity)entity)).flatMap(Collection::stream).toList();
        return this.applyModifiers((Entity)entity, modifierList, value);
    }

    default public <P> double applyModifiers(LivingEntity entity, ValueModifyingPowerFactory<P> power, double value) {
        return this.applyModifiers(entity, power, value, null);
    }

    public void sendS2C(ApugliPacketS2C var1, ServerPlayer var2);

    public void sendS2CTrackingAndSelf(ApugliPacketS2C var1, Entity var2);

    public void sendC2S(ApugliPacketC2S var1);

    public int compareModifiers(Object var1, Object var2);

    public float[] getColorPowerRgba(LivingEntity var1);

    public void updateKeys(SerializableData.Instance var1, Player var2);

    public boolean isCurrentlyUsingKey(SerializableData.Instance var1, Player var2);

    public Tuple<Integer, Integer> getHitsOnTarget(Entity var1, LivingEntity var2);

    public void setHitsOnTarget(Entity var1, Entity var2, int var3, int var4, ResourceOperation var5, ResourceOperation var6);

    public HudRender getDefaultHudRender();

    public float getEntityEyeHeight(Entity var1);

    public SerializableDataType<?> damageSourceDescriptionDataType();

    public DamageSource createDamageSource(DamageSources var1, SerializableData.Instance var2, String var3, String var4);

    public DamageSource createDamageSource(DamageSources var1, SerializableData.Instance var2, Entity var3, String var4, String var5);

    public DamageSource createDamageSource(DamageSources var1, SerializableData.Instance var2, Entity var3, Entity var4, String var5, String var6);

    default public boolean canSetPose(Player player) {
        return true;
    }

    default public void setForcedPlayerPose(Player player, @Nullable Pose pose) {
    }
}

