/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.c2s;

import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.network.c2s.ApugliPacketC2S;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public record ExecuteBiEntityActionServerPacket<A>(int otherEntityId, boolean isOtherEntityTarget, A biEntityAction) implements ApugliPacketC2S
{
    public static final ResourceLocation ID = Apugli.asResource("execute_bientity_action_serverside");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.otherEntityId);
        buf.writeBoolean(this.isOtherEntityTarget);
        Services.ACTION.biEntityDataType().send(buf, this.biEntityAction);
    }

    public static <A> ExecuteBiEntityActionServerPacket<A> decode(FriendlyByteBuf buf) {
        int otherEntityId = buf.readInt();
        boolean isOtherEntityTarget = buf.readBoolean();
        Object entityAction = Services.ACTION.entityDataType().receive(buf);
        return new ExecuteBiEntityActionServerPacket<Object>(otherEntityId, isOtherEntityTarget, entityAction);
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void handle(MinecraftServer server, ServerPlayer player) {
        server.execute(() -> {
            Entity otherEntity = player.m_9236_().m_6815_(this.otherEntityId);
            ServerPlayer actor = this.isOtherEntityTarget ? player : otherEntity;
            Entity target = this.isOtherEntityTarget ? otherEntity : player;
            Services.ACTION.executeBiEntity(this.biEntityAction, (Entity)actor, target);
        });
    }
}

