/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.mixin.xplatform.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.List;
import java.util.Optional;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.CustomSoundPower;
import net.merchantpug.apugli.power.EdibleItemPower;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected abstract void m_8097_();

    @Shadow
    public abstract boolean m_6084_();

    @Shadow
    public abstract void m_6075_();

    @Shadow
    protected abstract boolean m_6046_();

    public LivingEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Redirect(method={"handleEntityEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V", ordinal=1))
    private void apugli$playHurtSoundsStatus(LivingEntity instance, SoundEvent soundEvent, float v, float p) {
        List powers = Services.POWER.getPowers(instance, ApugliPowers.CUSTOM_HURT_SOUND.get());
        if (!powers.isEmpty()) {
            if (powers.stream().anyMatch(CustomSoundPower::isMuted)) {
                return;
            }
            powers.forEach(power -> power.playSound((Entity)instance));
            return;
        }
        instance.m_5496_(soundEvent, v, p);
    }

    @Redirect(method={"handleEntityEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V", ordinal=2))
    private void apugli$playDeathSoundsStatus(LivingEntity instance, SoundEvent soundEvent, float v, float p) {
        List powers = Services.POWER.getPowers(instance, ApugliPowers.CUSTOM_DEATH_SOUND.get());
        if (!powers.isEmpty()) {
            if (powers.stream().anyMatch(CustomSoundPower::isMuted)) {
                return;
            }
            powers.forEach(power -> power.playSound((Entity)instance));
            return;
        }
        instance.m_5496_(soundEvent, v, p);
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V"))
    private void apugli$playDeathSounds(LivingEntity instance, SoundEvent soundEvent, float v, float p) {
        List powers = Services.POWER.getPowers(instance, ApugliPowers.CUSTOM_DEATH_SOUND.get());
        if (!powers.isEmpty()) {
            if (powers.stream().anyMatch(CustomSoundPower::isMuted)) {
                return;
            }
            powers.forEach(power -> power.playSound((Entity)instance));
            return;
        }
        instance.m_5496_(soundEvent, v, p);
    }

    @Inject(method={"playHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$playHurtSounds(DamageSource source, CallbackInfo ci) {
        List powers = Services.POWER.getPowers((LivingEntity)this, ApugliPowers.CUSTOM_HURT_SOUND.get());
        if (powers.isEmpty()) {
            return;
        }
        if (powers.stream().anyMatch(CustomSoundPower::isMuted)) {
            ci.cancel();
        }
        powers.forEach(power -> power.playSound(this));
        ci.cancel();
    }

    @Inject(method={"canSpawnSoulSpeedParticle"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$modifyShouldDisplaySoulSpeedEffects(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity thisAsLiving = (LivingEntity)this;
        if (Services.POWER.hasPower(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get())) {
            int soulSpeedValue = (int)Services.PLATFORM.applyModifiers(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get(), (double)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44976_, (LivingEntity)((LivingEntity)this)));
            boolean doesApply = Services.POWER.getPowers(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get()).stream().filter(power -> ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power).isPresent("block_condition")).toList().size() == 0 ? this.m_6046_() : Services.POWER.getPowers(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get()).stream().filter(power -> ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power).isPresent("block_condition")).anyMatch(power -> Services.CONDITION.checkBlock(ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power), "block_condition", this.m_9236_(), this.m_20099_()));
            cir.setReturnValue((Object)(this.f_19797_ % 5 == 0 && this.m_20184_().f_82479_ != 0.0 && this.m_20184_().f_82481_ != 0.0 && !this.m_5833_() && soulSpeedValue > 0 && doesApply ? 1 : 0));
        }
    }

    @Inject(method={"onSoulSpeedBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$modifyIsOnSoulSpeedBlock(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity thisAsLiving = (LivingEntity)this;
        if (Services.POWER.getPowers(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get()).stream().filter(power -> ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power).isPresent("block_condition")).toList().size() > 0) {
            if (Services.POWER.getPowers(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get()).stream().anyMatch(power -> ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power).isPresent("block_condition") && Services.CONDITION.checkBlock(ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power), "block_condition", this.m_9236_(), this.m_20099_()))) {
                cir.setReturnValue((Object)true);
            } else if (Services.POWER.getPowers(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get()).stream().noneMatch(power -> ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power).isPresent("block_condition") && Services.CONDITION.checkBlock(ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power), "block_condition", this.m_9236_(), this.m_20099_()))) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @ModifyVariable(method={"tryAddSoulSpeed"}, at=@At(value="STORE"), ordinal=0)
    private int apugli$replaceLevelOfSoulSpeed(int i) {
        int baseValue;
        int n = baseValue = this.m_9236_().m_8055_(this.m_20099_()).m_204336_(BlockTags.f_13080_) ? i : 0;
        if (!this.m_9236_().m_8055_(this.m_20099_()).m_204336_(BlockTags.f_13080_) || i < baseValue) {
            i = (int)Services.PLATFORM.applyModifiers((LivingEntity)this, ApugliPowers.MODIFY_SOUL_SPEED.get(), (double)baseValue);
            return i;
        }
        return i;
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$modifyVelocityMultiplier(CallbackInfoReturnable<Float> cir) {
        LivingEntity thisAsLiving = (LivingEntity)this;
        if (Services.POWER.hasPower(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get())) {
            int soulSpeedValue = (int)Services.PLATFORM.applyModifiers(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get(), (double)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44976_, (LivingEntity)thisAsLiving));
            if (soulSpeedValue <= 0 || Services.POWER.getPowers(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get()).stream().filter(power -> ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power).isPresent("block_condition")).toList().size() == 0 && !this.m_6046_() || Services.POWER.getPowers(thisAsLiving, ApugliPowers.MODIFY_SOUL_SPEED.get()).stream().anyMatch(power -> ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power).isPresent("block_condition") && Services.CONDITION.checkBlock(ApugliPowers.MODIFY_SOUL_SPEED.get().getDataFromPower(power), "block_condition", this.m_9236_(), this.m_20099_()))) {
                cir.setReturnValue((Object)Float.valueOf(super.m_6041_()));
            } else {
                cir.setReturnValue((Object)Float.valueOf(1.0f));
            }
        }
    }

    @Inject(method={"tryAddSoulSpeed"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void apugli$addModifiedSoulSpeed(CallbackInfo ci, int i) {
        int baseValue = (int)Services.PLATFORM.applyModifiers((LivingEntity)this, ApugliPowers.MODIFY_SOUL_SPEED.get(), 0.0);
        if (Services.POWER.hasPower((LivingEntity)this, ApugliPowers.MODIFY_SOUL_SPEED.get()) && i == baseValue) {
            ci.cancel();
        }
    }

    @Inject(method={"isInvertedHealAndHarm"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$invertInstantEffects(CallbackInfoReturnable<Boolean> cir) {
        if (Services.POWER.hasPower((LivingEntity)this, ApugliPowers.INVERT_INSTANT_EFFECTS.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;canFreeze()Z", ordinal=1)})
    private boolean apugli$stopFreezeDamage(boolean original) {
        if (Services.POWER.hasPower((LivingEntity)this, ApugliPowers.FREEZE.get()) && Services.POWER.getPowers((LivingEntity)this, ApugliPowers.FREEZE.get()).stream().anyMatch(p -> !ApugliPowers.FREEZE.get().shouldDamage(p, (Entity)((LivingEntity)this)))) {
            return false;
        }
        return original;
    }

    @ModifyExpressionValue(method={"tryAddFrost"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z")})
    private boolean apugli$addFrostWithPower(boolean original) {
        if (Services.POWER.hasPower((LivingEntity)this, ApugliPowers.FREEZE.get())) {
            return false;
        }
        return original;
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getTicksFrozen()I")})
    private void apugli$freezeEntityFromPower(CallbackInfo ci) {
        if (Services.POWER.hasPower((LivingEntity)this, ApugliPowers.FREEZE.get())) {
            this.f_146809_ = this.f_146808_;
            this.f_146808_ = true;
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;removeFrost()V")})
    private void apugli$unfreezeEntityFromPower(CallbackInfo ci) {
        if (Services.POWER.hasPower((LivingEntity)this, ApugliPowers.FREEZE.get())) {
            this.f_146808_ = this.f_146809_;
        }
    }

    @Inject(method={"getDrinkingSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$getDrinkSound(ItemStack stack, CallbackInfoReturnable<SoundEvent> cir) {
        LivingEntity living = (LivingEntity)this;
        Optional<EdibleItemPower> power = Services.POWER.getPowers(living, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(living.m_9236_(), stack) && p.getSound() != null).findFirst();
        power.ifPresent(edibleItemPower -> cir.setReturnValue((Object)edibleItemPower.getSound()));
    }

    @Inject(method={"getEatingSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$getEatSound(ItemStack stack, CallbackInfoReturnable<SoundEvent> cir) {
        LivingEntity living = (LivingEntity)this;
        Optional<EdibleItemPower> power = Services.POWER.getPowers(living, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(living.m_9236_(), stack) && p.getSound() != null).findFirst();
        power.ifPresent(edibleItemPower -> cir.setReturnValue((Object)edibleItemPower.getSound()));
    }
}

