/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.integration.pehkui;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.access.ScaleDataAccess;
import net.merchantpug.apugli.integration.pehkui.PehkuiUtil;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.TypedScaleModifier;

public class ApoliScaleModifier<P>
extends ScaleModifier {
    private static final float EPSILON = 1.0E-4f;
    protected final P power;
    protected LivingEntity owner;
    protected final int powerPriority;
    protected final List<?> modifiers;
    protected final Map<ResourceLocation, Float> cachedTargetScales = new HashMap<ResourceLocation, Float>();
    protected final Map<ResourceLocation, Float> cachedPreviousTargetScales = new HashMap<ResourceLocation, Float>();
    protected final Map<ResourceLocation, Float> checkScales = new HashMap<ResourceLocation, Float>();
    protected final Set<ResourceLocation> shouldUpdateModifiers = new HashSet<ResourceLocation>();
    protected final Set<ResourceLocation> shouldUpdatePreviousModifiers = new HashSet<ResourceLocation>();
    protected final Set<ResourceLocation> cachedScaleIds;
    private boolean addedScales = false;
    protected boolean shouldUpdate = false;
    protected boolean shouldUpdatePrevious = false;
    private boolean hasLoggedWarn = false;

    public ApoliScaleModifier(P power, LivingEntity entity, List<?> modifiers, Set<ResourceLocation> cachedScaleIds, int powerPriority) {
        super(Float.MIN_VALUE);
        this.power = power;
        this.owner = entity;
        this.modifiers = ImmutableList.copyOf(modifiers);
        this.cachedScaleIds = ImmutableSet.copyOf(cachedScaleIds);
        this.powerPriority = powerPriority;
    }

    public int compareTo(ScaleModifier o) {
        if (!(o instanceof ApoliScaleModifier)) {
            return Float.compare(o.getPriority(), this.getPriority());
        }
        ApoliScaleModifier ao = (ApoliScaleModifier)o;
        int c = Integer.compare(this.powerPriority, ao.powerPriority);
        int n = c = c != 0 ? c : Boolean.compare(this.doModifiersContainTypedOfAnother((Entity)this.owner, ao), ao.doModifiersContainTypedOfAnother((Entity)ao.owner, this));
        if (this.modifiers.isEmpty() || ao.modifiers.isEmpty()) {
            c = c != 0 ? c : Boolean.compare(this.modifiers.isEmpty(), ao.modifiers.isEmpty());
        }
        c = c != 0 ? c : Services.PLATFORM.compareModifiers(this.modifiers.stream().max(Services.PLATFORM::compareModifiers).get(), ao.modifiers.stream().max(Services.PLATFORM::compareModifiers).get());
        c = c != 0 ? c : this.getId().compareTo(ao.getId());
        return c;
    }

    public boolean doModifiersContainTypedOfAnother(Entity entity, ApoliScaleModifier<?> other) {
        return this.getCachedScaleIds().stream().map(PehkuiUtil::getScaleType).anyMatch(type -> type.getScaleData(entity).getBaseValueModifiers().stream().anyMatch(modifier -> {
            if (!(modifier instanceof TypedScaleModifier)) return false;
            TypedScaleModifier typedScaleModifier = (TypedScaleModifier)modifier;
            if (!other.getCachedScaleIds().contains(ScaleRegistries.getId((BiMap)ScaleRegistries.SCALE_TYPES, (Object)typedScaleModifier.getType()))) return false;
            return true;
        }));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ApoliScaleModifier)) {
            return false;
        }
        ApoliScaleModifier apoliScaleModifier = (ApoliScaleModifier)((Object)object);
        return this.getId().equals((Object)apoliScaleModifier.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public Set<ResourceLocation> getCachedScaleIds() {
        return this.cachedScaleIds;
    }

    protected ResourceLocation getResourceLocationFromScaleData(ScaleData data) {
        return ScaleRegistries.getId((BiMap)ScaleRegistries.SCALE_TYPES, (Object)data.getScaleType());
    }

    public CompoundTag serialize(CompoundTag tag) {
        ListTag listTag;
        CompoundTag entryTag;
        if (!this.cachedTargetScales.isEmpty()) {
            ListTag cachedTargetScalesTag = new ListTag();
            for (Map.Entry<ResourceLocation, Float> entry : this.cachedTargetScales.entrySet()) {
                entryTag = new CompoundTag();
                entryTag.m_128359_("Type", entry.getKey().toString());
                entryTag.m_128350_("Value", entry.getValue().floatValue());
                cachedTargetScalesTag.add((Object)entryTag);
            }
            tag.m_128365_("TargetScales", (Tag)cachedTargetScalesTag);
        }
        if (!this.cachedPreviousTargetScales.isEmpty()) {
            ListTag cachedPreviousTargetScalesTag = new ListTag();
            for (Map.Entry<ResourceLocation, Float> entry : this.cachedPreviousTargetScales.entrySet()) {
                entryTag = new CompoundTag();
                entryTag.m_128359_("Type", entry.getKey().toString());
                entryTag.m_128350_("Value", entry.getValue().floatValue());
                cachedPreviousTargetScalesTag.add((Object)entryTag);
            }
            tag.m_128365_("PreviousTargetScales", (Tag)cachedPreviousTargetScalesTag);
        }
        if (!this.checkScales.isEmpty()) {
            ListTag checkScalesTag = new ListTag();
            for (Map.Entry<ResourceLocation, Float> entry : this.checkScales.entrySet()) {
                entryTag = new CompoundTag();
                entryTag.m_128359_("Type", entry.getKey().toString());
                entryTag.m_128350_("Value", entry.getValue().floatValue());
                checkScalesTag.add((Object)entryTag);
            }
            tag.m_128365_("CheckScales", (Tag)checkScalesTag);
        }
        if (!this.shouldUpdateModifiers.isEmpty()) {
            listTag = new ListTag();
            for (ResourceLocation resourceLocation : this.shouldUpdateModifiers) {
                listTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
            }
            tag.m_128365_("ShouldUpdateModifiers", (Tag)listTag);
        }
        if (!this.shouldUpdatePreviousModifiers.isEmpty()) {
            listTag = new ListTag();
            for (ResourceLocation resourceLocation : this.shouldUpdatePreviousModifiers) {
                listTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString()));
            }
            tag.m_128365_("ShouldUpdatePreviousModifiers", (Tag)listTag);
        }
        if (this.shouldUpdate) {
            tag.m_128379_("ShouldUpdate", true);
        }
        if (this.shouldUpdatePrevious) {
            tag.m_128379_("ShouldUpdatePrevious", true);
        }
        return tag;
    }

    public void deserialize(CompoundTag tag, LivingEntity entity) {
        this.addScales(entity);
        this.deserialize(tag, true);
        this.updateAllScales(entity);
    }

    public void deserialize(CompoundTag tag, boolean initialize) {
        ListTag listTag;
        CompoundTag entryTag;
        int i;
        ListTag cachedMaxScaleTag;
        this.cachedTargetScales.clear();
        if (tag.m_128425_("TargetScales", 9)) {
            cachedMaxScaleTag = tag.m_128437_("TargetScales", 10);
            for (i = 0; i < cachedMaxScaleTag.size(); ++i) {
                entryTag = cachedMaxScaleTag.m_128728_(i);
                this.cachedTargetScales.put(new ResourceLocation(entryTag.m_128461_("Type")), Float.valueOf(entryTag.m_128457_("Value")));
            }
        }
        this.cachedPreviousTargetScales.clear();
        if (tag.m_128425_("PreviousTargetScales", 9)) {
            cachedMaxScaleTag = tag.m_128437_("PreviousTargetScales", 10);
            for (i = 0; i < cachedMaxScaleTag.size(); ++i) {
                entryTag = cachedMaxScaleTag.m_128728_(i);
                this.cachedPreviousTargetScales.put(new ResourceLocation(entryTag.m_128461_("Type")), Float.valueOf(entryTag.m_128457_("Value")));
            }
        }
        this.checkScales.clear();
        if (tag.m_128425_("CheckScales", 9)) {
            ListTag checkScalesTag = tag.m_128437_("CheckScales", 10);
            for (i = 0; i < checkScalesTag.size(); ++i) {
                entryTag = checkScalesTag.m_128728_(i);
                this.cachedPreviousTargetScales.put(new ResourceLocation(entryTag.m_128461_("Type")), Float.valueOf(entryTag.m_128457_("Value")));
            }
        }
        this.shouldUpdateModifiers.clear();
        if (tag.m_128425_("ShouldUpdateModifiers", 9)) {
            listTag = tag.m_128437_("ShouldUpdateModifiers", 8);
            for (i = 0; i < listTag.size(); ++i) {
                this.shouldUpdateModifiers.add(new ResourceLocation(listTag.m_128778_(i)));
            }
        }
        this.shouldUpdatePreviousModifiers.clear();
        if (tag.m_128425_("ShouldUpdatePreviousModifiers", 9)) {
            listTag = tag.m_128437_("ShouldUpdatePreviousModifiers", 8);
            for (i = 0; i < listTag.size(); ++i) {
                this.shouldUpdatePreviousModifiers.add(new ResourceLocation(listTag.m_128778_(i)));
            }
        }
        if (tag.m_128425_("ShouldUpdate", 1)) {
            this.shouldUpdate = tag.m_128471_("ShouldUpdate");
        }
        if (tag.m_128425_("ShouldUpdatePrevious", 1)) {
            this.shouldUpdatePrevious = tag.m_128471_("ShouldUpdatePrevious");
        }
    }

    protected void reset() {
        this.addedScales = false;
        this.hasLoggedWarn = false;
        this.shouldUpdate = false;
        this.shouldUpdatePrevious = false;
        this.cachedTargetScales.clear();
        this.cachedPreviousTargetScales.clear();
        this.checkScales.clear();
        this.shouldUpdateModifiers.clear();
        this.shouldUpdatePreviousModifiers.clear();
    }

    protected void addScales(LivingEntity entity) {
        if (!this.addedScales) {
            ScaleType scaleType;
            for (ResourceLocation scaleTypeId : this.getCachedScaleIds()) {
                scaleType = (ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)scaleTypeId);
                ScaleData scaleData = scaleType.getScaleData((Entity)entity);
                ((ScaleDataAccess)scaleData).apugli$removeFromApoliScaleModifiers(this.getId());
                scaleData.getBaseValueModifiers().remove((Object)this);
                ((ScaleDataAccess)scaleData).apugli$addToApoliScaleModifiers(this.getId());
                scaleData.getBaseValueModifiers().add(this);
            }
            for (ResourceLocation scaleTypeId : this.getCachedScaleIds()) {
                scaleType = (ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)scaleTypeId);
                this.updateScale(entity, scaleType);
            }
            if (!entity.m_9236_().m_5776_()) {
                Services.POWER.syncPower(entity, this.power);
            }
            this.addedScales = true;
        }
    }

    public void tick(LivingEntity entity) {
        boolean sync = false;
        for (ResourceLocation typeId : this.getCachedScaleIds()) {
            float value;
            ScaleData data = ((ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)typeId)).getScaleData((Entity)entity);
            boolean isActive = Services.POWER.isActive(this.power, entity);
            float f = value = !isActive ? data.getBaseScale() : (float)Services.PLATFORM.applyModifiers(data.getEntity(), this.modifiers, (double)data.getBaseScale());
            if (ApoliScaleModifier.compareFloats(this.checkScales.getOrDefault(typeId, Float.valueOf(data.getBaseScale())).floatValue(), value)) continue;
            this.checkScales.put(typeId, Float.valueOf(value));
            this.markForUpdating(typeId, false);
            sync = true;
        }
        if (sync) {
            Services.POWER.syncPower(entity, this.power);
            this.updateOthers(entity);
        }
    }

    protected void markForUpdating(ResourceLocation typeId, boolean notOriginalCall) {
        this.shouldUpdateModifiers.add(typeId);
        this.shouldUpdatePreviousModifiers.add(typeId);
        this.shouldUpdate = true;
        this.shouldUpdatePrevious = true;
        if (notOriginalCall) {
            this.cachedTargetScales.clear();
            this.cachedPreviousTargetScales.clear();
        }
    }

    protected void updateIfShould(LivingEntity entity) {
        if (this.shouldUpdate || this.shouldUpdatePrevious) {
            this.updateAllScales(entity);
            this.shouldUpdate = false;
            this.shouldUpdatePrevious = false;
        }
    }

    public void updateOthers(LivingEntity entity) {
        SortedSet<ApoliScaleModifier> tailSet = PehkuiUtil.getModifiersInOrder(entity).tailSet(this);
        for (ApoliScaleModifier modifier : tailSet) {
            if (modifier.getId().equals((Object)this.getId())) continue;
            modifier.getCachedScaleIds().forEach(id -> modifier.markForUpdating((ResourceLocation)id, true));
            Services.POWER.syncPower(entity, modifier.power);
        }
    }

    public void updateAllScales(LivingEntity entity) {
        this.getCachedScaleIds().stream().map(PehkuiUtil::getScaleType).forEach(type -> this.updateScale(entity, (ScaleType)type));
    }

    public void updateScale(LivingEntity entity, ScaleType type) {
        ScaleData data = type.getScaleData((Entity)entity);
        data.onUpdate();
        if (this.shouldUpdate) {
            data.getScale();
        }
        if (this.shouldUpdatePrevious) {
            data.getPrevScale();
        }
    }

    public ResourceLocation getId() {
        return ApugliPowers.MODIFY_SCALE.get().getPowerId(this.power);
    }

    public ResourceLocation getPowerId() {
        return ApugliPowers.MODIFY_SCALE.get().getPowerId(this.power);
    }

    public float modifyScale(ScaleData scaleData, float modifiedScale, float delta) {
        Entity entity = scaleData.getEntity();
        if (!(entity instanceof LivingEntity)) {
            this.logWarn();
            return modifiedScale;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ResourceLocation id = this.getResourceLocationFromScaleData(scaleData);
        if (!Services.POWER.isActive(this.power, entity2)) {
            return modifiedScale;
        }
        if (this.shouldUpdateModifiers.contains(id)) {
            this.cachedTargetScales.put(id, Float.valueOf((float)Services.PLATFORM.applyModifiers(scaleData.getEntity(), this.modifiers, (double)modifiedScale)));
        }
        return this.cachedTargetScales.getOrDefault(id, Float.valueOf(modifiedScale)).floatValue();
    }

    public float modifyPrevScale(ScaleData scaleData, float modifiedScale) {
        Entity entity = scaleData.getEntity();
        if (!(entity instanceof LivingEntity)) {
            this.logWarn();
            return modifiedScale;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ResourceLocation id = this.getResourceLocationFromScaleData(scaleData);
        if (!Services.POWER.isActive(this.power, entity2)) {
            return modifiedScale;
        }
        if (this.shouldUpdatePreviousModifiers.contains(id)) {
            this.cachedPreviousTargetScales.put(id, Float.valueOf((float)Services.PLATFORM.applyModifiers((Entity)entity2, this.modifiers, (double)modifiedScale)));
        }
        return this.cachedPreviousTargetScales.getOrDefault(id, Float.valueOf(modifiedScale)).floatValue();
    }

    protected static boolean compareFloats(float a, float b) {
        float diff = Mth.m_14154_((float)(a - b));
        return diff < 1.0E-4f;
    }

    protected void logWarn() {
        if (!this.hasLoggedWarn) {
            Apugli.LOG.warn("Attempted to use ApoliScaleModifier on a non-living entity. This should not be possible.");
        }
        this.hasLoggedWarn = true;
    }
}

