/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.entity;

import io.github.apace100.calio.data.SerializableData;
import javax.annotation.Nullable;
import net.merchantpug.apugli.mixin.xplatform.common.accessor.ProjectileEntityAccessor;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.ApugliEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class CustomProjectile
extends ThrowableProjectile {
    private static final EntityDataAccessor<String> DATA_ENTITY_ID = SynchedEntityData.m_135353_(CustomProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_URL_LOCATION = SynchedEntityData.m_135353_(CustomProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_TEXTURE_LOCATION = SynchedEntityData.m_135353_(CustomProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private Object impactBlockAction;
    private Object missBiEntityAction;
    private Object impactBiEntityAction;
    private Object ownerImpactBiEntityAction;
    private boolean blockActionCancelsMissAction;
    private Object blockCondition;
    private Object biEntityCondition;
    private Object ownerBiEntityCondition;
    private Object tickBiEntityAction;

    public CustomProjectile(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public CustomProjectile(double d, double e, double f, LivingEntity owner, Level level) {
        super(ApugliEntityTypes.CUSTOM_PROJECTILE.get(), d, e, f, level);
        this.m_5602_((Entity)owner);
    }

    protected boolean m_5603_(Entity target) {
        if (!target.m_5833_() && target.m_6084_() && target.m_6087_()) {
            Entity entity = this.m_19749_();
            return (entity == null || ((ProjectileEntityAccessor)((Object)this)).apugli$getLeftOwner() || !entity.m_20365_(target)) && entity != null && Services.CONDITION.checkBiEntity(this.biEntityCondition, (Entity)this, target) && Services.CONDITION.checkBiEntity(this.ownerBiEntityCondition, entity, target);
        }
        return false;
    }

    public Entity m_19749_() {
        Level level;
        ProjectileEntityAccessor accessor = (ProjectileEntityAccessor)((Object)this);
        if (accessor.apugli$getCachedOwner() != null && !this.isOwnerRemovedOrDiscarded()) {
            return accessor.apugli$getCachedOwner();
        }
        if (accessor.apugli$getOwnerUUID() != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            accessor.apugli$setCachedOwner(serverLevel.m_8791_(accessor.apugli$getOwnerUUID()));
            return accessor.apugli$getCachedOwner();
        }
        return null;
    }

    private boolean isOwnerRemovedOrDiscarded() {
        ProjectileEntityAccessor accessor = (ProjectileEntityAccessor)((Object)this);
        if (accessor.apugli$getCachedOwner() == null) {
            return false;
        }
        return accessor.apugli$getCachedOwner().m_146911_() == Entity.RemovalReason.KILLED || accessor.apugli$getCachedOwner().m_146911_() == Entity.RemovalReason.DISCARDED;
    }

    public void m_5790_(EntityHitResult result) {
        Services.ACTION.executeBiEntity(this.impactBiEntityAction, (Entity)this, result.m_82443_());
        Services.ACTION.executeBiEntity(this.ownerImpactBiEntityAction, this.m_19749_(), result.m_82443_());
        this.m_146870_();
    }

    public void m_8060_(BlockHitResult result) {
        boolean executedBlockAction = false;
        if (this.impactBlockAction != null && Services.CONDITION.checkBlock(this.blockCondition, this.m_9236_(), result.m_82425_())) {
            Services.ACTION.executeBlock(this.impactBlockAction, this.m_9236_(), result.m_82425_(), result.m_82434_());
            executedBlockAction = true;
        }
        if (!executedBlockAction || !this.blockActionCancelsMissAction) {
            Services.ACTION.executeBiEntity(this.missBiEntityAction, this.m_19749_(), (Entity)this);
        }
        BlockState blockState = this.m_9236_().m_8055_(result.m_82425_());
        blockState.m_60669_(this.m_9236_(), blockState, result, (Projectile)this);
        this.m_146870_();
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ENTITY_ID, (Object)"");
        this.m_20088_().m_135372_(DATA_URL_LOCATION, (Object)"");
        this.m_20088_().m_135372_(DATA_TEXTURE_LOCATION, (Object)"");
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isOwnerRemovedOrDiscarded()) {
            this.m_146870_();
            return;
        }
        Services.ACTION.executeBiEntity(this.tickBiEntityAction, this.m_19749_(), (Entity)this);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (!((String)this.m_20088_().m_135370_(DATA_ENTITY_ID)).equals("")) {
            compound.m_128359_("EntityId", (String)this.m_20088_().m_135370_(DATA_ENTITY_ID));
        }
        if (!((String)this.m_20088_().m_135370_(DATA_TEXTURE_LOCATION)).equals("")) {
            compound.m_128359_("TextureLocation", (String)this.m_20088_().m_135370_(DATA_TEXTURE_LOCATION));
        }
        if (!((String)this.m_20088_().m_135370_(DATA_URL_LOCATION)).equals("")) {
            compound.m_128359_("UrlLocation", (String)this.m_20088_().m_135370_(DATA_URL_LOCATION));
        }
        Services.ACTION.writeBlockActionToNbt(compound, "ImpactBlockAction", this.impactBlockAction);
        Services.ACTION.writeBiEntityActionToNbt(compound, "MissBiEntityAction", this.missBiEntityAction);
        Services.ACTION.writeBiEntityActionToNbt(compound, "ImpactBiEntityAction", this.impactBiEntityAction);
        Services.ACTION.writeBiEntityActionToNbt(compound, "OwnerImpactBiEntityAction", this.ownerImpactBiEntityAction);
        Services.ACTION.writeBiEntityActionToNbt(compound, "TickBiEntityAction", this.tickBiEntityAction);
        Services.CONDITION.writeBlockConditionToNbt(compound, "BlockCondition", this.blockCondition);
        Services.CONDITION.writeBiEntityConditionToNbt(compound, "BiEntityCondition", this.biEntityCondition);
        Services.CONDITION.writeBiEntityConditionToNbt(compound, "OwnerBiEntityCondition", this.ownerBiEntityCondition);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("EntityId", 8)) {
            this.m_20088_().m_135381_(DATA_ENTITY_ID, (Object)compound.m_128461_("EntityId"));
        }
        if (compound.m_128425_("TextureLocation", 8)) {
            this.m_20088_().m_135381_(DATA_TEXTURE_LOCATION, (Object)compound.m_128461_("TextureLocation"));
        }
        if (compound.m_128425_("UrlLocation", 8)) {
            this.m_20088_().m_135381_(DATA_URL_LOCATION, (Object)compound.m_128461_("UrlLocation"));
        }
        this.impactBlockAction = Services.ACTION.readBlockActionFromNbt(compound, "ImpactBlockAction");
        this.missBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "MissBiEntityAction");
        this.impactBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "ImpactBiEntityAction");
        this.ownerImpactBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "OwnerImpactBiEntityAction");
        this.tickBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "TickBiEntityAction");
        this.blockCondition = Services.CONDITION.readBlockConditionFromNbt(compound, "BlockCondition");
        this.biEntityCondition = Services.CONDITION.readBiEntityConditionFromNbt(compound, "BiEntityCondition");
        this.ownerBiEntityCondition = Services.CONDITION.readBiEntityConditionFromNbt(compound, "OwnerBiEntityCondition");
    }

    public ResourceLocation getEntityId() {
        return new ResourceLocation((String)this.m_20088_().m_135370_(DATA_ENTITY_ID));
    }

    public ResourceLocation getUrlLocation() {
        if (((String)this.m_20088_().m_135370_(DATA_URL_LOCATION)).equals("")) {
            return null;
        }
        return new ResourceLocation((String)this.m_20088_().m_135370_(DATA_URL_LOCATION));
    }

    public ResourceLocation getTextureLocation() {
        if (((String)this.m_20088_().m_135370_(DATA_TEXTURE_LOCATION)).equals("")) {
            return null;
        }
        return new ResourceLocation((String)this.m_20088_().m_135370_(DATA_TEXTURE_LOCATION));
    }

    public void setEntityId(ResourceLocation location) {
        this.m_20088_().m_135381_(DATA_ENTITY_ID, (Object)location.toString());
    }

    public void setUrlLocation(ResourceLocation location) {
        this.m_20088_().m_135381_(DATA_URL_LOCATION, (Object)location.toString());
    }

    public void setTextureLocation(@Nullable ResourceLocation location) {
        if (location != null) {
            this.m_20088_().m_135381_(DATA_TEXTURE_LOCATION, (Object)location.toString());
        }
    }

    public void setBlockActionCancelsMissAction(boolean value) {
        this.blockActionCancelsMissAction = value;
    }

    public void setImpactBlockAction(SerializableData.Instance data, String fieldName) {
        this.impactBlockAction = data.get(fieldName);
    }

    public void setMissBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.missBiEntityAction = data.get(fieldName);
    }

    public void setImpactBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.impactBiEntityAction = data.get(fieldName);
    }

    public void setOwnerImpactBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.ownerImpactBiEntityAction = data.get(fieldName);
    }

    public void setBlockCondition(SerializableData.Instance data, String fieldName) {
        this.blockCondition = data.get(fieldName);
    }

    public void setBiEntityCondition(SerializableData.Instance data, String fieldName) {
        this.biEntityCondition = data.get(fieldName);
    }

    public void setOwnerBiEntityCondition(SerializableData.Instance data, String fieldName) {
        this.ownerBiEntityCondition = data.get(fieldName);
    }

    public void setTickBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.tickBiEntityAction = data.get(fieldName);
    }
}

